
/*************************************************************************
**									**
**	MODULE NAME 	:	3d.h					**
**									**
**	MODULE TYPE 	:	Header for point/vector def. module	**
**									**
**	MODULE AUTHOR 	:	Philip J. Schneider			*
**                                                                      **
**      Modified        :       Lian Wang                               **
**************************************************************************
*************************************************************************/

/************************************************************************
*									*
*			3d.h : type definitions				*
*									*
************************************************************************/

typedef	struct Point3 {		/* Declare type Point			*/
    double x;			/* x-coordinate				*/
    double y;			/* y-coordinate				*/
    double z;                   /* z-coordinate                         */
} Point3;

typedef Point3	Vector3;

/************************************************************************
*									*
*		3d.h : procedure declarations				*
*									*
************************************************************************/

extern	double	V3Dot();
extern	double	V3DistanceBetween2Points();
extern	Vector3	*V3Negate();
extern	Vector3	*V3Scale();
extern	double	V3Length();
extern	double	V3SquaredLength();
extern	Vector3	*V3Normalize();
extern	Vector3	*V3Add();



/* XXX NEW STUFF 
extern	Vector3	*V3Sub();
extern	Vector3	V3AddII();
extern	Vector3	V3ScaleII();
*/
