 /*
  File: OnePathFence.c
  Author: K.R. Sloan, Jr., James Painter, David Meyers
  Last Modified: 8 November 1989
  Purpose: searching toroidal graphs
 */

#include <stdio.h>
#include <math.h>
#include <Boolean.h>
#include <TypeDefinitions.h>
#include <TorGraph.h>

extern outputTrace;
extern outputPaths;

   
REAL OnePathFence( StartRow, StartCol,
                     LeftPath, RightPath, G, P) 
 int StartRow, StartCol;
 PathType *LeftPath, *RightPath;
 GraphType *G;
 PathType *P;
 {
  int RelR, RelC;       /* Current Row and Col relative to StartRow */
  int RelSC, RelEC, RelLastEC;
  int AbsR, AbsC;       /* Absolute row and column within 4 copies of graph */
  int AbsSC, AbsEC, AbsLastR;
  int AbsModR;          /* Current row mod row in graph */
  REAL FromAbove, FromLeft;
  NodeType *N;
  PSNodeType *PSN, *U_PSN, *L_PSN;

  RelEC = -1;
  G->PSN[0][0].BestCost = 0.0;
  AbsLastR = StartRow-1;
  if (AbsLastR < 0) AbsLastR += 2*G->Rows;
  for (RelR = 0, AbsR = StartRow; RelR <= G->Rows; RelR++, AbsR++ )
   {
    RelLastEC = RelEC;
    if (AbsR == 2*G->Rows) AbsR = 0;

    /*
    **  Figure out where the scan should start and end in the current row.
    */
    AbsSC = LeftPath->LeavesRowInCol[AbsLastR];
    AbsEC = RightPath->LeavesRowInCol[AbsR];
    RelSC = (AbsSC + 2*G->Columns - StartCol) % (2*G->Columns);
    RelEC = (AbsEC + 2*G->Columns - StartCol) % (2*G->Columns);

    if (  (RelSC <= RelEC) && (RelEC <= G->Columns) )
       ;  /* Everything is normal... Nothing special to do here. */
    else if ((RelEC <= G->Columns) && (G->Columns < RelSC))
     {
      RelSC = 0;  /* Bottom path still has not meet the starting column */
      AbsSC = StartCol;
     }
    else if (   ((RelSC <= G->Columns) && (G->Columns < RelEC))
             || ((RelEC < RelSC) && (RelSC <= G->Columns))
            )
     {
      RelEC = G->Columns;  /* Top path has run off the right side */
      AbsEC = 0;
     }
    else
     {
      RelSC = 0;  /* Must be both */
      AbsSC = StartCol;
      RelEC = G->Columns;  /* Top path has run off the right side */
      AbsEC = 0;
     }
    AbsSC %= G->Columns;
    AbsModR = AbsR % G->Rows;
    RelC = RelSC;
    AbsC = AbsSC;

    /*
    **  Set up pointers to the pertainent structures to speed up the scan
    **  and handle the left most node (Don`t look left).
    */
    N = &(G->N[AbsModR][AbsC]);   /* Points to current N */
    PSN = &(G->PSN[RelR][RelC]);  /* Points to current PSN */
    if (RelR != 0)  
     {
      U_PSN = &(G->PSN[RelR-1][RelC]);  /* Points to entry above */
      PSN->BestCost = U_PSN->BestCost + N->UpCost;
      PSN->WhichWay = UP;
     }
  
    /*
    **  Scan as far as we can while looking both left and up
    */
    for (
         RelC++, AbsC++, L_PSN = PSN, PSN++, U_PSN++, N++;
         RelC <= RelLastEC;
         RelC++, AbsC++, L_PSN = PSN, PSN++, U_PSN++, N++
        )
     {
      if (AbsC == G->Columns)
       {
        AbsC = 0;
        N = &(G->N[AbsModR][AbsC]);   
       }

      FromAbove = N->UpCost   + U_PSN->BestCost;
      FromLeft  = N->LeftCost + L_PSN->BestCost;
      if (FromAbove <= FromLeft)
       {
        PSN->BestCost = FromAbove;
        PSN->WhichWay = UP;
       }  
      else
       {
        PSN->BestCost = FromLeft;
        PSN->WhichWay = LEFT;
       }
     }

    /*
    **  Scan the rest of the way looking only left.
    */
    for ( ;
         RelC <= RelEC;
         RelC++, AbsC++, L_PSN = PSN, PSN++, N++
        )
     {
      if (AbsC == G->Columns)
       {
        AbsC = 0;
        N = &(G->N[AbsModR][AbsC]);   
       }
      PSN->BestCost = N->LeftCost   + L_PSN->BestCost;
      PSN->WhichWay = LEFT;
     }
    AbsLastR = AbsR;
   }

  /*
  ** Store the path.
  */
  FillPath( G, StartRow, StartCol, P );
  return G->PSN[G->Rows][G->Columns].BestCost;
 }
