/***********************************************************************\
* 								        *
* File: MkCostGraph.c						        *
* Purpose:  Allocate memory for, and fill the cost graph for a pair of  *
*           contours.						        *
* Author:  James Painter					        *
* Last Modified: 8 November 1989				        *
* 								        *
\***********************************************************************/

#include <stdio.h>
#include <TypeDefinitions.h>
#include <Contours.h>
#include <TorGraph.h>

GraphType *
MakeCostGraph ( Contour1, Contour2, CostFunction, MinCost, MaxCost )
 PointsType *Contour1, *Contour2;
 REAL (* CostFunction)();  /* Takes 3 triangle verticies and returns cost */
 REAL *MinCost, *MaxCost;
 {
  GraphType *G;
  int R, LR, C, LC;

  *MinCost =  1.0E38;
  *MaxCost = -1.0E38;

  if (! (  G = NewGraph ( Contour1->n, Contour2->n ) ))
    return (GraphType *) NULL;
  /*
  **  Fill in the graph with the costs associated with each arc.
  */
  for (R=0,LR=G->Rows-1; R < G->Rows; R++, LR++ )
   {
    if (LR==G->Rows) LR = 0;
    for (C=0,LC=G->Columns-1; C < G->Columns; C++, LC++ )
     {
      if (LC==G->Columns) LC = 0;
      G->N[R][C].UpCost = (*CostFunction)(&Contour2->P[C],
                                          &Contour1->P[LR],
					  &Contour1->P[R] );
      if (*MinCost > G->N[R][C].UpCost) *MinCost = G->N[R][C].UpCost;
      if (*MaxCost < G->N[R][C].UpCost) *MaxCost = G->N[R][C].UpCost;
      G->N[R][C].LeftCost = (*CostFunction) ( &Contour1->P[R],
                                              &Contour2->P[C],
                                              &Contour2->P[LC] );
      if (*MinCost > G->N[R][C].LeftCost) *MinCost = G->N[R][C].LeftCost;
      if (*MaxCost < G->N[R][C].LeftCost) *MaxCost = G->N[R][C].LeftCost;
     }
   }
  return G;
 }

