/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _realtek.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for RealTek RT3106 SuperVGA's.
*               Contains detection code, mode translation tables and chipset
*               names.
*
* $Id: _realtek.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _realtek.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short REALTEKModes[] = {0x1F, 0,        /* 800x600 16 color     */
                        0x21, 0,        /* 1024x768 16 color    */
                        0x2A, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x25, 0,        /* 640x400 256 color    */
                        0x26, 0,        /* 640x480 256 color    */
                        0x27, 0,        /* 800x600 256 color    */
                        0x28, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x38, 0,        /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0x3A, 0,        /* 640x400 64k color    */
                        0x3B, 0,        /* 640x480 64k color    */
                        0x3C, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grREALTEK_RT3106,       /* RealTek RT3106 SuperVGA chip             */
    } RealTek_chipsets;

/* Names of chip revision id's. */

char *RealTekNames[] = {
    "RT3106",
    };

bool findRealTek(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findRealTek
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of RealTek based SuperVGA's.
*
****************************************************************************/
{
    int version,mem;

    if (!tstinx(CRTC,0x1F,3))       /* Test for scratch register        */
        goto NoRealTek;
    if (!tstreg(0x3D6,0xF))         /* Test for bank switch register    */
        goto NoRealTek;
    if (!tstreg(0x3D7,0xF))         /* Test for bank switch register    */
        goto NoRealTek;

    /* We have a RealTek SuperVGA */

    *superVGA = grSVGA_REALTEK;
    *chipID = grREALTEK_RT3106;
    *pageFlip = true;

    version = rdinx(CRTC,0x1A) >> 6;
    mem = rdinx(CRTC,0x1E) & 0xF;
    switch (mem) {
        case 0: *memory = 256;  break;
        case 1: *memory = 512;  break;
        case 2: if (version) *memory = 1024; else *memory = 512; break;
        case 3: if (version) *memory = 2048; else *memory = 1024; break;
        }
    return true;

NoRealTek:
    return false;
}
