;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _primus.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for Primus P2000
;*              SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _primus.asm 1.2 1993/09/24 05:23:19 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _primus.asm $
;* Revision 1.2  1993/09/24  05:23:19  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:54  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; PRIMUS_bank   Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    PRIMUS_bank far

		push    ax
        push    dx
        mov     dx,3D6h
        out     dx,al               ; Set write bank register
        inc     dx
        out     dx,al               ; Set read bank
        pop     dx
        pop     ax
		ret

ENDP    PRIMUS_bank

PRIMUS_bank_len     =   ($-PRIMUS_bank)

;----------------------------------------------------------------------------
; PRIMUS_rbank  Change to a new 64k read bank (reading only)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    PRIMUS_rbank    far

		push    ax
        push    dx
        mov     dx,3D7h
        out     dx,al               ; Set read bank
        pop     dx
        pop     ax
		ret

ENDP    PRIMUS_rbank

PRIMUS_rbank_len        =   ($-PRIMUS_rbank)

;----------------------------------------------------------------------------
; PRIMUS_page   Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    PRIMUS_page far

        SetLowStartAddress
        mov     dx,3CEh
        mov     al,21h              ; Index of start address register
        out     dx,al
        inc     dx
        in      al,dx               ; Read old value
        and     al,0F8h             ; Clear out bottom 3 bits
        and     bl,7                ; Mask off bottom three bits
        or      al,bl               ; Or in starting address value
        out     dx,al               ; Set the new value
        ret

ENDP    PRIMUS_page

PRIMUS_page_len     =   ($-PRIMUS_page)

;----------------------------------------------------------------------------
; PRIMUS_setup  Setup the SuperVGA for correct operation
;----------------------------------------------------------------------------
PROC    PRIMUS_setup    near

        cmp     [CntColors],gr64kColor
        jne     @@Done
        mov     dx,3C8h
        in      al,dx               ; Set DAC to PEL mode
        mov     dx,3C6h
        in      al,dx
        in      al,dx
        in      al,dx
        in      al,dx               ; Set DAC to command mode
        mov     al,0C0h             ; Set DAC to 64k color mode
        out     dx,al
@@Done:
        ret

ENDP    PRIMUS_setup

PRIMUS_setup_len    =   ($-PRIMUS_setup)

;----------------------------------------------------------------------------
; PRIMUS_init
;----------------------------------------------------------------------------
; We have a PRIMUS SuperVGA, so setup the appropriate vectors.
;----------------------------------------------------------------------------
PROC    PRIMUS_init

        mov     [TwoBanks],true
        mov     [WriteBank16],offset PRIMUS_bank
        mov     [WriteBank16Len],PRIMUS_bank_len
        mov     [WriteBank256],offset PRIMUS_bank
        mov     [WriteBank256Len],PRIMUS_bank_len
        mov     [ReadBank16],offset PRIMUS_rbank
        mov     [ReadBank16Len],PRIMUS_rbank_len
        mov     [ReadBank256],offset PRIMUS_rbank
        mov     [ReadBank256Len],PRIMUS_rbank_len
		mov     [NewPage16],offset PRIMUS_page
		mov     [NewPage16Len],PRIMUS_page_len
		mov     [NewPage256],offset PRIMUS_page
        mov     [NewPage256Len],PRIMUS_page_len
		mov     [SetupSVGA],offset PRIMUS_setup
        mov     [SetupSVGALen],PRIMUS_setup_len
        ret

ENDP    PRIMUS_init
