/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _oak.c $
* Version:      $Revision: 1.2 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Oak SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _oak.c 1.2 1993/09/24 05:22:30 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _oak.c $
* Revision 1.2  1993/09/24  05:22:30  kjb
* Fixed a number of bugs.
*
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short OAKModes[] = {    0x52, 0,        /* 800x600 16 color     */
                        0x56, 0,        /* 1024x768 16 color    */
                        0x58, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x53, 0,        /* 640x480 256 color    */
                        0x54, 0,        /* 800x600 256 color    */
                        0x59, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0x5B, 0,        /* 640x400 32k color    */
                        0x5C, 0,        /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grOAK_037C,             /* Oak OTI-037C chipset                     */
    grOAK_057,              /* Oak OTI-057 chipset                      */
    grOAK_067,              /* Oak OTI-067 chipset                      */
    grOAK_077,              /* Oak OTI-077 chipset                      */
    grOAK_087,              /* Oak OTI-087 chipset                      */
    } OAK_chipsets;

/* Names of chip revision id's. */

char *OakNames[] = {
    "OTI-037C",
    "OTI-057",
    "OTI-067",
    "OTI-077",
    "OTI-087",
    };

bool findOak(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findOak
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Oak based SuperVGA's.
*
****************************************************************************/
{
    int chip,mem;

    if (!tstinx(0x3DE,0xD,0x38))    /* Test for memory size register    */
        goto NoOak;

    /* We have an Oak Technologies SuperVGA */

    *superVGA = grSVGA_OAKTECH;
	*pageFlip = true;

    if (tstinx(0x3DE,0x23,0x1F)) {
        *chipID = grOAK_087;
        mem = rdinx(0x3DE,0x2) & 0x6;
        switch (mem) {
            case 0: *memory = 256;  break;
            case 2: *memory = 512;  break;
            case 4: *memory = 1024; break;
            case 6: *memory = 2048; break;
            }
        }
    else {
        chip = inp(0x3DE) >> 5;
        switch (chip) {
            case 0: *chipID = grOAK_037C;   break;
            case 2: *chipID = grOAK_067;    break;
            case 5: *chipID = grOAK_077;    break;
            case 7: *chipID = grOAK_057;    break;
            }

        if (*chipID != grOAK_077)
            unsupportedMode(vbe_1024x768x256,OAKModes);

        mem = rdinx(0x3DE,0xD) >> 6;
        switch (mem) {
            case 0:     *memory = 256;  break;
            case 2:     *memory = 512;  break;
            default:    *memory = 1024; break;
            }
        }
    return true;

NoOak:
    return false;
}
