/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _mxic.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for MXIC SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _mxic.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _mxic.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short MXICModes[] = {   0x55, 0,        /* 800x600 16 color     */
                        0x56, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0x57, 0,        /* 640x350 256 color    */
                        0x58, 0,        /* 640x400 256 color    */
                        0x59, 0,        /* 640x480 256 color    */
                        0x5A, 0,        /* 800x600 256 color    */
                        0x5B, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grMXIC_68010,           /* MXIC 68010 chipset                   */
    } MXIC_chipsets;

/* Names of chip revision id's. */

char *MXICNames[] = {
    "68010",
    };

bool findMXIC(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findMXIC
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of MXIC based SuperVGA's.
*
****************************************************************************/
{
    int old,mem;

    old = rdinx(SEQ,0xA7);
    wrinx(SEQ,0xA7,0);              /* Disable extended registers       */
    if (tstinx(SEQ,0xC5,0xFF))
        goto NoMXIC;
    wrinx(SEQ,0xA7,0x87);           /* Enable extended registers        */
    if (!tstinx(SEQ,0xC5,0xFF))
        goto NoMXIC;

    /* We have an MXIC SuperVGA */

    *superVGA = grSVGA_MXIC;
    *pageFlip = true;
    *chipID = grMXIC_68010;

    mem = (rdinx(SEQ,0xC2) >> 2) & 3;
    switch (mem) {
        case 0: *memory = 256;  break;
        case 1: *memory = 512;  break;
        case 2: *memory = 1024; break;
        }
    return true;

NoMXIC:
    wrinx(SEQ,0xA7,old);
    return false;
}
