;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _everex.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for Everex SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _everex.asm 1.2 1993/09/24 05:23:19 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _everex.asm $
;* Revision 1.2  1993/09/24  05:23:19  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:54  kjb
;* Initial revision
;*
;****************************************************************************

grEVEREX_EvNR       =   0   ; Everex normal chipset
grEVEREX_Ev236      =   1   ; Everex Ev236 chipset (Trident)
grEVEREX_Ev620      =   2   ; Everex Ev620 chipset (Trident)
grEVEREX_Ev629      =   3   ; Everex Ev629 chipset (ET4000)
grEVEREX_Ev673      =   4   ; Everex Ev673 chipset (Trident)
grEVEREX_Ev678      =   5   ; Everex Ev678 chipset (Trident)

;----------------------------------------------------------------------------
; EVEREX_bank   Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    EVEREX_bank far

		push    ax
        push    dx
        push    cx
        mov     cl,al
        mov     dx,3C4h
        mov     al,8
        out     dx,al
        inc     dl
        in      al,dx
        dec     dl
        shl     al,1
        shr     cl,1
        rcr     al,1
        mov     ah,al
        mov     al,8
        out     dx,ax               ; Bit 0 stored in 3C4 index 8 bit 7
        mov     dl,0CCh
        in      al,dx
        mov     dl,0C2h
        and     al,0DFh
        shr     cl,1
        jc      @@Nob2
        or      al,20h
@@Nob2: out     dx,al               ; Bit 1 stored in 3C2 bit 5
        pop     cx
        pop     dx
        pop     ax
		ret

ENDP    EVEREX_bank

EVEREX_bank_len =   ($-EVEREX_bank)

;----------------------------------------------------------------------------
; EVEREX_init
;----------------------------------------------------------------------------
; Some Everex video boards are based on Trident or ET4000 chips. Detect
; them here, and setup to use the correct bank switching and page flipping
; routines.
;----------------------------------------------------------------------------
PROC    EVEREX_init     near

        mov     ax,[CntChipID]      ; AX := chipset ID
        cmp     ax,grEVEREX_Ev236   ; UltraGraphics - Trident Chip
        je      @@TridentChip
        cmp     ax,grEVEREX_Ev620   ; Vision VGA - Trident Chip
        je      @@TridentChip
        cmp     ax,grEVEREX_Ev629   ; ViewPoint TC - ET4000 Chip
        je      @@ET4000Chip
        cmp     ax,grEVEREX_Ev673   ; EVGA - Trident Chip
        je      @@TridentChip
        cmp     ax,grEVEREX_Ev678   ; Viewpoint - Trident Chip
        je      @@TridentChip

; Normal Everex EvNR chipset.

        mov     [TwoBanks],false
        mov     [WriteBank16],offset EVEREX_bank
        mov     [WriteBank16Len],EVEREX_bank_len
        mov     [WriteBank256],offset EVEREX_bank
        mov     [WriteBank256Len],EVEREX_bank_len
        ret

; Based on Trident chip, so determine the type (8800 or 8900).

@@TridentChip:
        mov     [TwoBanks],false
        mov     [WriteBank16],offset TRIDENT_bank
        mov     [WriteBank16Len],TRIDENT_bank_len
        mov     [WriteBank256],offset TRIDENT_bank
        mov     [WriteBank256Len],TRIDENT_bank_len
		mov     [NewPage16],offset TRIDENT88_page
		mov     [NewPage16Len],TRIDENT88_page_len
		mov     [NewPage256],offset TRIDENT88_page
		mov     [NewPage256Len],TRIDENT88_page_len

		wrinx   3C4h, 0Bh, 0        ; Force old definitions
		inp     3C5h                ; Force new definitions
		and     al,0Fh
		cmp     al,2
		je      @@1                 ; Done for Trident 8800
		mov     [NewPage16],offset TRIDENT89_page
		mov     [NewPage16Len],TRIDENT89_page_len
		mov     [NewPage256],offset TRIDENT89_page
		mov     [NewPage256Len],TRIDENT89_page_len
		mov     [SetupSVGA],offset TRIDENT89_setup
		mov     [SetupSVGALen],TRIDENT89_setup_len
@@1:    ret

@@ET4000Chip:
        mov     [TwoBanks],true
        mov     [WriteBank16],offset ET4000_bank
        mov     [WriteBank16Len],ET4000_bank_len
        mov     [WriteBank256],offset ET4000_bank
        mov     [WriteBank256Len],ET4000_bank_len
        mov     [ReadBank16],offset ET4000_rbank
        mov     [ReadBank16Len],ET4000_rbank_len
        mov     [ReadBank256],offset ET4000_rbank
        mov     [ReadBank256Len],ET4000_rbank_len
		mov     [NewPage16],offset ET4000_page
		mov     [NewPage16Len],ET4000_page_len
		mov     [NewPage256],offset ET4000_page
		mov     [NewPage256Len],ET4000_page_len
		ret

ENDP    EVEREX_init
