/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _chips.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Chips & Technologies
*               SuperVGA's. Contains detection code, mode translation
*               tables and chipset names.
*
* $Id: _chips.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _chips.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short CHIPSModes[] = {  0x70, 0,        /* 800x600 16 color     */
                        0x72, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x78, 0,        /* 640x400 256 color    */
                        0x79, 0,        /* 640x480 256 color    */
                        0x7B, 0,        /* 800x600 256 color    */
                        0x7E, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grCHIPS_82c451,         /* Chips & Technologies 82c451 chip         */
    grCHIPS_82c452,         /* Chips & Technologies 82c452 chip         */
    grCHIPS_82c453,         /* Chips & Technologies 82c453 chip         */
    } CHIPS_chipsets;

/* Names of chip revision id's. */

char *ChipsNames[] = {
    "82c451",
    "82c452",
    "82c453",
    };

bool findChips(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findChips
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Chips & Tech based SuperVGA's.
*
****************************************************************************/
{
    union REGS  regs;

    regs.x.ax = 0x5F00;
    regs.x.bx = 0x0000;
    int86(0x10,&regs,&regs);
    if (regs.h.al != 0x5F)
        goto NoChips;

    /* We have a Chips & Tech SuperVGA */

    *superVGA = grSVGA_CHIPS;
    *pageFlip = true;

    switch (regs.h.bl >> 4) {
        case 1:
            *chipID = grCHIPS_82c452;
            unsupportedMode(vbe_800x600x256,CHIPSModes);
            unsupportedMode(vbe_1024x768x256,CHIPSModes);
            break;
        case 3:
            *chipID = grCHIPS_82c453;
            break;
        default:
            *chipID = grCHIPS_82c451;
            unsupportedMode(vbe_1024x768x16,CHIPSModes);
            unsupportedMode(vbe_640x480x256,CHIPSModes);
            unsupportedMode(vbe_800x600x256,CHIPSModes);
            unsupportedMode(vbe_1024x768x256,CHIPSModes);
        }

    /* Determine the amount of memory on board */

    if (regs.h.bh == 0)
        *memory = 256;
    else if (regs.h.bh == 1)
        *memory = 512;
    else *memory = 1024;
    return true;

NoChips:
    return false;
}
