/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _ati.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C Language support routines ATI SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _ati.c 1.1 1993/09/19 01:26:00 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _ati.c $
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short ATIModes[] = {    0x54, 0,        /* 800x600 16 color     */
                        0x55, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x61, 0,        /* 640x400 256 color    */
                        0x62, 0,        /* 640x480 256 color    */
                        0x63, 0,        /* 800x600 256 color    */
                        0x64, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x72, 0,        /* 640x480 32k color    */
                        0x73, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x75, 0,        /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grATI_18800,            /* ATI 18800 chip                           */
    grATI_18800_1,          /* ATI 18800-1 chip                         */
    grATI_28800_2,          /* ATI 28800-2 chip                         */
    grATI_28800_4,          /* ATI 28800-4 chip                         */
    grATI_28800_5,          /* ATI 28800-5 chip                         */
    } ATI_chipsets;

/* Names of chip revision id's. */

char *ATINames[] = {
    "18800",
    "18800-1",
    "28800-2",
    "28800-4",
    "28800-5",
    };

bool findATI(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findATI
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of ATI based SuperVGA's.
*
****************************************************************************/
{
    int     chip;

    if (peek(0xC000,0x40) != 0x3133)
        goto NoATI;
    if (strncmp((char*)MK_FP(0xC000,0x31),"761295520",9) != 0)
        goto NoATI;

    /* We have an ATI based SuperVGA, so determine the chip ID and the
     * memory configuration.
     */

    *superVGA = grSVGA_ATI;
    *pageFlip = true;

    switch (chip = peekb(0xC000,0x43)) {    /* Get chip version ID      */
        case 0x31:
            *chipID = grATI_18800;
            unsupportedMode(vbe_1024x768x16,ATIModes);
            break;
        case 0x32:
            *chipID = grATI_18800_1;
            break;
        case 0x33:
            *chipID = grATI_28800_2;
            break;
        case 0x34:
            *chipID = grATI_28800_4;
            break;
        default:
            *chipID = grATI_28800_5;
            if (peekb(0xC000,0x44) & 0x80)
                *dac = grHCDAC;
            break;
        }

    *memory = 256;
    switch (chip) {                         /* Get memory size bits     */
        case 0x31:
        case 0x32:
            if (rdinx(0x1CE,0xBB) & 0x20)
                *memory = 512;
            break;
        case 0x33:
            if (rdinx(0x1CE,0xB0) & 0x10)
                *memory = 512;
            break;
        default:
            switch (rdinx(0x1CE,0xB0) & 0x18) {
                case 0x00:  *memory = 256;  break;
                case 0x10:  *memory = 512;  break;
                default:    *memory = 1024; break;
                }
            break;
        }

    setBytesPerLine(vbe_640x480x16m,2048);
    return true;

NoATI:
    return false;
}
