;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _acumos.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for AcuMos SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _acumos.asm 1.2 1993/09/24 05:22:51 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _acumos.asm $
;* Revision 1.2  1993/09/24  05:22:51  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:40  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; ACUMOS_bank   Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    ACUMOS_bank far

		push    ax
        push    dx
        mov     dx,3CEh
        shl     al,4                ; Convert to 4k bank number
        mov     ah,al
        mov     al,9
        out     dx,ax
        pop     dx
        pop     ax
		ret

ENDP    ACUMOS_bank

ACUMOS_bank_len     =   ($-ACUMOS_bank)

;----------------------------------------------------------------------------
; ACUMOS_page   Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    ACUMOS_page far

        SetLowStartAddress
        mov     dx,3D4h             ; DX := CRTC I/O port
        mov     al,1Bh              ; Index of start address register
        out     dx,al
        inc     dx
        in      al,dx               ; Read old value
        and     al,0FAh             ; Clear out bits 0 and 2
        mov     bh,bl
        and     bh,2                ; BH := bit 17 of start address
        shl     bh,1                ; BH := bit 17 in bit pos 2
        and     bl,1                ; BL := bit 16 of start address
        or      bl,bh               ; BL := combined bit 16 and bit 17
        or      al,bl               ; Or in starting address value
        out     dx,al               ; Set the new value
        ret

ENDP    ACUMOS_page

ACUMOS_page_len     =   ($-ACUMOS_page)

;----------------------------------------------------------------------------
; ACUMOS_setup  Setup the SuperVGA for correct operation
;----------------------------------------------------------------------------
PROC    ACUMOS_setup    near

		wrinx   3C4h, 6, 12h        ; Enable extended registers
		modinx  3D4h, 1Bh, 10b, 10b ; Enable access to upper memory
		ret

ENDP    ACUMOS_setup

ACUMOS_setup_len    =   ($-ACUMOS_setup)

;----------------------------------------------------------------------------
; ACUMOS_exit   Return the SuperVGA to default operation
;----------------------------------------------------------------------------
PROC    ACUMOS_exit near

        wrinx   3C4h, 6, 0          ; Disable extended registers
        ret

ENDP    ACUMOS_exit

ACUMOS_exit_len =   ($-ACUMOS_exit)

;----------------------------------------------------------------------------
; ACUMOS_init
;----------------------------------------------------------------------------
; We have a ACUMOS SuperVGA, so setup the appropriate vectors.
;----------------------------------------------------------------------------
PROC    ACUMOS_init

        mov     [TwoBanks],false
        mov     [WriteBank16],offset ACUMOS_bank
        mov     [WriteBank16Len],ACUMOS_bank_len
        mov     [WriteBank256],offset ACUMOS_bank
        mov     [WriteBank256Len],ACUMOS_bank_len
		mov     [NewPage16],offset ACUMOS_page
		mov     [NewPage16Len],ACUMOS_page_len
		mov     [NewPage256],offset ACUMOS_page
		mov     [NewPage256Len],ACUMOS_page_len
		mov     [SetupSVGA],offset ACUMOS_setup
        mov     [SetupSVGALen],ACUMOS_setup_len
        mov     [ExitSVGA],offset ACUMOS_exit
        mov     [ExitSVGALen],ACUMOS_exit_len
        ret

ENDP    ACUMOS_init
