/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: chipsets.h $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  Header file providing constant and definitions for the
*               video chipsets supported by the VBE.
*
* $Id: chipsets.h 1.1 1993/09/19 01:26:00 kjb release $
*
* Revision History:
* -----------------
*
* $Log: chipsets.h $
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

#ifndef __CHIPSETS_H
#define __CHIPSETS_H

/*---------------------- Macros and type definitions ----------------------*/

/* Define the supported SuperVGA's */

typedef enum {
    grSVGA_ATI,             /* ATI Technologies SuperVGA                */
    grSVGA_AHEAD,           /* AHEAD SuperVGA                           */
    grSVGA_CHIPS,           /* Chips & Technologies SuperVGA            */
    grSVGA_EVEREX,          /* Everex SuperVGA                          */
    grSVGA_GENOA,           /* Genoa Systems SuperVGA (GVGA chipset)    */
    grSVGA_OAKTECH,         /* OAK Technologies SuperVGA                */
    grSVGA_PARADISE,        /* Paradise SuperVGA                        */
    grSVGA_TRIDENT,         /* Trident SuperVGA                         */
    grSVGA_VIDEO7,          /* Video7 SuperVGA                          */
    grSVGA_TSENG,           /* Tseng Labs SuperVGA                      */
    grSVGA_NCR,             /* NCR SuperVGA                             */
    grSVGA_S3,              /* S3 SuperVGA                              */
    grSVGA_ACUMOS,          /* Acumos SuperVGA                          */
    grSVGA_AVANCE,          /* Advance Logic SuperVGA                   */
    grSVGA_MXIC,            /* MXIC SuperVGA                            */
    grSVGA_PRIMUS,          /* Primus SuperVGA                          */
    grSVGA_REALTEK,         /* RealTek SuperVGA                         */
    grSVGA_CIRRUS,          /* Cirrus Logic SuperVGA                    */
    grSVGA_NONE     = -1    /* Not a supported SuperVGA chipset         */
    } supervga;

#define FIRST_SVGA  grSVGA_ATI
#define LAST_SVGA   grSVGA_CIRRUS

/* Video DAC types */

typedef enum {
    grVGADAC,               /* Normal DAC                               */
    grHCDAC,                /* HiColor 15 bit DAC                       */
    grHC2DAC,               /* HiColor 15/16 bit DAC                    */
    grTCDAC,                /* TrueColor 24 bit DAC                     */
    } video_dac;

#define CRTC    0x3D4
#define SEQ     0x3C4
#define GRC     0x3CE

/* Define the VBE mode numbers used internally */

typedef enum {
    vbe_800x600x16      = 0x102,
    vbe_1024x768x16     = 0x104,
    vbe_1280x1024x16    = 0x106,
    vbe_640x350x256     = 0x11C,
    vbe_640x400x256     = 0x100,
    vbe_640x480x256     = 0x101,
    vbe_800x600x256     = 0x103,
    vbe_1024x768x256    = 0x105,
    vbe_1280x1024x256   = 0x107,
    vbe_320x200x32k     = 0x10D,
    vbe_640x350x32k     = 0x11D,
    vbe_640x400x32k     = 0x11E,
    vbe_640x480x32k     = 0x110,
    vbe_800x600x32k     = 0x113,
    vbe_1024x768x32k    = 0x116,
    vbe_1280x1024x32k   = 0x119,
    vbe_320x200x64k     = 0x10E,
    vbe_640x350x64k     = 0x11F,
    vbe_640x400x64k     = 0x120,
    vbe_640x480x64k     = 0x111,
    vbe_800x600x64k     = 0x114,
    vbe_1024x768x64k    = 0x117,
    vbe_1280x1024x64k   = 0x11A,
    vbe_320x200x16m     = 0x10F,
    vbe_640x350x16m     = 0x121,
    vbe_640x400x16m     = 0x122,
    vbe_640x480x16m     = 0x112,
    vbe_800x600x16m     = 0x115,
    vbe_1024x768x16m    = 0x118,
    vbe_1280x1024x16m   = 0x11B,
    } VBEModes;

#endif  /* __CHIPSETS_H */
