%{

 (* NFF parser for TKTrace 
    
    Created        : 15/04/93 modified from nff.y from the MTV raytracer
    Last Change    : 15/04/93
    
    Adapted from nff.y from the MTV raytracer by M. VandeWettering 
 *)

 var 
   CurrentSurface : PSurf;
   dummy : integer;
   dummyvec: vec;
   a,b,c,d,e,f,g,h,i,j : Flt;

 procedure yyerror(msg : string);
 begin
   writeln(infilename,': ',yylineno,': ',msg,' at or before ''',yytext,'''.');
   halt; { SHOULD BE RECONSIDERED }
 end;


%}

%token VIEWPOINT FROM AT UP ANGLE ASPECT RESOLUTION LIGHT
%token BACKGROUND SURFACE SPHERE PLANE QUADRIC NUM TOKEN
%token BEGIN_BLOCK END_BLOCK
%token ILLEGAL

%type <vec>      point primcolor /* TOKEN */
%type <PPrim>    cone sphere polygon ppatch
%type <flt>      num
%token <flt>     NUM

%%

scene:

	cameralist elementlist 

elementlist:
	elementlist element
	|  ;

element:
	light
	| surface 
	| object ;

object:
        sphere
        | plane 
        | quadric ;

cameralist:
        VIEWPOINT BEGIN_BLOCK camera_item_list END_BLOCK ;

camera_item_list:
        camera_item
        | camera_item camera_item_list ;

camera_item:
        from
        | up
        | at
        | angle          
        | aspect
        | resolution
        | background ;

from:
	FROM point	
        {
           VecCopy($2,v_from);
        } ;

at:     
        AT point		
        {
           VecCopy($2,v_at);
        } ;

up:
        UP point
        { 
           VecCopy($2,v_up);
        } ;

angle:
        ANGLE num
        {
           v_angle := $2/360*pi;
        } ;

aspect: 
        ASPECT num
        {
           v_aspect := $2;
        }

resolution: 
        RESOLUTION num num              
        {
           If Image^.xres = 0 then
           begin
             Image^.xres := Round($2); Image^.yres := Round($3);
           end;
           Image^.FileOpen(OutFileName);
        } ;

background:
        BACKGROUND primcolor
        {
           VecCopy($2,backgroundcolor);
        } ;

light:
        LIGHT BEGIN_BLOCK point point END_BLOCK
        {
           LightTree.Add(New(PPointLight,Init($3,$4)));
        } ;

surface:
        SURFACE BEGIN_BLOCK primcolor primcolor primcolor num END_BLOCK
	{
		new(CurrentSurface);
                VecCopy($3, CurrentSurface^.kdiff);
                VecCopy($4, CurrentSurface^.kamb);
                VecCopy($5, CurrentSurface^.kspec);
                CurrentSurface^.shine := $6;
	} ;

sphere:
        SPHERE BEGIN_BLOCK point num END_BLOCK
	{
                Tree.Add(New(PSphere, Init($3, $4)),CurrentSurface);
	} ;

plane:
        PLANE BEGIN_BLOCK point num END_BLOCK
        {
                Tree.Add(New(PPlane, Init($3, $4)), CurrentSurface);
        } ;

quadric:
        QUADRIC BEGIN_BLOCK num num num num num num num num num num END_BLOCK
        {
                a := $3; b := $4;  c := $5;
                d := $6; e := $7;  f := $8;
                g := $9; h := $10; i := $11; j := $12;

                Tree.Add(New(PQuadric, Init(a,b,c,d,e,f,g,h,i,j)), CurrentSurface);
        } ;
               
primcolor:
        num num num
	{
		$$[0] := $1 ;
		$$[1] := $2 ;
		$$[2] := $3 ;
	}  
        ;
point:
        num num num
	{
		$$[0] := $1 ;
		$$[1] := $2 ;
		$$[2] := $3 ;
	} ;


num:
       NUM
       {
                $$ := $1;

       } ;

%%

{$I nfflex.pas}

function ReadSceneFile(Fname : PathStr) : boolean;

begin
  assign(yyinput, Fname);
  reset(yyinput);
  if IOResult<>0 then 
  begin
    yyerror('IO Error opening input file');
    halt(1);
  end;
  if yyparse = 1 then 
  begin
    yyerror('Error parsing inputfile');
    halt(1);
  end;
  writeln('Succesfully parsed input file ', FName);
  close(yyinput);
end;
