#define INCL_WINATOM
#define INCL_WINDIALOGS
#define INCL_WINHOOKS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include "rc.h"

BOOL EXPENTRY assocWindowHook(HAB habAnchor,
                              HDC hdcContext,
                              HWND hwndAssoc,
                              BOOL bAssoc)
//-------------------------------------------------------------------------
// This hook is invoked whenever an HDC is associated or disassociated with
// a window.
//
// Input:  habAnchor - anchor block of the thread in whose context the
//                     event occurred.
//         hdcContext - handle of the device context.
//         hwndAssoc - handle of the window associated/disassociated.
//         bAssoc - TRUE if hwndAssoc is associated with hdcContext.  FALSE
//                  otherwise.
// Returns:  TRUE if successful processing, FALSE otherwise.
//-------------------------------------------------------------------------
{
   CHAR achClass[256];

   WinQueryClassName(hwndAssoc,sizeof(achClass),achClass);

   if ((WinFindAtom(WinQuerySystemAtomTable(),
                    achClass)==LOUSHORT(WC_FRAME)) && bAssoc) {
      WinAlarm(HWND_DESKTOP,WA_NOTE);
   } /* endif */

   return TRUE;
}

BOOL EXPENTRY destroyWindowHook(HAB habAnchor,
                                HWND hwndDestroy,
                                ULONG ulReserved)
//-------------------------------------------------------------------------
// This hook is invoked whenever a window is destroyed.
//
// Input:  habAnchor - anchor block of the thread in whose context the
//                     event occurred.
//         hwndDestroy - handle of the window being destroyed.
//         ulReserved - reserved.
// Returns:  TRUE if successful processing, FALSE otherwise.
//-------------------------------------------------------------------------
{
   CHAR achClass[256];

   WinQueryClassName(hwndDestroy,sizeof(achClass),achClass);

   if (WinFindAtom(WinQuerySystemAtomTable(),achClass)==LOUSHORT(WC_FRAME)) {
      WinAlarm(HWND_DESKTOP,WA_ERROR);
   } /* endif */

   return TRUE;
}

INT main(VOID)
{
   HAB habAnchor;
   HMQ hmqQueue;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinSetHook(habAnchor,
              HMQ_CURRENT,
              HK_WINDOWDC,
              (PFN)assocWindowHook,
              NULLHANDLE);
   WinSetHook(habAnchor,
              HMQ_CURRENT,
              HK_DESTROYWINDOW,
              (PFN)destroyWindowHook,
              NULLHANDLE);

   WinDlgBox(HWND_DESKTOP,
             HWND_DESKTOP,
             WinDefDlgProc,
             NULLHANDLE,
             DLG_MAIN,
             NULL);

   WinReleaseHook(habAnchor,
                  HMQ_CURRENT,
                  HK_WINDOWDC,
                  (PFN)assocWindowHook,
                  NULLHANDLE);
   WinReleaseHook(habAnchor,
                  HMQ_CURRENT,
                  HK_DESTROYWINDOW,
                  (PFN)destroyWindowHook,
                  NULLHANDLE);

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
