/* Convert E-Teller ET_FIX and ET_FIXED file format from 1.x to 1.4 

    To run, simply double-click on 'fix_fix.cmd' or use the command
    line
*/

'@echo off'
'cls'
say 'E-Teller 1.4 ET_Fix/ET_Fixed file conversion utility.'
say ''
fix = 'ET_FIX.INI'
fixed = 'ET_FIXED.INI'
rcfix = stream( fix, 'c', 'query exists' )
rcfixed = stream( fixed, 'c', 'query exists' )
if rcfix <> '' then do
   filename = fix
   call FixFile
end
if rcfixed <> '' then do
   filename = fixed
   call FixFile
end
exit

FixFile:
if RxFuncQuery( 'SysIni' )then do
    call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
end
call SysIni filename, 'ALL:', 'days'
if days.0 <> 0 then do
    do i = 1 to days.0
      call SysIni filename, days.i, 'ALL:', 'names'
      do j = 1 to names.0
         value = SysIni( filename, days.i, names.j )
         pos = Pos( '.', names.j )
         ldgFile = Overlay( '.ldg', names.j, pos, 4 )
         say ''
         say 'Entry found for day of month 'days.i
         say 'Searching for account file:  'ldgFile
         ok = stream( ldgFile, 'c', 'query exists' )
         if ok = '' then do
            say ''
            say 'Unable to locate 'ldgFile
            say 'Please enter the appropriate path and filename:'
            parse pull ldgFile
            if ldgFile <> '' then do
               newrc = stream( ldgFile, 'c', 'query exists' )
               say 'Searching for 'ldgFile
               if newrc = '' then
               signal StopProcess
            end
         end
         say 'File found.  Performing conversion...'
         call SysIni filename, days.i, ldgFile, value
         call SysIni filename, days.i, names.j, 'DELETE:'
      end
   end
end
return

StopProcess:
say ''
say 'Filename 'ldgFile' does not exist.  Process stopped.'
call stream filename, 'c', 'close'
exit

