/* Use this script to convert ET_FIX.INI and ET_FIXED.INI from version 1.x of
   E-Teller to version 1.5

   To convert these files, simply run etfix15.cmd
*/
'@echo off'
'cls'
say 'E-Teller 1.5 ET_Fix/ET_Fixed file conversion utility.'
say ''
fix = 'ET_FIX.INI'
newfix = 'et_fix.dat'
fixed = 'ET_FIXED.INI'
newfixed = 'et_fixed.dat'
rcfix = stream( fix, 'c', 'query exists' )
rcfixed = stream( fixed, 'c', 'query exists' )
if rcfix <> '' then do
   filename = fix
   call FixFile
end
if rcfixed <> '' then do
   filename = fixed
   call FixFile
end
exit

FixFile:
if RxFuncQuery( 'SysIni' )then do
    call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
end
if filename = 'ET_FIX.INI' then
   NFileName = 'et_fix.dat'
else
   NFileName = 'et_fixed.dat'

call SysIni filename, 'ALL:', 'days'
if days.0 <> 0 then do
    do i = 1 to days.0
      if( DataType( days.i ) = 'NUM' ) then do
         if( Length( days.i ) = 1 )then
            WDay = '[0'||days.i||']'
         else
            WDay = '['||days.i||']'
         say 'Writing entry for day: 'WDay
         call lineout NFilename, WDay                    /* write the day to *.dat */
      end
      call SysIni filename, days.i, 'ALL:', 'names'   /* names = *.ldg */
      do j = 1 to names.0
         value = SysIni( filename, days.i, names.j )
         parse var value '"' date '","' number '","' info '","' credit '","' debit '","' memo '","' cat '"' .
         if( DataType( days.i ) = 'CHAR' )then do
            cls
            say 'E-Teller 1.4 contained an error.'
            say 'As a result, the incorrect day-of-month was saved along with the following'
            say 'transaction:'
            say ''
            say '    Date:  'date
            say '    Num:   'number
            say '    Info:  'info
            say '    Trans: 'trans
            say '    Memo:  'memo
            say '    Categ: 'cat
            say ''
            parse var date yy '/' mm '/' dd
            say 'Should 'dd' be used for this entry (Y/n)?'
            parse upper pull answer
            if answer = 'N' then do
               say 'Please enter a day-of-month value: '
               do until Datatype( answer ) = 'NUM' & answer <= 31
                  parse pull answer
                  if( Datatype( answer ) <> 'NUM' | answer > 31 )then do
                     call beep 2048,256
                     say 'Please enter a valid number.'
                  end
               end
               dd = answer
            end
            if( Length( dd ) = 1 )then
               dd = '[0'||dd||']'
            else
               dd = '['||dd||']'
            call lineout NFileName, dd
         end
         call lineout NFileName, names.j              /* write the filename.ldg to *.dat */
         call lineout NFileName, number
         call lineout NFileName, info
         if credit = 0 then
            trans = '-'||debit
         else
            trans = credit
         call lineout NFileName, trans
         call lineout NFileName, memo
         if cat <> '-' then
            call lineout NFileName, cat
         else
            call lineout NFileName, ''
         call lineout NFileName, '----------'
      end
   end
end
return

StopProcess:
say ''
say 'Filename 'ldgFile' does not exist.  Process stopped.'
call stream filename, 'c', 'close'
exit

