/* Clipchar 1.0 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Clipchar Version 1.0...'
Say ''
Result = SysFileTree( 'CLIPCHAR.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CLIPCHAR.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'CLIPCHAR.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: CLIPCHAR.DOC not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory you want to'
Say 'have Clipchar installed to (default is C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create directory. Installation cancelled.'
    Signal DONE
    End
  End
Folder = '<WP_DESKTOP>'
Say 'The program object for Clipchar is created on the Desktop.'
Say ''

Say 'Copying CLIPCHAR.EXE to' Directory '...'
Copy CLIPCHAR.EXE Directory                  '1>NUL'
Say 'Copying CLIPCHAR.DOC to' Directory '...'
Copy CLIPCHAR.DOC Directory                  '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                 '1>NUL'
Say ''
Say 'Creating program object...'
Say ''
Type = 'WPProgram'
Title = 'Clipchar'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CLIPCHAR.EXE;STARTUPDIR='Directory';OBJECTID=<CLIPCHAR>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Say 'Clipchar was successfully installed.'
  Say 'Please read CLIPCHAR.DOC before using Kuvert/2.'
  Exit
Else
  Say 'ERROR: Unable to create program object. Installation cancelled.'
  Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
