/*	install.cmd - REXX script for ScreenSaver installation
	(C) 1993-94 Siegfried Hanisch
*/

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

say "ScreenSaver 1.2 installation."

rc = SysFileTree("SSaver.EXE", fspec, "FO")
if rc=0 then
do
	filename=filespec("Name", fspec.1)
	filepath=filespec("Path", fspec.1)
	filedrive=filespec("Drive", fspec.1)
	if SysCreateObject("WPProgram", "ScreenSaver",,
	  "<WP_DESKTOP>", "EXENAME="filedrive||filepath||filename,
	  ";STARTUPDIR="||filedrive||filepath, "replace") then
	do
		say "ScreenSaver program object created."
		say "If you want ScreenSaver to be automatically started at boot"
		say "time, move the program object to the startup folder."
		say "-----"
		say "Make sure the latest version of the emx-DLLs (as supplied with ScreenSaver)"
		say "are somewhere in your LIBPATH"
		say "-----"
		say "Please read the online help topic on 'low priority' if"
		say "saver animation is not smooth enough."
		say "-----"
		say "Please note that the 'Colors' module will most probably"
		say "work only on (S)VGA video cards in 16 and 256 color mode."
		say "-----"
		say "It is now possible to use Deskpic modules (see online help)."
	end
	else
		say "ERROR: program object could not be created."
end
else
	say "ERROR: ScreenSaver program file SSaver.EXE not found."
	exit
end
