;
; Cookie.asm = the infamous cookie program
;
; Adapted for the IBM PC
;
; by Mitchell Lichtenberg
;
; November 21, 1984
;
; October 14, 1987	MPL	New version to run under MS OS/2
;

		title	cookie

		page	60,132

		.286p			; we're doing protected mode

; Equates

last_cookie 	equ	968		; total number of cookies in file

datetime	struc
hours		db	?
minutes		db	?
seconds		db	?
hundredths	db	?
day		db	?
month		db	?
year		dw	?
timezone	dw	?
dayofweek	db	?
datetime	ends

		assume	cs:code,ds:data,es:data,ss:stack

data		segment word public 'DATA'
dgroup		group	data
data		ends

		extrn	DOSGETDATETIME:FAR
		extrn	DOSWRITE:FAR
		extrn	DOSEXIT:FAR

code		segment byte public 'CODE'


bake		proc	far

		mov	ax,data
		mov	ds,ax
		mov	es,ax

		push	ds
		push	offset date_time
		call	DOSGETDATETIME

		mov	al,date_time.hours
		xor	ah,ah		; get hours
		mov	cx,60*60	
		mul	cx		; DXAX has seconds since 1200 to this hr
		mov	si,dx
		mov	di,ax		; SIDI now has seconds...
		mov	al,date_time.minutes
		xor	ah,ah
		mov	cx,60		; get # of seconds this hour
		mul	cx		; into DXAX
		add	di,ax		; add into SIDI
		adc	si,dx		; with carry
		mov	al,date_time.seconds
		xor	ah,ah		; add in seconds
		add	di,ax
		adc	si,0		; with carry
		mov	al,date_time.hundredths	; just for randomness
		add	di,ax
		adc	si,0
		mov	ax,di
		mov	dx,si		; DXAX now contains random #

		mov	dx,0		; hi part is 0
		div	bx		; get dx=mod, ax=quotient

		mov	cx,-1		; search forever
		cld

		mov	di,offset cookies
		cmp	dx,0		; first cookie
		je	writeout	; if so, move on

notyet:		mov	al,0		; search for null
		repne	scasb		; find the null
		dec	dx
		jnz	notyet

; compute length of string to output

writeout:	push	di
		mov	al,0		; scan for next null
		mov	cx,-1
		repne	scasb		; find next null
		neg	cx		; find out how many we did
		sub	cx,2		; back off null & xtra
		pop	di

		push	1		; standard output
		push	ds
		push	di		; push pointer to string
		push	cx		; push # of chars to write
		push	ds
		push	offset temp	; don't really care
		call	DOSWRITE

done:		push	1		; kill all threads
		push	0		; good exit
		call	DOSEXIT

bake		endp

code		ends


data		segment 		; byte public 'DATA'

date_time	datetime	<>
temp		dw		?

cookies		label	byte
		INCLUDE	COOKIES.ASM	; cookie file
		INCLUDE MORECOOK.ASM	; more cookies! (stolen from dec-20)

data		ends

stack		segment stack word 'STACK'

		dw	1024 dup (?)

stack		ends

		end	bake

