#ifndef _OSDEP_LINUX_H
#define _OSDEP_LINUX_H

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/param.h>

#include <linux/malloc.h>
#include <linux/string.h>
#include <linux/in.h>
#include <linux/socket.h>

#define KERNEL 1
#define printf printk

/* We *really* need to use semaphores or locks instead */
#define CRITICAL_DCL
#define CRITICAL_START cli()
#define CRITICAL_END sti()
#define TIME_SECONDS (xtime.tv_sec)
#define CURRENT_PID (current->pid)

#else /* __KERNEL__ */
#include <sys/types.h>
#endif /* __KERNEL__ */

struct sockaddr_bsd44 {   
  __u8 sa_len;
  __u8 sa_family;
  __u8 sa_data[14];
};
#define SOCKADDR struct sockaddr_bsd44
#define SOCKADDR_MAXSZ sizeof(struct sockaddr_bsd44)
#define SOCKET struct sock

#define u_int8_t	__u8
#define u_int16_t	__u16
#define u_int32_t	__u32

#define REAL_KMALLOC(p, t, n) (p = (t)kmalloc(n, GFP_KERNEL))
#define REAL_KFREE(p) kfree(p)
#define REAL_KFREE_LEN(p, n) kfree(p)

#ifdef KEY_DEBUG
#define KMALLOC(p, t, n) (p = (t)key_debug_malloc(n, #t))
#define KFREE(p) key_debug_free(p)
#define KFREE_LEN(p, n) key_debug_free_len(p, n)
#else /* KEY_DEBUG */
#define KMALLOC(p, t, n) REAL_KMALLOC(p, t, n)
#define KFREE(p) REAL_KFREE(p)
#define KFREE_LEN(p, n) REAL_KFREE_LEN(p, n)
#endif /* KEY_DEBUG */

#define bcopy(s, d, n) memcpy(d, s, n)
#define bzero(d, n) memset(d, 0, n)

#ifndef __P
#define __P(x) x
#endif /* __P */

#define DEFARGS(arglist, args) (args)
#define AND ,

#ifdef __KERNEL__
long random __P((void));
#endif /* __KERNEL__ */

#endif /* _OSDEP_LINUX_H */
