/*----------------------------------------------------------------------
  Copyright 1995 by Bao Phan, Dan McDonald, & Randall Atkinson.
  All Rights Reserved.  All Rights have been assigned to the US
  Naval Research Laboratory (NRL).  The NRL COPYRIGHT NOTICE and
  LICENSE governs distribution and use of this software.
----------------------------------------------------------------------*/
/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/malloc.h>

#include <netkey/key.h>
#include <netsec/ipsec.h>
#include <netsec/md5.h>

struct md5state {
  struct MD5_CTX isb;               /* Internal state block for MD5 */
  struct key_secassoc *assoc;       /* Security association (keys!) */
};

caddr_t ah_md5init __P((struct key_secassoc *));
caddr_t ah_md5update __P((caddr_t, caddr_t, int));
caddr_t ah_md5finish __P((caddr_t, caddr_t));

/*----------------------------------------------------------------------
  md5init():   Initialise MD5 state and stash pertinent
               Security Association away in md5state.
----------------------------------------------------------------------*/
caddr_t ah_md5init(assoc)
     struct key_secassoc *assoc;
{
  struct md5state *md5state = malloc(sizeof(struct md5state), M_TEMP, M_NOWAIT);
  
  if (md5state) {
    MD5Init(&(md5state->isb));
    MD5Update(&(md5state->isb), (unsigned char *)assoc->key, assoc->keylen);
    MD5Final(NULL, &(md5state->isb));
    md5state->assoc = assoc;
  }

  return (caddr_t)md5state;
};

/*----------------------------------------------------------------------
  md5update():  Continue the MD5 calculation over some data in the packet.
----------------------------------------------------------------------*/
caddr_t ah_md5update(state, data, len)
     caddr_t state;
     caddr_t data;
     int len;
{
  MD5Update(&(((struct md5state *)state)->isb), (unsigned char *)data, len);
  return state;
};

/*----------------------------------------------------------------------
  md5finish():  Conclude the MD5 calculation for AH and return AH data (?).
----------------------------------------------------------------------*/
caddr_t ah_md5finish(state, data)
caddr_t state;
caddr_t data;
{
  struct md5state *md5state = (struct md5state *)state;

  MD5Update(&(md5state->isb), (unsigned char *)md5state->assoc->key,
	    md5state->assoc->keylen);
  MD5Final((unsigned char *)data, &(md5state->isb));

  free(state, M_TEMP);
  return data;
};
