/*
 Copyright (c) 2002 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

------------------------------------------------------------------------------
 Module Header
 Filename          : input.c
 Purpose           : Reads input either from cgi env or std env
 Author            : Can Bican <can@ripe.net>
 Language Version  : C
 $Id: input.c,v 1.2 2002/06/07 09:26:26 can Exp $
------------------------------------------------------------------------------
*/

#include "input.h"

int input_init(void) {
  if (!TEST) {
    ISCGI=TRUE;
    return(cgi_init());
  }
  ISCGI=FALSE;
  return(0);
}

gchar *input_getentrystr(const gchar *var) {
  gchar *envVar;
  gchar *result=NULL;

  envVar=getenv(var);
  if (!TEST) {
    result=(gchar *)cgi_getentrystr(var);
  } else {
    if (envVar!=NULL) {
      result=envVar;
    } else {
      result=NULL;
    }
  }
  return(result);
}

gchar *input_strerror(int res) {
  if (!TEST) {
    return((char*)cgi_strerror(res));
  } else {
    return(strerror(res));
  }
}

void input_quit(void) {
  if (!TEST) {
    cgi_quit();
    ISCGI=FALSE;
  }
}
