/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLDTDScanner;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.common.GrammarResolver;

public final class XMLDocumentScanner {
    static final char[] cdata_string = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    static final char[] xml_string = new char[]{'x', 'm', 'l'};
    private static final char[] version_string = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
    static final char[] doctype_string = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] standalone_string = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
    private static final char[] encoding_string = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE = -1;
    public static final int RESULT_DUPLICATE_ATTR = -2;
    static final int SCANNER_STATE_XML_DECL = 0;
    static final int SCANNER_STATE_START_OF_MARKUP = 1;
    static final int SCANNER_STATE_COMMENT = 2;
    static final int SCANNER_STATE_PI = 3;
    static final int SCANNER_STATE_DOCTYPE = 4;
    static final int SCANNER_STATE_PROLOG = 5;
    static final int SCANNER_STATE_ROOT_ELEMENT = 6;
    static final int SCANNER_STATE_CONTENT = 7;
    static final int SCANNER_STATE_REFERENCE = 8;
    static final int SCANNER_STATE_ATTRIBUTE_LIST = 9;
    static final int SCANNER_STATE_ATTRIBUTE_NAME = 10;
    static final int SCANNER_STATE_ATTRIBUTE_VALUE = 11;
    static final int SCANNER_STATE_TRAILING_MISC = 12;
    static final int SCANNER_STATE_END_OF_INPUT = 13;
    static final int SCANNER_STATE_TERMINATED = 14;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    int fAttrListHandle = -1;
    XMLAttrList fAttrList = null;
    GrammarResolver fGrammarResolver = null;
    XMLDTDScanner fDTDScanner = null;
    boolean fNamespacesEnabled = false;
    boolean fValidationEnabled = false;
    boolean fLoadExternalDTD = true;
    QName fElementQName = new QName();
    QName fAttributeQName = new QName();
    QName fCurrentElementQName = new QName();
    ScannerDispatcher fDispatcher = null;
    EventHandler fEventHandler = null;
    XMLDocumentHandler.DTDHandler fDTDHandler = null;
    StringPool fStringPool = null;
    XMLErrorReporter fErrorReporter = null;
    XMLEntityHandler fEntityHandler = null;
    XMLEntityHandler.EntityReader fEntityReader = null;
    XMLEntityHandler.CharBuffer fLiteralData = null;
    boolean fSeenRootElement = false;
    boolean fSeenDoctypeDecl = false;
    boolean fStandalone = false;
    boolean fParseTextDecl = false;
    boolean fScanningDTD = false;
    int fScannerState = 0;
    int fReaderId = -1;
    int fAttValueReader = -1;
    int fAttValueElementType = -1;
    int fAttValueAttrName = -1;
    int fAttValueOffset = -1;
    int fAttValueMark = -1;
    int fScannerMarkupDepth = 0;
    int fCurrentElementType = -1;

    public XMLDocumentScanner(StringPool stringPool, XMLErrorReporter xMLErrorReporter, XMLEntityHandler xMLEntityHandler, XMLEntityHandler.CharBuffer charBuffer) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = xMLEntityHandler;
        this.fLiteralData = charBuffer;
        this.fDispatcher = new XMLDeclDispatcher();
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    void abortMarkup(int n, int n2) throws Exception {
        this.reportFatalXMLError(n, n2);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, int n3) throws Exception {
        this.reportFatalXMLError(n, n2, n3);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, int n3, int n4) throws Exception {
        this.reportFatalXMLError(n, n2, n3, n4);
        this.skipPastEndOfCurrentMarkup();
    }

    void abortMarkup(int n, int n2, String string) throws Exception {
        this.reportFatalXMLError(n, n2, string);
        this.skipPastEndOfCurrentMarkup();
    }

    public boolean atEndOfInput() {
        return this.fScannerState == 13;
    }

    public void checkXMLLangAttributeValue(int n) throws Exception {
        char c;
        String string = this.fStringPool.toString(n);
        int n2 = -1;
        if (string.length() >= 2) {
            c = string.charAt(0);
            if (string.charAt(1) == '-') {
                if (c == 'i' || c == 'I' || c == 'x' || c == 'X') {
                    n2 = 1;
                }
            } else {
                char c2 = string.charAt(1);
                if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    n2 = 2;
                }
            }
        }
        if (n2 > 0 && string.length() > n2) {
            if ((c = string.charAt(n2++)) != '-') {
                n2 = -1;
            } else {
                while (true) {
                    if (c == '-') {
                        if (string.length() == n2) {
                            n2 = -1;
                            break;
                        }
                        if (!((c = string.charAt(n2++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                            n2 = -1;
                            break;
                        }
                        if (string.length() == n2) {
                            break;
                        }
                    } else {
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                            n2 = -1;
                            break;
                        }
                        if (string.length() == n2) break;
                    }
                    c = string.charAt(n2++);
                }
            }
        }
        if (n2 == -1) {
            this.reportFatalXMLError(65, 65, string);
        }
    }

    public void endOfInput(int n, boolean bl) throws Exception {
        if (this.fDTDScanner != null && this.fScanningDTD) {
            this.fDTDScanner.endOfInput(n, bl);
        }
        this.fDispatcher.endOfInput(n, bl);
    }

    public int getCurrentElementType() {
        return this.fCurrentElementType;
    }

    public boolean getLoadExternalDTD() {
        return this.fLoadExternalDTD;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public boolean parseSome(boolean bl) throws Exception {
        do {
            if (this.fDispatcher.dispatch(bl)) continue;
            return false;
        } while (bl);
        return true;
    }

    public void readerChange(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fEntityReader = entityReader;
        this.fReaderId = n;
        if (this.fScannerState == 11) {
            this.fAttValueMark = this.fAttValueOffset = this.fEntityReader.currentOffset();
        }
        if (this.fDTDScanner != null && this.fScanningDTD) {
            this.fDTDScanner.readerChange(entityReader, n);
        }
    }

    void reportFatalXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 2);
    }

    void reportFatalXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    void reportFatalXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 2);
    }

    public void reset(StringPool stringPool, XMLEntityHandler.CharBuffer charBuffer) {
        this.fStringPool = stringPool;
        this.fLiteralData = charBuffer;
        this.fParseTextDecl = false;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fStandalone = false;
        this.fScanningDTD = false;
        this.fDispatcher = new XMLDeclDispatcher();
        this.fScannerState = 0;
        this.fScannerMarkupDepth = 0;
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    void restoreScannerState(int n) {
        if (this.fScannerState != 13) {
            this.fScannerState = n;
        }
    }

    private int scanAttValue(QName qName, QName qName2) throws Exception {
        int n = this.scanAttValue(qName, qName2, this.fValidationEnabled);
        if (n == -1) {
            return -1;
        }
        return 0;
    }

    public int scanAttValue(QName qName, QName qName2, boolean bl) throws Exception {
        int n;
        int n2;
        boolean bl2 = this.fEntityReader.lookingAtChar('\'', true);
        if (!bl2 && !this.fEntityReader.lookingAtChar('\"', true)) {
            this.reportFatalXMLError(13, 12, qName.rawname, qName2.rawname);
            return -1;
        }
        char c = bl2 ? (char)'\'' : '\"';
        this.fAttValueMark = this.fEntityReader.currentOffset();
        int n3 = this.fEntityReader.scanAttValue(c, bl);
        if (n3 >= 0) {
            return n3;
        }
        int n4 = this.setScannerState(11);
        this.fAttValueReader = this.fReaderId;
        this.fAttValueElementType = qName.rawname;
        this.fAttValueAttrName = qName2.rawname;
        this.fAttValueOffset = this.fEntityReader.currentOffset();
        int n5 = this.fLiteralData.length();
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        this.fAttValueMark = this.fAttValueOffset;
        boolean bl3 = false;
        while (true) {
            if (this.fEntityReader.lookingAtChar(c, true)) {
                if (this.fReaderId == this.fAttValueReader) {
                    break;
                }
            } else if (!this.fEntityReader.lookingAtChar(' ', true)) {
                boolean bl4 = this.fEntityReader.lookingAtChar('\r', true);
                if (bl4 || this.fEntityReader.lookingAtSpace(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    this.fLiteralData.append(' ');
                } else if (this.fEntityReader.lookingAtChar('&', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    if (this.fEntityReader.lookingAtChar('#', true)) {
                        n2 = this.scanCharRef();
                        if (n2 != -1) {
                            if (n2 < 65536) {
                                this.fLiteralData.append((char)n2);
                            } else {
                                this.fLiteralData.append((char)((n2 - 65536 >> 10) + 55296));
                                this.fLiteralData.append((char)((n2 - 65536 & 0x3FF) + 56320));
                            }
                        }
                    } else {
                        n2 = this.fEntityReader.currentOffset();
                        this.fEntityReader.skipPastName(';');
                        n = this.fEntityReader.currentOffset() - n2;
                        if (n == 0) {
                            this.reportFatalXMLError(14, 13);
                        } else if (!this.fEntityReader.lookingAtChar(';', true)) {
                            this.reportFatalXMLError(15, 14, this.fEntityReader.addString(n2, n));
                        } else {
                            int n6 = this.fEntityReader.addSymbol(n2, n);
                            this.fEntityHandler.startReadingFromEntity(n6, this.fScannerMarkupDepth, 0);
                        }
                    }
                } else if (this.fEntityReader.lookingAtChar('<', true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    this.reportFatalXMLError(2, 11, qName.rawname, qName2.rawname);
                } else if (!this.fEntityReader.lookingAtValidChar(true)) {
                    if (this.fAttValueOffset - this.fAttValueMark > 0) {
                        this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
                    }
                    bl3 = true;
                    n2 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 13) {
                        return -1;
                    }
                    if (n2 >= 0) {
                        this.reportFatalXMLError(12, 10, this.fStringPool.toString(qName.rawname), this.fStringPool.toString(qName2.rawname), Integer.toHexString(n2));
                    }
                }
            }
            this.fAttValueOffset = this.fEntityReader.currentOffset();
            if (!bl3) continue;
            this.fAttValueMark = this.fAttValueOffset;
            bl3 = false;
        }
        this.restoreScannerState(n4);
        n2 = this.fLiteralData.length() - n5;
        if (n2 == 0) {
            return this.fEntityReader.addString(this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
        }
        if (this.fAttValueOffset - this.fAttValueMark > 0) {
            this.fEntityReader.append(this.fLiteralData, this.fAttValueMark, this.fAttValueOffset - this.fAttValueMark);
            n2 = this.fLiteralData.length() - n5;
        }
        n = this.fLiteralData.addString(n5, n2);
        return n;
    }

    private void scanAttributeName(XMLEntityHandler.EntityReader entityReader, QName qName, QName qName2) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName2.clear();
            qName2.rawname = qName2.localpart = entityReader.scanName('=');
        } else {
            entityReader.scanQName('=', qName2);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    int scanCharRef() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = this.fEntityReader.lookingAtChar('x', true);
        int n2 = this.fEntityReader.scanCharRef(bl);
        if (n2 < 0) {
            switch (n2) {
                case -1: {
                    this.reportFatalXMLError(18, 17);
                    return -1;
                }
                case -2: {
                    int n3 = bl ? 17 : 16;
                    int n4 = bl ? 16 : 15;
                    this.reportFatalXMLError(n3, n4);
                    return -1;
                }
                case -3: {
                    n2 = 0x110000;
                    break;
                }
            }
        }
        if (n2 < 32 ? n2 == 9 || n2 == 10 || n2 == 13 : n2 <= 55295 || n2 >= 57344 && (n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF)) {
            return n2;
        }
        int n5 = this.fEntityReader.currentOffset() - n;
        this.reportFatalXMLError(11, 9, this.fEntityReader.addString(n, n5));
        return -1;
    }

    void scanComment() throws Exception {
        int n = this.fEntityReader.currentOffset();
        boolean bl = false;
        int n2 = this.setScannerState(2);
        while (this.fScannerState == 2) {
            int n3;
            if (this.fEntityReader.lookingAtChar('-', false)) {
                n3 = this.fEntityReader.currentOffset();
                int n4 = 0;
                this.fEntityReader.lookingAtChar('-', true);
                int n5 = this.fEntityReader.currentOffset();
                int n6 = 1;
                while (this.fEntityReader.lookingAtChar('-', true)) {
                    ++n6;
                    n4 = n3;
                    n3 = n5;
                    n5 = this.fEntityReader.currentOffset();
                }
                if (n6 <= 1) continue;
                if (this.fEntityReader.lookingAtChar('>', true)) {
                    if (!bl && n6 > 2) {
                        this.reportFatalXMLError(9, 7);
                        bl = true;
                    }
                    --this.fScannerMarkupDepth;
                    this.fEventHandler.callComment(this.fEntityReader.addString(n, n4 - n));
                    this.restoreScannerState(n2);
                    return;
                }
                if (bl) continue;
                this.reportFatalXMLError(9, 7);
                bl = true;
                continue;
            }
            if (this.fEntityReader.lookingAtValidChar(true)) continue;
            n3 = this.fEntityReader.scanInvalidChar();
            if (this.fScannerState == 13 || n3 < 0) continue;
            this.reportFatalXMLError(10, 8, Integer.toHexString(n3));
        }
        this.restoreScannerState(n2);
    }

    private void scanDoctypeDecl(boolean bl) throws Exception {
        this.fScanningDTD = true;
        this.fSeenDoctypeDecl = true;
        if (this.fDTDScanner == null) {
            this.fDTDScanner = new XMLDTDScanner(this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
            this.fDTDScanner.setValidationEnabled(this.fValidationEnabled);
            this.fDTDScanner.setNamespacesEnabled(this.fNamespacesEnabled);
            this.fDTDScanner.setLoadExternalDTD(this.fLoadExternalDTD);
        } else {
            this.fDTDScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        }
        this.fDTDScanner.setDTDHandler(this.fDTDHandler);
        this.fDTDScanner.setGrammarResolver(this.fGrammarResolver);
        if (this.fDTDScanner.scanDoctypeDecl() && this.fDTDScanner.getReadingExternalEntity()) {
            this.fDTDScanner.scanDecls(true);
        }
        if (this.fValidationEnabled) {
            ((DefaultEntityHandler)this.fEntityHandler).checkRequiredNotations();
        }
        this.fScanningDTD = false;
    }

    boolean scanElement(QName qName) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        bl = this.fEntityReader.lookingAtChar('>', true);
        if (!bl) {
            if (this.fEntityReader.lookingAtSpace(true)) {
                int n;
                block14: {
                    n = this.setScannerState(9);
                    do {
                        this.fEntityReader.skipPastSpaces();
                        bl = this.fEntityReader.lookingAtChar('>', true);
                        if (bl || (bl2 = this.fEntityReader.lookingAtChar('/', true))) break block14;
                        this.setScannerState(10);
                        this.scanAttributeName(this.fEntityReader, qName, this.fAttributeQName);
                        if (this.fAttributeQName.rawname == -1) break block14;
                        this.fEntityReader.skipPastSpaces();
                        if (!this.fEntityReader.lookingAtChar('=', true)) {
                            if (this.fScannerState != 13) {
                                this.abortMarkup(27, 26, qName.rawname, this.fAttributeQName.rawname);
                                this.restoreScannerState(n);
                            }
                            return false;
                        }
                        this.fEntityReader.skipPastSpaces();
                        int n2 = this.scanAttValue(qName, this.fAttributeQName, false);
                        if (n2 == -1) {
                            if (this.fScannerState != 13) {
                                this.skipPastEndOfCurrentMarkup();
                                this.restoreScannerState(n);
                            }
                            return false;
                        }
                        if (n2 == -2) {
                            this.reportFatalXMLError(28, 27, qName.rawname, this.fAttributeQName.rawname);
                        }
                        if (this.fEventHandler.attribute(qName, this.fAttributeQName, n2)) {
                            this.reportFatalXMLError(28, 27, qName.rawname, this.fAttributeQName.rawname);
                        }
                        this.restoreScannerState(9);
                    } while (this.fEntityReader.lookingAtSpace(true));
                    bl = this.fEntityReader.lookingAtChar('>', true);
                    if (!bl) {
                        bl2 = this.fEntityReader.lookingAtChar('/', true);
                    }
                }
                this.restoreScannerState(n);
            } else {
                bl2 = this.fEntityReader.lookingAtChar('/', true);
            }
        }
        if (!(bl || bl2 && this.fEntityReader.lookingAtChar('>', true))) {
            if (this.fScannerState != 13) {
                this.abortMarkup(26, 25, qName.rawname);
            }
            return false;
        }
        this.fEventHandler.callStartElement(qName);
        --this.fScannerMarkupDepth;
        if (bl2) {
            this.fEventHandler.callEndElement(this.fReaderId);
            return false;
        }
        return true;
    }

    private void scanElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
        } else {
            entityReader.scanQName(c, qName);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
        this.fEventHandler.element(qName);
    }

    private boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char c, int n) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(n, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(c, this.fCurrentElementCharArrayRange);
    }

    /*
     * Unable to fully structure code
     */
    void scanPI(int var1_1) throws Exception {
        block8: {
            block7: {
                var2_2 = this.fStringPool.toString(var1_1);
                if (!(var2_2.length() != 3 || var2_2.charAt(0) != 'X' && var2_2.charAt(0) != 'x' || var2_2.charAt(1) != 'M' && var2_2.charAt(1) != 'm' || var2_2.charAt(2) != 'L' && var2_2.charAt(2) != 'l')) {
                    this.abortMarkup(6, 4);
                    return;
                }
                var3_3 = this.setScannerState(3);
                var4_4 = -1;
                var5_5 = -1;
                if (this.fEntityReader.lookingAtSpace(true)) break block7;
                if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
                    if (this.fScannerState != 13) {
                        this.abortMarkup(7, 5);
                        this.restoreScannerState(var3_3);
                    }
                    return;
                }
                var5_5 = 0;
                break block8;
            }
            this.fEntityReader.skipPastSpaces();
            var4_4 = this.fEntityReader.currentOffset();
            ** GOTO lbl38
            {
                block9: {
                    var6_6 = this.fEntityReader.currentOffset();
                    this.fEntityReader.lookingAtChar('?', true);
                    if (!this.fEntityReader.lookingAtChar('>', true)) break block9;
                    var5_5 = var6_6 - var4_4;
                    ** GOTO lbl29
                }
                do {
                    if (this.fEntityReader.lookingAtChar('?', false)) continue block0;
lbl29:
                    // 2 sources

                    if (var5_5 >= 0) break block0;
                    if (this.fEntityReader.lookingAtValidChar(true)) continue;
                    var6_6 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState != 13) {
                        if (var6_6 >= 0) {
                            this.reportFatalXMLError(8, 6, Integer.toHexString(var6_6));
                        }
                        this.skipPastEndOfCurrentMarkup();
                        this.restoreScannerState(var3_3);
                    }
                    return;
lbl38:
                    // 2 sources

                } while (this.fScannerState == 3);
            }
        }
        --this.fScannerMarkupDepth;
        this.restoreScannerState(var3_3);
        var6_6 = var5_5 == 0 ? 0 : this.fEntityReader.addString(var4_4, var5_5);
        this.fEventHandler.callProcessingInstruction(var1_1, var6_6);
    }

    /*
     * Enabled aggressive block sorting
     */
    void scanXMLDeclOrTextDecl(boolean bl) throws Exception {
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl2 = false;
        boolean bl3 = true;
        int n6 = 2;
        int n7 = 3;
        int n8 = 4;
        int n9 = 0;
        block9: do {
            int n10;
            this.fEntityReader.skipPastSpaces();
            n2 = this.fEntityReader.currentOffset();
            if (bl) {
                if (n9 == 0 && this.fEntityReader.skippedString(version_string)) {
                    n9 = 1;
                } else {
                    if (!this.fEntityReader.skippedString(encoding_string)) {
                        this.abortMarkup(29, 28);
                        return;
                    }
                    n9 = 2;
                }
            } else if (n9 == 0) {
                if (!this.fEntityReader.skippedString(version_string)) {
                    this.abortMarkup(30, 29);
                    return;
                }
                n9 = 1;
            } else {
                n9 = n9 == 1 ? (this.fEntityReader.skippedString(encoding_string) ? 2 : 3) : 3;
                if (n9 == 3 && !this.fEntityReader.skippedString(standalone_string)) break;
            }
            n = this.fEntityReader.currentOffset() - n2;
            this.fEntityReader.skipPastSpaces();
            if (!this.fEntityReader.lookingAtChar('=', true)) {
                int n11 = n10 = bl ? 32 : 31;
                int n12 = n9 == 1 ? 30 : (n9 == 2 ? 32 : 31);
                this.abortMarkup(n10, n12, this.fEntityReader.addString(n2, n));
                return;
            }
            this.fEntityReader.skipPastSpaces();
            n10 = this.fEntityReader.scanStringLiteral();
            switch (n10) {
                case -1: {
                    int n13;
                    int n14 = n13 = bl ? 34 : 33;
                    int n15 = n9 == 1 ? 33 : (n9 == 2 ? 35 : 34);
                    this.abortMarkup(n13, n15, this.fEntityReader.addString(n2, n));
                    return;
                }
                case -2: {
                    int n16 = this.fEntityReader.scanInvalidChar();
                    if (this.fScannerState == 13) return;
                    if (n16 >= 0) {
                        int n17;
                        int n18 = n17 = bl ? 36 : 35;
                        int n19 = n9 == 1 ? 36 : (n9 == 2 ? 38 : 37);
                        this.reportFatalXMLError(n17, n19, Integer.toHexString(n16));
                    }
                    this.skipPastEndOfCurrentMarkup();
                    return;
                }
            }
            switch (n9) {
                case 1: {
                    Object[] objectArray;
                    n3 = n10;
                    String string = this.fStringPool.toString(n3);
                    if (!"1.0".equals(string)) {
                        if (!this.validVersionNum(string)) {
                            this.abortMarkup(37, 39, string);
                            return;
                        }
                        objectArray = new Object[]{string};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 38, 40, objectArray, 1);
                    }
                    if (this.fEntityReader.lookingAtSpace(true)) continue block9;
                    if (bl) {
                        this.abortMarkup(39, 41);
                        return;
                    }
                    n9 = 4;
                    break;
                }
                case 2: {
                    n4 = n10;
                    Object[] objectArray = this.fStringPool.toString(n4);
                    if (!this.validEncName((String)objectArray)) {
                        this.abortMarkup(40, 42, (String)objectArray);
                        return;
                    }
                    if (!this.fEntityReader.lookingAtSpace(true)) {
                        n9 = 4;
                        break;
                    }
                    if (!bl) continue block9;
                    this.fEntityReader.skipPastSpaces();
                    n9 = 4;
                    break;
                }
                case 3: {
                    n5 = n10;
                    String string = this.fStringPool.toString(n5);
                    boolean bl4 = "yes".equals(string);
                    if (!bl4 && !"no".equals(string)) {
                        this.abortMarkup(41, 43, string);
                        return;
                    }
                    this.fStandalone = bl4;
                    this.fEntityReader.skipPastSpaces();
                    n9 = 4;
                    break;
                }
            }
        } while (n9 != 4);
        if (!this.fEntityReader.lookingAtChar('?', true) || !this.fEntityReader.lookingAtChar('>', true)) {
            if (bl) {
                n2 = 43;
                n = 45;
            } else {
                n2 = 42;
                n = 44;
            }
            this.abortMarkup(n2, n);
            return;
        }
        --this.fScannerMarkupDepth;
        if (bl) {
            this.fEventHandler.callTextDecl(n3, n4);
            return;
        }
        this.fEventHandler.callXMLDecl(n3, n4, n5);
        if (!this.fStandalone) return;
        this.fEventHandler.callStandaloneIsYes();
    }

    public void setDTDHandler(XMLDocumentHandler.DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void setLoadExternalDTD(boolean bl) {
        this.fLoadExternalDTD = bl;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.setLoadExternalDTD(bl);
        }
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    int setScannerState(int n) {
        int n2 = this.fScannerState;
        this.fScannerState = n;
        return n2;
    }

    public void setValidationEnabled(boolean bl) {
        this.fValidationEnabled = bl;
        if (this.fDTDScanner != null) {
            this.fDTDScanner.setValidationEnabled(bl);
        }
    }

    void skipPastEndOfCurrentMarkup() throws Exception {
        this.fEntityReader.skipToChar('>');
        if (this.fEntityReader.lookingAtChar('>', true)) {
            --this.fScannerMarkupDepth;
        }
    }

    private boolean validEncName(String string) {
        return XMLCharacterProperties.validEncName(string);
    }

    private boolean validVersionNum(String string) {
        return XMLCharacterProperties.validVersionNum(string);
    }

    public static interface EventHandler {
        public boolean attribute(QName var1, QName var2, int var3) throws Exception;

        public void callCharacters(int var1) throws Exception;

        public void callComment(int var1) throws Exception;

        public void callEndCDATA() throws Exception;

        public void callEndDocument() throws Exception;

        public void callEndElement(int var1) throws Exception;

        public void callProcessingInstruction(int var1, int var2) throws Exception;

        public void callStandaloneIsYes() throws Exception;

        public void callStartCDATA() throws Exception;

        public void callStartDocument() throws Exception;

        public void callStartElement(QName var1) throws Exception;

        public void callTextDecl(int var1, int var2) throws Exception;

        public void callXMLDecl(int var1, int var2, int var3) throws Exception;

        public void element(QName var1) throws Exception;
    }

    static interface ScannerDispatcher {
        public boolean dispatch(boolean var1) throws Exception;

        public void endOfInput(int var1, boolean var2) throws Exception;
    }

    final class XMLDeclDispatcher
    implements ScannerDispatcher {
        XMLDeclDispatcher() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean dispatch(boolean bl) throws Exception {
            block20: {
                block21: {
                    XMLDocumentScanner.this.fEventHandler.callStartDocument();
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) break block21;
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        int n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.scanXMLDeclOrTextDecl(false);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(n);
                        }
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                            break block20;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                        break block20;
                    } else {
                        if (XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(5);
                            return true;
                        }
                        XMLDocumentScanner.this.abortMarkup(129, 108);
                    }
                    break block20;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                } else if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    int n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13) {
                        XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                        XMLDocumentScanner.this.setScannerState(13);
                        return true;
                    }
                    if (n >= 0) {
                        String string = Integer.toHexString(n);
                        XMLDocumentScanner.this.reportFatalXMLError(52, 54, string);
                    }
                } else {
                    XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                    XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
                }
            }
            XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
            XMLDocumentScanner.this.restoreScannerState(5);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 1] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "1\t" + XMLDocumentScanner.this.fScannerState);
                }
                case 0: 
                case 1: 
                case 4: 
            }
            if (!bl) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }
    }

    final class PrologDispatcher
    implements ScannerDispatcher {
        PrologDispatcher() {
        }

        public boolean dispatch(boolean bl) throws Exception {
            do {
                int n;
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(n);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                XMLDocumentScanner.this.scanComment();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(129, 108);
                            }
                        } else if (!XMLDocumentScanner.this.fSeenDoctypeDecl && XMLDocumentScanner.this.fEntityReader.skippedString(doctype_string)) {
                            XMLDocumentScanner.this.setScannerState(4);
                            XMLDocumentScanner.this.fSeenDoctypeDecl = true;
                            XMLDocumentScanner.this.scanDoctypeDecl(XMLDocumentScanner.this.fStandalone);
                            --XMLDocumentScanner.this.fScannerMarkupDepth;
                        } else {
                            XMLDocumentScanner.this.abortMarkup(129, 108);
                        }
                    } else {
                        XMLDocumentScanner.this.fDispatcher = new ContentDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(6);
                        return true;
                    }
                    XMLDocumentScanner.this.restoreScannerState(5);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || n < 0) continue;
                    String string = Integer.toHexString(n);
                    XMLDocumentScanner.this.reportFatalXMLError(52, 54, string);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 2] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "2\t" + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 4: 
                case 5: 
            }
            if (!bl) {
                XMLDocumentScanner.this.reportFatalXMLError(134, 107);
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }
    }

    final class ContentDispatcher
    implements ScannerDispatcher {
        private int fContentReader = -1;
        private int fElementDepth = 0;
        private int[] fElementTypeStack = new int[8];

        ContentDispatcher() {
        }

        public boolean dispatch(boolean bl) throws Exception {
            block19: do {
                block0 : switch (XMLDocumentScanner.this.fScannerState) {
                    case 6: {
                        XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                        if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                            this.fContentReader = XMLDocumentScanner.this.fReaderId;
                            XMLDocumentScanner.this.fSeenRootElement = true;
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] nArray = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                    this.fElementTypeStack = nArray;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                if (this.fElementDepth == this.fElementTypeStack.length) {
                                    int[] nArray = new int[this.fElementDepth * 2];
                                    System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                    this.fElementTypeStack = nArray;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                ++this.fElementDepth;
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break;
                            }
                            XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                            XMLDocumentScanner.this.restoreScannerState(12);
                            return true;
                        }
                        XMLDocumentScanner.this.reportFatalXMLError(129, 108);
                        XMLDocumentScanner.this.fDispatcher = new PrologDispatcher();
                        XMLDocumentScanner.this.restoreScannerState(5);
                        return true;
                    }
                    case 1: {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                            int n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                            if (n == -1) {
                                XMLDocumentScanner.this.abortMarkup(131, 105);
                            } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                    if (XMLDocumentScanner.this.fParseTextDecl) {
                                        XMLDocumentScanner.this.scanXMLDeclOrTextDecl(true);
                                        XMLDocumentScanner.this.fParseTextDecl = false;
                                    } else {
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                }
                            } else {
                                XMLDocumentScanner.this.scanPI(n);
                            }
                            XMLDocumentScanner.this.restoreScannerState(7);
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                                    XMLDocumentScanner.this.scanComment();
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                            } else if (XMLDocumentScanner.this.fEntityReader.skippedString(cdata_string)) {
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.callStartCDATA();
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('/', true)) {
                            if (!XMLDocumentScanner.this.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fCurrentElementType)) {
                                XMLDocumentScanner.this.abortMarkup(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                            } else {
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.reportFatalXMLError(57, 59, XMLDocumentScanner.this.fCurrentElementType);
                                    }
                                }
                                --XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                }
                                if (this.fElementDepth == 0) {
                                    XMLDocumentScanner.this.fCurrentElementType = -1;
                                    XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                    XMLDocumentScanner.this.restoreScannerState(12);
                                    return true;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                            }
                        } else {
                            XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                            if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                    XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] nArray = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                        this.fElementTypeStack = nArray;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                    this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                    ++this.fElementDepth;
                                } else if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                    if (this.fElementDepth == this.fElementTypeStack.length) {
                                        int[] nArray = new int[this.fElementDepth * 2];
                                        System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                        this.fElementTypeStack = nArray;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                    this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                    ++this.fElementDepth;
                                }
                            } else {
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                            }
                        }
                        XMLDocumentScanner.this.restoreScannerState(7);
                        break;
                    }
                    case 7: {
                        if (XMLDocumentScanner.this.fParseTextDecl && XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                            ++XMLDocumentScanner.this.fScannerMarkupDepth;
                            XMLDocumentScanner.this.setScannerState(1);
                            break;
                        }
                        XMLDocumentScanner.this.fCurrentElementQName.setValues(-1, -1, XMLDocumentScanner.this.fCurrentElementType);
                        switch (XMLDocumentScanner.this.fEntityReader.scanContent(XMLDocumentScanner.this.fCurrentElementQName)) {
                            case 0: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                int n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                                if (n == -1) {
                                    XMLDocumentScanner.this.abortMarkup(131, 105);
                                    break block0;
                                }
                                if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                        if (XMLDocumentScanner.this.fReaderId == this.fContentReader) {
                                            XMLDocumentScanner.this.abortMarkup(104, 137);
                                            break block0;
                                        }
                                        XMLDocumentScanner.this.abortMarkup(105, 138);
                                        break block0;
                                    }
                                    XMLDocumentScanner.this.abortMarkup(6, 4);
                                    break block0;
                                }
                                XMLDocumentScanner.this.scanPI(n);
                                break block0;
                            }
                            case 1: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.scanComment();
                                break block0;
                            }
                            case 2: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fEntityReader.setInCDSect(true);
                                XMLDocumentScanner.this.fEventHandler.callStartCDATA();
                                break block0;
                            }
                            case 4: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (!XMLDocumentScanner.this.scanExpectedElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fCurrentElementType)) {
                                    XMLDocumentScanner.this.abortMarkup(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                                } else {
                                    if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                                        if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                            XMLDocumentScanner.this.reportFatalXMLError(57, 59, XMLDocumentScanner.this.fCurrentElementType);
                                        }
                                    }
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                    XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                    if (this.fElementDepth-- == 0) {
                                        throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                    }
                                    if (this.fElementDepth == 0) {
                                        XMLDocumentScanner.this.fCurrentElementType = -1;
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.restoreScannerState(12);
                                        return true;
                                    }
                                    XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 6: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.scanElementType(XMLDocumentScanner.this.fEntityReader, '>', XMLDocumentScanner.this.fElementQName);
                                if (XMLDocumentScanner.this.fElementQName.rawname != -1) {
                                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('>', true)) {
                                        XMLDocumentScanner.this.fEventHandler.callStartElement(XMLDocumentScanner.this.fElementQName);
                                        --XMLDocumentScanner.this.fScannerMarkupDepth;
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] nArray = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                            this.fElementTypeStack = nArray;
                                        }
                                        XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                        this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                        ++this.fElementDepth;
                                    } else if (XMLDocumentScanner.this.scanElement(XMLDocumentScanner.this.fElementQName)) {
                                        if (this.fElementDepth == this.fElementTypeStack.length) {
                                            int[] nArray = new int[this.fElementDepth * 2];
                                            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
                                            this.fElementTypeStack = nArray;
                                        }
                                        XMLDocumentScanner.this.fCurrentElementType = XMLDocumentScanner.this.fElementQName.rawname;
                                        this.fElementTypeStack[this.fElementDepth] = XMLDocumentScanner.this.fElementQName.rawname;
                                        ++this.fElementDepth;
                                    }
                                } else {
                                    XMLDocumentScanner.this.abortMarkup(127, 110);
                                }
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 5: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fEventHandler.callEndElement(XMLDocumentScanner.this.fReaderId);
                                if (this.fElementDepth-- == 0) {
                                    throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
                                }
                                if (this.fElementDepth == 0) {
                                    XMLDocumentScanner.this.fCurrentElementType = -1;
                                    if (XMLDocumentScanner.this.fScannerState != 13) {
                                        XMLDocumentScanner.this.fDispatcher = new TrailingMiscDispatcher();
                                        XMLDocumentScanner.this.fScannerState = 12;
                                    }
                                    return true;
                                }
                                XMLDocumentScanner.this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                XMLDocumentScanner.this.fScannerState = 7;
                                break block0;
                            }
                            case 7: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int n = XMLDocumentScanner.this.scanCharRef();
                                if (n != -1) {
                                    XMLDocumentScanner.this.fEventHandler.callCharacters(n);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 8: 
                            case 12: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.setScannerState(8);
                                int n = XMLDocumentScanner.this.fEntityReader.currentOffset();
                                XMLDocumentScanner.this.fEntityReader.skipPastName(';');
                                int n2 = XMLDocumentScanner.this.fEntityReader.currentOffset() - n;
                                if (n2 == 0) {
                                    XMLDocumentScanner.this.reportFatalXMLError(14, 13);
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtChar(';', true)) {
                                    XMLDocumentScanner.this.reportFatalXMLError(15, 14, XMLDocumentScanner.this.fEntityReader.addString(n, n2));
                                    XMLDocumentScanner.this.restoreScannerState(7);
                                    break block0;
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                int n3 = XMLDocumentScanner.this.fEntityReader.addSymbol(n, n2);
                                XMLDocumentScanner.this.fParseTextDecl = XMLDocumentScanner.this.fEntityHandler.startReadingFromEntity(n3, this.fElementDepth, 2);
                                break block0;
                            }
                            case 3: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                    XMLDocumentScanner.this.fEntityReader.setInCDSect(false);
                                    XMLDocumentScanner.this.fEventHandler.callEndCDATA();
                                    --XMLDocumentScanner.this.fScannerMarkupDepth;
                                } else {
                                    XMLDocumentScanner.this.reportFatalXMLError(124, 104);
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 9: {
                                int n3;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                if (XMLDocumentScanner.this.fScannerState == 13) continue block19;
                                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                                    n3 = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                                    if (XMLDocumentScanner.this.fScannerState != 13 && n3 >= 0) {
                                        if (XMLDocumentScanner.this.fEntityReader.getInCDSect()) {
                                            XMLDocumentScanner.this.reportFatalXMLError(54, 56, Integer.toHexString(n3));
                                        } else {
                                            XMLDocumentScanner.this.reportFatalXMLError(55, 57, Integer.toHexString(n3));
                                        }
                                    }
                                }
                                XMLDocumentScanner.this.restoreScannerState(7);
                                break block0;
                            }
                            case 10: {
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.abortMarkup(127, 110);
                                break block0;
                            }
                            case 11: {
                                ++XMLDocumentScanner.this.fScannerMarkupDepth;
                                XMLDocumentScanner.this.fParseTextDecl = false;
                                XMLDocumentScanner.this.fScannerState = 1;
                                break block0;
                            }
                            default: {
                                throw new RuntimeException("FWK001 3] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "3\t" + XMLDocumentScanner.this.fScannerState);
                            }
                        }
                    }
                    default: {
                        throw new RuntimeException("FWK001 4] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "4\t" + XMLDocumentScanner.this.fScannerState);
                    }
                }
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            switch (XMLDocumentScanner.this.fScannerState) {
                case 7: {
                    if (!XMLDocumentScanner.this.fEntityReader.getInCDSect()) break;
                    XMLDocumentScanner.this.reportFatalXMLError(66, 66);
                    break;
                }
                case 11: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(151, 136, XMLDocumentScanner.this.fAttValueElementType, XMLDocumentScanner.this.fAttValueAttrName);
                        break;
                    }
                    if (XMLDocumentScanner.this.fReaderId == XMLDocumentScanner.this.fAttValueReader) break;
                    XMLDocumentScanner.this.fEntityReader.append(XMLDocumentScanner.this.fLiteralData, XMLDocumentScanner.this.fAttValueMark, XMLDocumentScanner.this.fAttValueOffset - XMLDocumentScanner.this.fAttValueMark);
                    break;
                }
                case 2: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(162, 68);
                    break;
                }
                case 3: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(165, 68);
                    break;
                }
                case 8: {
                    if (!bl) {
                        XMLDocumentScanner.this.reportFatalXMLError(166, 135);
                        break;
                    }
                    XMLDocumentScanner.this.reportFatalXMLError(161, 68);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 5] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "5\t" + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 6: 
                case 9: 
                case 10: 
            }
            if (!bl) {
                if (this.fElementDepth > 0) {
                    XMLDocumentScanner.this.reportFatalXMLError(56, 58, XMLDocumentScanner.this.fCurrentElementType);
                } else {
                    XMLDocumentScanner.this.reportFatalXMLError(134, 107, null);
                }
                XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
                XMLDocumentScanner.this.setScannerState(13);
            }
        }

        void popElementType() {
            if (this.fElementDepth-- == 0) {
                throw new RuntimeException("FWK002 popElementType: fElementDepth-- == 0.");
            }
            XMLDocumentScanner.this.fCurrentElementType = this.fElementDepth == 0 ? -1 : this.fElementTypeStack[this.fElementDepth - 1];
        }
    }

    final class TrailingMiscDispatcher
    implements ScannerDispatcher {
        TrailingMiscDispatcher() {
        }

        public boolean dispatch(boolean bl) throws Exception {
            do {
                int n;
                if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('<', true)) {
                    ++XMLDocumentScanner.this.fScannerMarkupDepth;
                    XMLDocumentScanner.this.setScannerState(1);
                    if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('?', true)) {
                        n = XMLDocumentScanner.this.fEntityReader.scanName(' ');
                        if (n == -1) {
                            XMLDocumentScanner.this.abortMarkup(131, 105);
                        } else if ("xml".equals(XMLDocumentScanner.this.fStringPool.toString(n))) {
                            if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                                XMLDocumentScanner.this.abortMarkup(104, 137);
                            } else {
                                XMLDocumentScanner.this.abortMarkup(6, 4);
                            }
                        } else {
                            XMLDocumentScanner.this.scanPI(n);
                        }
                    } else if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('!', true)) {
                        if (XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true) && XMLDocumentScanner.this.fEntityReader.lookingAtChar('-', true)) {
                            XMLDocumentScanner.this.scanComment();
                        } else {
                            XMLDocumentScanner.this.abortMarkup(128, 109);
                        }
                    } else {
                        XMLDocumentScanner.this.abortMarkup(128, 109);
                    }
                    XMLDocumentScanner.this.restoreScannerState(12);
                    continue;
                }
                if (XMLDocumentScanner.this.fEntityReader.lookingAtSpace(true)) {
                    XMLDocumentScanner.this.fEntityReader.skipPastSpaces();
                    continue;
                }
                if (!XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(false)) {
                    n = XMLDocumentScanner.this.fEntityReader.scanInvalidChar();
                    if (XMLDocumentScanner.this.fScannerState == 13 || n < 0) continue;
                    String string = Integer.toHexString(n);
                    XMLDocumentScanner.this.reportFatalXMLError(53, 55, string);
                    continue;
                }
                XMLDocumentScanner.this.reportFatalXMLError(128, 109);
                XMLDocumentScanner.this.fEntityReader.lookingAtValidChar(true);
            } while (XMLDocumentScanner.this.fScannerState != 13 && bl);
            return true;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            if (bl) {
                throw new RuntimeException("FWK003 TrailingMiscDispatcher.endOfInput moreToFollow");
            }
            switch (XMLDocumentScanner.this.fScannerState) {
                case 2: {
                    XMLDocumentScanner.this.reportFatalXMLError(163, 133);
                    break;
                }
                case 3: {
                    XMLDocumentScanner.this.reportFatalXMLError(164, 134);
                    break;
                }
                default: {
                    throw new RuntimeException("FWK001 6] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "6\t" + XMLDocumentScanner.this.fScannerState);
                }
                case 1: 
                case 12: 
            }
            XMLDocumentScanner.this.fDispatcher = new EndOfInputDispatcher();
            XMLDocumentScanner.this.setScannerState(13);
        }
    }

    final class EndOfInputDispatcher
    implements ScannerDispatcher {
        EndOfInputDispatcher() {
        }

        public boolean dispatch(boolean bl) throws Exception {
            if (XMLDocumentScanner.this.fScannerState != 14) {
                XMLDocumentScanner.this.fEventHandler.callEndDocument();
            }
            XMLDocumentScanner.this.setScannerState(14);
            return false;
        }

        public void endOfInput(int n, boolean bl) throws Exception {
            throw new RuntimeException("FWK001 7] ScannerState=" + XMLDocumentScanner.this.fScannerState + "\n" + "7\t" + XMLDocumentScanner.this.fScannerState);
        }
    }
}

