#ifndef _EP_H_
#define _EP_H_

#include <stdio.h>
#include "lg.h"
#include <glib.h>

typedef void EP_input_structure_t;
typedef void EP_blob_credential_t;
typedef void (*ObjFunc) (EP_blob_credential_t* data, gpointer user_data);

void EP_init(LG_context_t* ctx);
void EP_end();

EP_input_structure_t* EP_unfold(FILE* stream, gboolean is_mail);

gchar* EP_get_candidate_keywords(EP_input_structure_t* input);
const gchar* EP_get_mail_hdr_field(EP_input_structure_t* input, gchar* field);
void EP_blobs_foreach(EP_input_structure_t* input, ObjFunc func, gpointer user_data);

const gchar* EP_get_blob(EP_blob_credential_t* input);
GList* EP_get_credentials(EP_blob_credential_t* input);

void EP_input_structure_free(EP_input_structure_t* input);
void EP_blob_credential_free(EP_blob_credential_t* blob_credential);

#endif
