/***************************************
  $Revision: 1.3 $

  Error reporting (er) er_formats.{m4,h} - definition of error formats
                              error reporting module.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

#ifndef ER_FORMATS_H
#define ER_FORMATS_H


typedef struct {
  char *n;
  int v;
} er_form_el;

#ifdef ER_IMPL
#define EXTDEF
#define EXTINI(a,b) a = b;
#else
#define EXTDEF extern 
#define EXTINI(a,b) extern a;
#endif

/* m4 macro: #define a symbol and put its string version into the array
   at the same time. The string version will have "ASP_" cut off if
   the string begins with it. The #defines are diverted to stream 9, so
   they appear later in the output (outside the /endif block)
*/



typedef enum {
   
 ER_M_SEVCHAR = (1<<0 ),
 ER_M_SEVLONG = (1<<1),
 ER_M_MNEMONIC = (1<<2),
 ER_M_TEXTLONG = (1<<3),
 ER_M_UIDUID = (1<<4),
 ER_M_UIDEUID = (1<<5),
 ER_M_PIDFULL = (1<<6),
 ER_M_FACSYMB = (1<<7),
 ER_M_PROGNAME = (1<<8),
 ER_M_DATETIME = (1<<9),
 ER_M_THR_ID = (1<<10),
 __ER_fmt_slack  /* to close the list after the last comma */

} er_format_mt; 


EXTDEF
er_form_el er_formarr[]
#ifdef ER_IMPL
= {
/* m4 - paste the definitions here */
    { "SEVCHAR", ER_M_SEVCHAR },
    { "SEVLONG", ER_M_SEVLONG },
    { "MNEMONIC", ER_M_MNEMONIC },
    { "TEXTLONG", ER_M_TEXTLONG },
    { "UIDUID", ER_M_UIDUID },
    { "UIDEUID", ER_M_UIDEUID },
    { "PIDFULL", ER_M_PIDFULL },
    { "FACSYMB", ER_M_FACSYMB },
    { "PROGNAME", ER_M_PROGNAME },
    { "DATETIME", ER_M_DATETIME },
    { "THR_ID", ER_M_THR_ID },
 
  {NULL, 0} 
}
#endif /* ER_IMPL */
;


#endif /* ER_FORMATS_H */
