#       dbclose - close a database
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: dbclose.pl,v 2.5 1999/01/11 09:08:29 roman Exp $
#
#	$RCSfile: dbclose.pl,v $
#	$Revision: 2.5 $
#	$Author: roman $
#	$Date: 1999/01/11 09:08:29 $

sub dbclose {
    local(*db) = @_;
    my($name) = $db[1];

    if ($db[0] == 1) {
#	&dpr("closing database $name\n");
	# $::opened_databases{$name}{'open_count'}--;
	# if ( $::opened_databases{$name}{'open_count'} == 0 ) {
	    untie %db;
	    &fatalerror("in dbclose: cannot close $name -  code: $!") 
		if ( ! close($db) );

	    $db[0] = 0;
	    $db[1] = "";

	    # undef @db;
	    # undef %db;
	    # delete $::opened_databases{$name}{'open_count'};
	    # delete $::opened_databases{$name}{'handle'};
	    # delete $::opened_databases{$name}{'array'};
	    # delete $::opened_databases{$name}{'tied_hash'};
#	    delete $::opened_databases{$name}{'status'};
#	    delete $::opened_databases{$name};
#	    &dpr("database $name closed\n");
	# }
    }
}

sub dbclclose {
    untie %mspnxl;
    $mspnxl[0] = 0;
}

# open all databases opened by opendatabases when modifying/creating objects

sub closedatabases {
    local($type, $split, *db, *nicdb, *othernicdb, *mtdb, *andb) = @_;

    &dbclclose() if ($CLASSLESSDBS{$type});
    &dbclose(*db);
    if ($split) {
	&dbclose(*nicdb);
	&dbclose(*othernicdb);
	&dbclose(*mtdb);
	&dbclose(*andb);
    }
}

1;
