#       encmp - compare two associative arrays
#
#	$RCSfile: endiffs.pl,v $
#	$Revision: 0.12 $
#	$Author: marten $
#	$Date: 1994/09/20 12:02:12 $
#
#	This routine takes two assoc arrays and compares them
#	It returns a list of differences: (key, this, that).
#
#       Arguments:
#	*this, *that		two pointers to assoc arrays

sub endiffs {
    local(*this, *that) = @_;
    local(@diffs) = ();
    local($lastkey) = "";

    # Get all values of both assoc arrays

    foreach (sort (keys %this, keys %that)) {
	next if $lastkey eq $_;
	$lastkey = $_;
	if ($that{$_} ne $this{$_}) {
	    @diffs = (@diffs, $_, $this{$_}, $that{$_});
	}
    }
    return (@diffs);
}

1;
