

%option noyywrap
%option case-insensitive
%{

#include "erroutines.h"

#include "er.yacc.tab.h"
#include "string.h"
#include "er_yacc_helper.h"

int errorColon = 0; 

#define YY_DECL int yylex(YYSTYPE *yylval, lexerr_t *erst)
#define YY_USER_ACTION { erst->errpos += yyleng; }
#define YY_NO_UNPUT

void lexcleancurbuf(void)  {
  yy_delete_buffer(yy_current_buffer);
}

%}


digit [0-9]
digits {digit}+
whitespace [ \t]
%%
"{" {  return '{';}
"}" {  return '}';}
"(" {  return '(';}
")" {  return ')';}
"|" {  return '|';}
"-" {  return '-';}
SOCK { return K_SOCK;}
NAME { return K_NAME;}
FAC  { return K_FAC; }
SEV { return K_SEV; }
ASP { return K_ASP; }
THR { return K_THR; }
ADD    { return K_ADD; }  
RM     { return K_RM;  }   
CREATE { return K_CREATE;  }
DELETE { return K_DELETE;  }
MODIFY { return K_MODIFY;  }
FORMAT { return K_FORMAT; }
AUTO   { return K_AUTO; }  
SELF   { return K_SELF; }
DATE   { return K_DATE; }
ALL    { return K_ALL; }
EXEC   { return K_EXEC; }
PATH   { return K_PATH; }

0[xX][0-9a-fA-F]+ { sscanf(yytext,"%x", &(yylval->inum) ); return HEXNUM; }

{digits} { yylval->inum = atoi(yytext); return NUMBER; }

[a-zA-Z0-9/_.@#]+ { /* none of "-(){}|" because they are used by parser 
		     as delimiting tokens */
  
  yylval->text = erst->token = strdup(yytext); 
#if 0
  printf("string is %s\n", yytext); 
#endif
  return STRING; 
}

{whitespace} ;
\n { return EOL; }
