#ifndef CA_DEFS
#define CA_DEFS

/************************************************************************
 * This is the definitions header file for the configuration module.  It
 * includes the definitions of data structures, external declarations and
 * definitions, definitions of sybolic constants.
 *
 ************************************************************************/

#include <pthread.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Number of configurations variables. */
#define VARS 90

#define SCOPE_GLOBAL 1
#define SCOPE_LOCAL 99

/* 
 * Define the length of a string to be 160 to cope with the 
 * copyright statement.
 *
 */
#define STRLENGTH 160

/*
	* Define the length of strings to cope with the values of 
 * various types of string variables.
	*/
#define STRLENGTH_S 40
#define STRLENGTH_M 80
#define STRLENGTH_L 160
#define STRLENGTH_XL 320
#define STRLENGTH_XXL 640


/**********************************************
 * Default values for the SOURCE variables		*
	*															*
 **********************************************/

 #define CA_DEFHOST "rowan"						
 #define CA_DEFPORT "4343"
 #define CA_DEFUSER "dbase"						
 #define CA_DEFPASSWORD "encrypt1"				
 #define CA_DEFDBNAME	"default-db"			
															


/**********************************************
 * Defintion of the dictionary structures.		*
	*															*
 **********************************************/

typedef struct dict_s	{
				char varName[STRLENGTH];
				char varSym[STRLENGTH];
				char varType[STRLENGTH];
				int varScope;
				int varNum;
} dict_t;

extern dict_t dictionary[];




/**********************************************
 * Definition of the values structures.			*
 *															*
	**********************************************/

typedef struct values_s	{
				char *strPtr;	/* Pointer to the string that contains the value. */
				void *valPtr;	/* Pointer to the actual value. */
} values_t;									

/*
 * "extern" definition of variables that are defined elsewhere.
 */


extern values_t globals[];
extern values_t locals[];

/*
 * "extern" definition of configuration variables, defined elsewhere.
 */
extern values_t confVars[];

/* Mutex lock; used for synchronising changes. */
pthread_mutex_t Lock;

/* 
	* New value of the bindport.
	* This must be a global variable.
	*/

char newPort[16];

/*
 * The following is needed for the SOURCE variable.  First,
 * we define the "database" structure.  Then, we define the
 * structure of an element of the linked list.  Lastly, we 
 * define the linked list itself.
 */

typedef struct ca_database_s	{

			char host[64];
			int port;
			char user[16];
			char password[9];
			char dbName[16];
		} ca_database_t;

typedef struct ca_mirror_s		{
			char host[64];
			int port;
			char log[64];
			int delay;
			int protocolVer;
		} ca_mirror_t;

typedef struct ca_ripadmin_s	{
			char host[64];
			int port;
			char user[16];
			char password[9];
			char tableName[16];
		} ca_ripadmin_t;

extern ca_database_t ripe;
extern ca_database_t arin;
extern ca_database_t radb;

typedef struct ca_database_list_s		{
			char name[16];	
			ca_database_t db;
			int opMode;
			ca_mirror_t nrtm;
			int updPort;
			char canupd[2];
			char deflook[2];
		} ca_database_list_t;

/*
	* Define the type of a source.
 * This is the name of a source and
 * the details of the database which 
 * makes this source.
 */
typedef struct ca_dbSource_s	{
			char name[16];
			ca_database_t db;
			int opMode;
			ca_mirror_t nrtm;
			int updPort;
			char canupd[2];
			char deflook[2];
		} ca_dbSource_t;

/*
 * Define the source handle:
 * this is a pointer to a source;
 * i.e. it is of type ca_dbSource_t.
 */
typedef ca_dbSource_t ca_SrcHdl_t;

extern ca_database_list_t ripeComponent;
extern ca_database_list_t arinComponent;
extern ca_database_list_t radbComponent;

/*
 * typedef struct GSList {
	*  	gpointer src;		
	*  	GSList *next;
	* 	} ca_source_t;
 */
 /* gpointer src;		This points to a ca_database_list_t varialbe */


/*************************************************************
 * Definition of the default values for the SOURCE variable.	*
 *																				*
 *************************************************************/

/*
 * char ca_defHost[64];
 * char ca_defPort[16];
 * char ca_defUser[16];
 * char ca_defPassword[9];
 * char ca_defdbName[16];
 */

/*
 * extern char ca_defPort[16];
 * extern char ca_defHost[64];
 * extern char ca_defUser[16];
 * extern char ca_defPassword[9];
 * extern char ca_defdbName[16];
 */

/*
 * The linked-list of sources.
 *
 */
extern GSList *sourceList;

/*
 * extern ca_source_t *srcList;
 */

/*
 * A varialbe of type GSList
 */
extern ca_dbSource_t *testSource;


/*
 * 20000609
 * Experiment:
 * define the variable mySrcList as type GSList;
 * use the extern modifier and put the "real" definition
 * of the variable elsewhere.
 *
 * extern GSList *mySrcList;
 */

/*
	* The test configuration file.
 * This is defined using a constant string, cf. Oualline, p.145.
 */
extern const char *testFile;
extern const char *tempFile;
extern const char *dictFile;
extern const char *confFile;

/* 
 * Value returned by ca_getStorageLocation if the symbol for
 * a configuration variable cannot be found.
 *
	* This value is also returned by ca_getType, if it cannot map 
 * the name of a configuration variable to a data type.
 *
 */
#define NOT_FOUND -1 	

/*
 * Symbolic constants defined to represent data types.

 * #define CA_INT 			11
 * #define CA_STRING 		12
 * #define CA_DIRLIST 	13
 * #define CA_BOOLEAN 	14
 * #define CA_SOURCETYPE		15
	*/

extern ca_dbSource_t *theSrc;

#ifdef __cplusplus
}
#endif


#endif /* CA_DEFS */
