#ifndef READ_SOCKET
#define READ_SOCKET
/***************************************
  $Revision: 1.16 $

  Socket module (sk)

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <stdlib.h>
#include <errno.h>
#include <netdb.h>

#include <signal.h>
#include <stdio.h>

#include <iproutines.h>

/* connection data -> helps keep track of all errors etc */
typedef struct {
  int            sock;         /* socket descriptor # */
  struct timeval rd_timeout;   /* preset timeout values */
  struct timeval wr_timeout; 
  unsigned short rtc;                   /* RTC flags (reason-to-close) */

  pthread_t      watchdog;     /* thread id of the watchdog associated */
  pthread_t      killthis;     /* thread to be killed by watchdog */
  void * (*execthis)(void *);  /* function to be called if watchdog triggers */
  void *         execargs;     /* argument to be passed to that function */
  pthread_mutex_t watchmutex;

  unsigned char  lasterr;      /* timeout, interrupt, etc. */
  ip_addr_t rIP;              /* real IP */
  ip_addr_t eIP;              /* effective IP */
  char *ip;                    /* text of the eIP */
} sk_conn_st;

/* reasons to close: socket-wise .... */
#define SK_DISCONNECT 0x0001
#define SK_INTERRUPT  0x0002
#define SK_TIMEOUT    0x0004

/* ... and user-wise: */
#define SK_NOTEXT     0x0100

int SK_atoport(const char *service, const char *proto);
int SK_close(int socket);
int SK_getsock(int socket_type, u_short port, uint32_t bind_address);
int SK_accept_connection(int listening_socket);
int SK_read(int sockfd, char *buf, size_t count);
int SK_write(int sockfd, const char *buf, size_t count);
int SK_gets(int sockfd, char *str, size_t count);
int SK_puts(int sockfd, const char *str);
int SK_putc(int sockfd, char ch);
int SK_getc(int sockfd);
char *SK_getpeername(int sockfd);
int SK_getpeerip(int sockfd, ip_addr_t *ip);
int SK_cd_puts(sk_conn_st *condat, const char *str);
int SK_cd_gets(sk_conn_st *condat, char *str, size_t count);
int SK_cd_close(sk_conn_st *condat);
int SK_cd_printf(sk_conn_st *condat, char *txt, ...)
#ifdef __GNUC__  /* let gcc check the format string for problems */
     __attribute__ ((format (printf, 2, 3)))
#endif
     ;
void SK_init(void);

#endif /* READ_SOCKET */

er_ret_t SK_watchstart(sk_conn_st *condat);
er_ret_t SK_watchstop(sk_conn_st *condat);
void SK_watchkill(sk_conn_st *condat, pthread_t killthis);
void SK_watchexec( sk_conn_st *condat, void *(*function)(void *), void *args);
void SK_watchclear(sk_conn_st *condat);
