# In case the database already exists (create returned an error)

DROP TABLE IF EXISTS person_role;
DROP TABLE IF EXISTS mntner;
DROP TABLE IF EXISTS key_cert;
DROP TABLE IF EXISTS aut_num;
DROP TABLE IF EXISTS route;
DROP TABLE IF EXISTS as_set;
DROP TABLE IF EXISTS route_set;
DROP TABLE IF EXISTS inet_rtr;
DROP TABLE IF EXISTS rtr_set;
DROP TABLE IF EXISTS filter_set;
DROP TABLE IF EXISTS peering_set;
DROP TABLE IF EXISTS as_block;
DROP TABLE IF EXISTS inet6num;
DROP TABLE IF EXISTS inetnum;
DROP TABLE IF EXISTS domain;
DROP TABLE IF EXISTS limerick;
DROP TABLE IF EXISTS last;
DROP TABLE IF EXISTS history;
DROP TABLE IF EXISTS mbrs_by_ref;
DROP TABLE IF EXISTS member_of;
DROP TABLE IF EXISTS admin_c;
DROP TABLE IF EXISTS tech_c;
DROP TABLE IF EXISTS zone_c;
DROP TABLE IF EXISTS mnt_by;
DROP TABLE IF EXISTS mnt_lower;
DROP TABLE IF EXISTS cross_mnt;
DROP TABLE IF EXISTS cross_nfy;
DROP TABLE IF EXISTS mnt_routes;
DROP TABLE IF EXISTS author;
DROP TABLE IF EXISTS names;
DROP TABLE IF EXISTS auth;
DROP TABLE IF EXISTS auth_override;
DROP TABLE IF EXISTS ifaddr;
DROP TABLE IF EXISTS rev_srv;
DROP TABLE IF EXISTS refer;
DROP TABLE IF EXISTS nserver;
DROP TABLE IF EXISTS sub_dom;
DROP TABLE IF EXISTS e_mail;
DROP TABLE IF EXISTS notify;
DROP TABLE IF EXISTS mnt_nfy;
DROP TABLE IF EXISTS upd_to;
DROP TABLE IF EXISTS serials;

#
# Main tables
#

#
# Table structure for table 'person_role'
#
CREATE TABLE person_role (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  nic_hdl varchar(30) DEFAULT '' NOT NULL,
  object_type tinyint(4) unsigned DEFAULT '0' NOT NULL,
  dummy tinyint DEFAULT '0' NOT NULL,
#  UNIQUE nic_hdl (nic_hdl(20)),
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'mntner'
#
CREATE TABLE mntner (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mntner varchar(80) DEFAULT '' NOT NULL,
  dummy tinyint(4) DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'key_cert'
#
CREATE TABLE key_cert (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  key_cert varchar(32) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'aut_num'
#
CREATE TABLE aut_num (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  aut_num char(7) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'route'
#
CREATE TABLE route (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  prefix int(10) unsigned DEFAULT '0' NOT NULL,
  prefix_length tinyint(3) unsigned DEFAULT '0' NOT NULL,
  origin char(7) DEFAULT '' NOT NULL,
  dummy tinyint(4) DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'as_set'
#
CREATE TABLE as_set (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  as_set varchar(80) DEFAULT '' NOT NULL,
  dummy tinyint(4) DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'route_set'
#
CREATE TABLE route_set (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  route_set varchar(80) DEFAULT '' NOT NULL,
  dummy tinyint(4) DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'inet_rtr'
#
CREATE TABLE inet_rtr (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  inet_rtr varchar(244) DEFAULT '' NOT NULL,
  local_as char(7) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'rtr_set'
#
CREATE TABLE rtr_set (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  rtr_set varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'filter_set'
#
CREATE TABLE filter_set (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  filter_set varchar(80) DEFAULT '' NOT NULL,
  filter longblob NOT NULL,
  PRIMARY KEY (object_id)
);


#
# Table structure for table 'peering_set'
#
CREATE TABLE peering_set (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  peering_set varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);


#
# Table structure for table 'as_block'
#
CREATE TABLE as_block (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  begin_as int(10) unsigned DEFAULT '0' NOT NULL,
  end_as int(10) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'inet6num'
#
CREATE TABLE inet6num (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  begin_i6_msb bigint(20) unsigned DEFAULT '0' NOT NULL,
  begin_i6_lsb bigint(20) unsigned DEFAULT '0' NOT NULL,
  end_i6_msb bigint(20) unsigned DEFAULT '0' NOT NULL,
  end_i6_lsb bigint(20) unsigned DEFAULT '0' NOT NULL,
  netname varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);


#
# Table structure for table 'inetnum'
#
CREATE TABLE inetnum (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  begin_in int(10) unsigned DEFAULT '0' NOT NULL,
  end_in int(10) unsigned DEFAULT '0' NOT NULL,
  netname varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'domain'
#
CREATE TABLE domain (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  domain varchar(244) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'limerick'
#
CREATE TABLE limerick (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  limerick varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'last'
#
CREATE TABLE last (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
# we start counting from 1
  sequence_id int(10) unsigned DEFAULT '1' NOT NULL,
  timestamp int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  object longblob NOT NULL,
  PRIMARY KEY (object_id,sequence_id)
);

#
# Table structure for table 'history'
#
CREATE TABLE history (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  sequence_id int(10) unsigned DEFAULT '0' NOT NULL,
  timestamp int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  object longblob NOT NULL,
  PRIMARY KEY (object_id,sequence_id)
);


#
# Auxilary tables
#


#
# Table structure for table 'mbrs_by_ref'
#
CREATE TABLE mbrs_by_ref (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (mnt_id,object_id)
);

#
# Table structure for table 'member_of'
#
CREATE TABLE member_of (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  set_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (set_id,object_id)
);

#
# Table structure for table 'admin_c'
#
CREATE TABLE admin_c (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  pe_ro_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (pe_ro_id,object_id)
);

#
# Table structure for table 'tech_c'
#
CREATE TABLE tech_c (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  pe_ro_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (pe_ro_id,object_id)
);

#
# Table structure for table 'zone_c'
#
CREATE TABLE zone_c (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  pe_ro_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (pe_ro_id,object_id)
);

#
# Table structure for table 'mnt_by'
#
CREATE TABLE mnt_by (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (mnt_id,object_id)
);

#
# Table structure for table 'mnt_lower'
#
CREATE TABLE mnt_lower (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (mnt_id,object_id)
);

#
# Table structure for table 'cross_mnt'
#
CREATE TABLE cross_mnt (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (mnt_id,object_id)
);

#
# Table structure for table 'cross_nfy'
#
CREATE TABLE cross_nfy (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  pe_ro_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (pe_ro_id,object_id)
);

#
# Table structure for table 'mnt_routes'
#
CREATE TABLE mnt_routes (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_id int(10) unsigned DEFAULT '0' NOT NULL,
  prefix_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id,mnt_id)
);

#
# Table structure for table 'author'
#
CREATE TABLE author (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  pe_ro_id int(10) unsigned DEFAULT '0' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (pe_ro_id,object_id)
);

#
# Leaf tables
#

#
# Table structure for table 'names'
#
CREATE TABLE names (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  name varchar(64) DEFAULT '' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '8' NOT NULL,
  PRIMARY KEY (name(8),object_id)
);

#
# Table structure for table 'auth'
#
CREATE TABLE auth (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  auth varchar(244) binary DEFAULT '' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id,auth(40))
);

#
# Table structure for table 'auth_override'
#
CREATE TABLE auth_override (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  date int(10) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id)
);

#
# Table structure for table 'ifaddr'
#
CREATE TABLE ifaddr (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  ifaddr int(10) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (object_id,ifaddr)
);

#
# Table structure for table 'rev_srv'
#
CREATE TABLE rev_srv (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  rev_srv varchar(244) DEFAULT '' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (rev_srv(40),object_id)
);

#
# Table structure for table 'refer'
#
CREATE TABLE refer (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  port int(5) unsigned DEFAULT '43' NOT NULL,
  host varchar(80) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id,host(40),port,type)
);

#
# Table structure for table 'nserver'
#
CREATE TABLE nserver (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  host varchar(244) DEFAULT '' NOT NULL,
  PRIMARY KEY (host(40),object_id)
);

#
# Table structure for table 'sub_dom'
#
CREATE TABLE sub_dom (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  domain varchar(244) DEFAULT '' NOT NULL,
  PRIMARY KEY (domain(8),object_id)
);

#
# Table structure for table 'e_mail'
#
CREATE TABLE e_mail (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  e_mail varchar(80) DEFAULT '' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (e_mail(40),object_id)
);

#
# Table structure for table 'notify'
#
CREATE TABLE notify (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  notify varchar(80) DEFAULT '' NOT NULL,
  object_type tinyint(3) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (notify(40),object_id)
);

#
# Table structure for table 'mnt_nfy'
#
CREATE TABLE mnt_nfy (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  mnt_nfy varchar(128) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id,mnt_nfy(40))
);

#
# Table structure for table 'upd_to'
#
CREATE TABLE upd_to (
  thread_id int(11) DEFAULT '0' NOT NULL,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  upd_to varchar(128) DEFAULT '' NOT NULL,
  PRIMARY KEY (object_id,upd_to(40))
);

#
# Serials table
#

CREATE TABLE serials (
  serial_id int(11) DEFAULT '0' NOT NULL auto_increment,
  object_id int(10) unsigned DEFAULT '0' NOT NULL,
  sequence_id int(10) unsigned DEFAULT '0' NOT NULL,
  atlast tinyint(4) unsigned DEFAULT '0' NOT NULL,
  operation tinyint(4) unsigned DEFAULT '0' NOT NULL,
  PRIMARY KEY (serial_id)
);

ALTER TABLE serials ADD INDEX object (object_id, sequence_id);
INSERT mntner SET object_id=0, mntner='ANY', dummy=1;