/***************************************
  $Revision: 1.1 $

  Mirror module (mi).

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : access_control.c
  Author              : ottrey@ripe.net
  OSs Tested          : Solaris
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <sys/timeb.h>
#include <glib.h>
#include "thread.h"

/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

#define SLEEP_TIME 10

static producer_run(void) {
  FILE *f1, *f2;
  GString *current_serial;
  int serial_curr=0;
  int serial_prev=0;
  int i, j;
  char line[STR_XL];

  printf("Producer thread started.\n");

  current_serial = g_string_sized_new(STR_L);

  for (i=0; i< 300; i++) {
    sleep(SLEEP_TIME);

    serial_prev = serial_curr;

    f1 = fopen("/ncc/db2/serials/current/RIPE.CURRENTSERIAL", "r");
    fscanf(f1, "%d", &serial_curr);
    fclose(f1);

    if (serial_prev != 0) {
      for (j=serial_prev; j < serial_curr; j++) { 
        printf("[%d][%d]\n", i, j);
        g_string_sprintf(current_serial, "/ncc/db2/serials/current/RIPE.%d", j);
        f2 = fopen((char *)current_serial->str, "r");
        while (fgets(line, STR_XL, f2) != NULL) {
          printf("%s", line);
        }
        fclose(f2);
      }
    }
  }
  
  g_string_free(current_serial, TRUE);

  pthread_exit((void *)0);
} /* producer_run() */

/* MI_init() */
/*++++++++++++++++++++++++++++++++++++++
  Initialize the mirroring.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
void MI_init() {
  pthread_t tid;
  pthread_attr_t attr;

  printf("Initialising mirroring.\n");

  pthread_attr_init(&attr);     /* initialize attr with default attributes */
  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
  pthread_create(&tid, &attr, (void *(*)(void *))producer_run, NULL); 
} /* MI_init() */

int main(void) {
  MI_init();
  sleep(1000);
  return 0;
}
