#ifndef READ_WHICH_KEYTYPES
#define READ_WHICH_KEYTYPES

/***************************************
  $Revision: 1.7 $

  Which Keytypes module (wk)

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include "bitmask.h"

/*+ Enumeration of which keytypes: +*/
typedef enum WK_Type_t {
  WK_NAME=0,         /*+ A name                              +*/
  WK_NICHDL,         /*+ NICHDL                              +*/
  WK_EMAIL,          /*+ RFC822 e-mail address               +*/
  WK_MAINT,          /*+ Maintainer name                     +*/
  WK_KEYCERT,        /*+ PGPKEY (see i-d for syntax)         +*/
  WK_IPRANGE,        /*+ IP range (*) needs modification     +*/
  WK_IP6RANGE,       /*+ IPv6 range (*) needs modification   +*/
  WK_NETNAME,        /*+ Network name                        +*/
  WK_ASNUM,          /*+ AS number                           +*/
  WK_ASSETNAME,      /*+ AS set name                         +*/
  WK_ROUTESETNAME,   /*+ Route set name                      +*/
  WK_DOMNAME,        /*+ Domain name                         +*/
  WK_HOSTNAME,       /*+ Host name                           +*/
  WK_LIMERICKNAME,   /*+ Limerick name                       +*/
  WK_END
} WK_Type;

#define WK_SEARCH_MASK_SQ  WK_NAME,          \
                           WK_NICHDL,        \
                           WK_EMAIL,         \
                           WK_MAINT,         \
                           WK_KEYCERT,       \
                           WK_NETNAME,       \
                           WK_ASNUM,         \
                           WK_ASSETNAME,     \
                           WK_ROUTESETNAME,  \
                           WK_DOMNAME,       \
                           WK_HOSTNAME,      \
                           WK_LIMERICKNAME,  \
                           MA_END
                                             
#define WK_SEARCH_MASK_RX  WK_IPRANGE,       \
                           WK_IP6RANGE,      \
                           MA_END

int WK_is_name(char *key);
int WK_is_nichdl(char *key);
int WK_is_email(char *key);
int WK_is_maint(char *key);
int WK_is_pgpkey(char *key);
int WK_is_iprange(char *key);
int WK_is_ip6range(char *key);
int WK_is_netname(char *key);
int WK_is_asnum(char *key);
int WK_is_assetname(char *key);
int WK_is_routesetname(char *key);
int WK_is_domname(char *key);
int WK_is_hostname(char *key);
int WK_is_limerickname(char *key);
char *WK_to_string(mask_t wk);
mask_t WK_new(char *key);

#endif /* READ_WHICH_KEYTYPES */
