#ifndef READ_QUERY_INSTRUCTIONS
#define READ_QUERY_INSTRUCTIONS

/***************************************
  $Revision: 1.11 $

  Query instruction module (qi)
  config module.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include "mysql_driver.h"
#include "query_command.h"

#define MAX_INSTRUCTIONS 100

/* SQL queries for the RIPE database */
#define Q_PRI_NAME          "SELECT N00.pe_ro_id FROM %s              WHERE  %s              "                    /* whois NAME            */
#define Q_INV_NAME          "SELECT %s.object_id FROM %s, %%s         WHERE  %s.pe_ro_id = N00.pe_ro_id AND %%s"  /* whois -iac,tc,zc NAME */
                            
#define Q_PRI_NICHDL        "SELECT pe_ro_id     FROM person_role     WHERE person_role.nic_hdl = '%s'"                                          /* whois NICHDL            */
#define Q_INV_NICHDL        "SELECT %s.object_id FROM person_role, %s WHERE person_role.nic_hdl = '%s' AND person_role.pe_ro_id = %s.pe_ro_id"   /* whois -iac,tc,zc NICHDL */
                            
#define Q_PRI_EMAIL         "SELECT object_id    FROM e_mail          WHERE e_mail     = '%s'"  /* whois EMAIL      */
#define Q_INV_EMAIL         "SELECT object_id    FROM notify          WHERE notify     = '%s'"  /* whois -iny EMAIL */
                            
#define Q_PRI_MAINT         "SELECT mnt_id       FROM mntner          WHERE mntner     = '%s'"  /* whois MAINT      */
#define Q_INV_MAINT         "SELECT object_id    FROM mnt_by          WHERE mntner     = '%s'"  /* whois -imb MAINT */
                            
#define Q_PRI_KEYCERT       "SELECT key_cert_id  FROM key_cert        WHERE key_cert   = '%s'"  /* whois KEYCERT */
#define Q_INV_KEYCERT       NULL

#define Q_PRI_IPRANGE       "SELECT in_id        FROM inetnum         WHERE inetnum    = '%s'"  /* whois IPRANGE */
#define Q_INV_IPRANGE       NULL

#define Q_PRI_IP6RANGE      "SELECT i6_id        FROM inet6num        WHERE inetnum    = '%s'"  /* whois IP6RANGE */
#define Q_INV_IP6RANGE      NULL
                            
#define Q_PRI_NETNAME       "SELECT in_id        FROM inetnum         WHERE netname    = '%s'"  /* whois NETNAME */
#define Q_INV_NETNAME       NULL
                            
#define Q_PRI_ASNUM         "SELECT an_id        FROM aut_num         WHERE aut_num    = '%s'"  /* whois ASNUM */
#define Q_INV_ASNUM         "SELECT rt_id        FROM route           WHERE origin     = '%s'"  /* whois -ior ASNUM */

#define Q_PRI_ASSETNAME     "SELECT as_id        FROM as_set          WHERE as_set     = '%s'"  /* whois ASSETNAME */
#define Q_INV_ASSETNAME     NULL

#define Q_PRI_ROUTESETNAME  "SELECT rs_id        FROM route_set       WHERE route_set  = '%s'"  /* whois ROUTESETNAME */
#define Q_INV_ROUTESETNAME  NULL

#define Q_PRI_DOMNAME       "SELECT dn_id        FROM domain          WHERE domain     = '%s'"  /* whois DOMNAME */
#define Q_INV_DOMNAME       "SELECT dn_id        FROM dn_sub_dom      WHERE domain     = '%s'"  /* whois -isd DOMNAME */

#define Q_PRI_HOSTNAME      NULL                                                                /* whois HOSTNAME */
#define Q_INV_HOSTNAME      NULL

#define Q_PRI_LIMERICKNAME  "SELECT li_id        FROM limerick        WHERE limerick   = '%s'"  /* whois LIMERICKNAME */
#define Q_INV_LIMERICKNAME  NULL


#define Q_OBJECTS     "SELECT last.serial, last.prev_serial, last.object FROM last, %s WHERE last.serial=%s.id GROUP BY last.serial"

#define Q_REC         "INSERT INTO %s_R SELECT pe_ro_id FROM %s, %s WHERE object_id = %s.id"

/* XXX This takes too long.  :-(
#define Q_REC_OBJECTS "SELECT last.serial, last.prev_serial, last.object FROM last, %s, %s_R WHERE last.serial=%s_R.id AND %s.id != %s_R.id GROUP BY last.serial"

--- snipped from http://www.tcx.se/Manual/manual.html ---

5.3 Functionality missing from MySQL

The following functionality is missing in the current version of MySQL. For a prioritized list indicating when new extensions may be added to MySQL, you should consult the
online MySQL TODO list. That is the latest version of the TODO list in this manual. See section F List of things we want to add to MySQL in the future (The TODO). 

5.3.1 Sub-selects

The following will not yet work in MySQL: 

SELECT * FROM table1 WHERE id IN (SELECT id FROM table2);
SELECT * FROM table1 WHERE id NOT IN (SELECT id FROM table2);

However, in many cases you can rewrite the query without a sub select: 

SELECT table1.* FROM table1,table2 WHERE table1.id=table2.id;
SELECT table1.* FROM table1 LEFT JOIN table2 ON table1.id=table2.id where table2.id IS NULL

For more complicated sub queries you can create temporary tables to hold the sub query. 

MySQL only supports INSERT ... SELECT ... and REPLACE ... SELECT ... Independent sub-selects will be probably be available in 3.24.0. You can now use the function IN() in other
contexts, however. 

--- end snip ---

Ie. Try using a LEFT JOIN to do the "NOT IN"/ "MINUS" equivalent.

*/
#define Q_REC_OBJECTS "SELECT last.serial, last.prev_serial, last.object FROM last, %s_R WHERE last.serial=%s_R.id GROUP BY last.serial"

#define Q_NO_OBJECTS  "SELECT serial, prev_serial, object FROM last WHERE serial = 0"


typedef enum QI_Type_t {
  QI_SQL=0,
  QI_RADIX,
  QI_RADIX_IN,
  QI_RADIX_RT,
  QI_END
} QI_Type;


typedef struct Query_instruction_t {
  QI_Type search_type;
  char *query_str;
  char *rx_keys;
  unsigned int rx_srch_mode;
  unsigned int rx_par_a;
} Query_instruction;

typedef struct Query_instructions_t {
  Query_instruction *instruction[MAX_INSTRUCTIONS];
  unsigned int sock;
  unsigned int recursive;
} Query_instructions;


void QI_execute(void *database_voidptr, void *qis_voidptr);
void QI_free(Query_instructions *qis);
Query_instructions *QI_new(const Query_command *qc, unsigned int sock);

#endif /* READ_QUERY_INSTRUCTIONS */
