#ifndef READ_QUERY_COMMAND
#define READ_QUERY_COMMAND

/***************************************
  $Revision: 1.7 $

  Query command module (qi)

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#define USAGE  "Usage: whois [-aFLmMrSvR] [-h hostname] [-s sources] [-T types] [-i attr] keys\n" \
"whois -t type       whois -v type\n" \
"\n"\
"Where:\n"\
"\n"\
"-a                         search all databases\n"\
"-F                         fast raw output\n"\
"-h hostname                search alternate server\n"\
"-i [attr][[,attr] ... ]    do an inverse lookup for specified attributes\n"\
"-l                         ???\n"\
"-L                         find all Less specific matches\n"\
"-m                         find first level more specific matches\n"\
"-M                         find all More specific matches\n"\
"-r                         turn off recursive lookups\n"\
"-s source[[,source] ... ]  search databases with source 'source'\n"\
"-S                         tell server to leave out 'syntactic sugar'\n"\
"-t type                    requests template for object of type 'type'\n"\
"-v type                    requests verbose template for object of type 'type'\n"\
"-R                         force to show local copy of the domain object even if it contains referral\n"\
"-T type[[,type] ... ]      only look for objects of type 'type'\n"\
"\n"\
"Please note that most of these flags are NOT understood by\n"\
"non RIPE whois servers\n\n"

#include <glib.h>
#include "bitmask.h"

typedef struct Query_command_t {
  unsigned int a;
  unsigned int g;
  mask_t inv_attrs_bitmap;
  unsigned int k;
  unsigned int recursive;
  unsigned int l;
  unsigned int m;
  GList *sources_list;
  unsigned int t;
  unsigned int v;
  unsigned int F;
  unsigned int L;
  unsigned int M;
  unsigned int R;
  unsigned int S;
  mask_t object_type_bitmap;
  unsigned int V;
  mask_t keytypes_bitmap;
  char *keys;
} Query_command;

char *QC_bitmap_to_string(mask_t bitmap);
char *QC_query_command_to_string(Query_command *query_command);
void QC_free(Query_command *qc);
Query_command *QC_new(char *query_str, int sock);
Query_command *QC_environ_update(Query_command *qc, Query_command *qe);

#endif /* READ_QUERY_COMMAND */
