/***************************************
  $Revision: 1.11 $

  Protocol whois module (pw).  Whois protocol.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : protocol_whois.c
  Author              : ottrey@ripe.net
  OSs Tested          : Solaris
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdio.h>
#include <glib.h>

#include "NAME"

#include "protocol_whois.h"
#include "mysql_driver.h"
#include "query_command.h"
#include "query_instructions.h"
#include "constants.h"
#include "objects.h"

/* PW_interact() */
/*++++++++++++++++++++++++++++++++++++++
  Interact with the client.

  int sock Socket that client is connected to.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
void PW_interact(int sock) {
  char input[MAX_INPUT_SIZE];
  int connected = 1;
  int read_result;
  char *welcome=NULL;
  int input_length;
  int k_flag;
  char *str=NULL;

  Query_command *qc=NULL;
  Query_instructions *qis=NULL;

  /* Initialize the flag that instructs to keep the connection open. */
  k_flag = 0;

  while ((connected == 1) && (CO_get_whois_suspended() == 0)) {
    /* Read input */
    read_result = SK_gets(sock, input, MAX_INPUT_SIZE);
    if (read_result == -1) {
      connected = 0;
    }
    else if (read_result == -2) {
      printf("Thread received a control-c\n");
      connected = 0;
    }

    /* Default to process the whois query */
    input_length = strlen(input);
    if (input_length > 0) {
      SK_puts(sock, CVS_NAME);
      printf("whois %s\n", input);
      /* XXX NB. This will change as the WQ module changes.  -- Sigh. */
      QC_free(qc);
      qc = QC_new(input, sock);
      /*
      QC_environ_update(qc);
      */

      /* Don't do a query if there are no keys. */
      if (qc->keys != NULL) {
        if (strcmp(qc->keys, "") != 0) {
          QI_free(qis);
          qis = QI_new(qc, sock);
          g_list_foreach(qc->sources_list, QI_execute, qis);
        }
        else {
          if (qc->t != 0) {
            str = OB_attribute_i_to_string(qc->t, 0);
            if (str != NULL) {
              SK_puts(sock, str);
              SK_puts(sock, "\n");
              free(str);
            }
            else {
              SK_puts(sock, "Not an object.\n");
              SK_puts(sock, USAGE);
            }
          }
          if (qc->v != 0) {
            str = OB_attribute_i_to_string(qc->v, 1);
            if (str != NULL) {
              SK_puts(sock, str);
              free(str);
            }
            else {
              SK_puts(sock, "Not an object.\n");
              SK_puts(sock, USAGE);
            }
          }
        }
      }

      /* Put a newline at the end of the query. */
      SK_puts(sock, "\n");

      /* This is a tricky XOR operation....  ;-)
         State transition for k_flag:
         0 -> 0 then k_flag = 0, connected = 0
         0 -> 1 then k_flag = 1, connected = 1
         1 -> 0 then k_flag = 1, connected = 1
         1 -> 1 then k_flag = 0, connected = 0
      */
      k_flag = k_flag ^ qc->k; 
      connected = k_flag;
    }
    else {
      printf("whois WHAT???\n");
      SK_puts(sock, "whois WHAT???\n");
      connected = 0;
    }
  }

  SK_close(sock);


} /* PW_interact() */
