/***************************************
  $Revision: 1.7 $

  Attributes module (at) - this _should_ eventually get merged in with the
  config module.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Filename            : attributes.c
  Author              : ottrey@ripe.net
  OSs Tested          : Solaris
  Related Modules     : Used in conjunction with the objects module.
  Problems            : Keeping consistency between arrays and enums.
  To Do               : Total re-design.
  Comments            :
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <stdlib.h>
#include "attributes.h"

/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383

/*+ Attributes (short name & long name) +*/
char * const Attributes[] = {
  "ac", "admin-c",
  "aa", "as-name",
  "ad", "address",
  "ag", "aggr-mtd",
  "ab", "aggr-bndry",
  "ah", "author",
  "an", "aut-num",
  "as", "as-set",
  "at", "auth",
  "az", "alias",
  "ce", "certif",
  "ch", "changed",
  "cy", "country",
  "cn", "cross-nfy",
  "co", "components",
  "ct", "cross-mnt",
  "da", "dom-name",
  "de", "descr",
  "df", "default",
  "dc", "dictionary",
  "di", "dom-net",
  "dn", "domain",
  "dt", "upd-to",
  "ec", "export-comps",
  "en", "encapsulation",
  "em", "e-mail",
  "ex", "export",
  "fi", "filter",
  "fp", "fingerpr",
  "fs", "filter-set",
  "fx", "fax-no",
  "ho", "holes",
  "if", "ifaddr",
  "ij", "inject",
  "in", "inetnum",
  "i6", "inet6num",
  "ip", "import",
  "ir", "inet-rtr",
  "is", "rtr-set",
  "kc", "key-cert",
  "la", "local-as",
  "li", "limerick",
  "mh", "method",
  "mb", "mnt-by",
  "ml", "mnt-lower",
  "mo", "member-of",
  "mr", "mbrs-by-ref",
  "ms", "members",
  "mt", "mntner",
  "mn", "mnt-nfy",
  "na", "netname",
  "nh", "nic-hdl",
  "ns", "nserver",
  "ny", "notify",
  "or", "origin",
  "ow", "owner",
  "pe", "peer",
  "pg", "peering",
  "ph", "phone",
  "pl", "protocol",
  "pn", "person",
  "ps", "peering-set",
  "rf", "refer",
  "rm", "remarks",
  "ro", "role",
  "rp", "rp-attribute",
  "rs", "route-set",
  "rt", "route",
  "rz", "rev-srv",
  "sd", "sub-dom",
  "so", "source",
  "st", "status",
  "tb", "trouble",
  "td", "typedef",
  "tc", "tech-c",
  "tx", "text",
  "wd", "withdrawn",
  "zc", "zone-c",
  NULL, NULL
}; /* Attributes */

/*+ Attribute Details - Ie descriptions +*/
const char *Attributes_details[][2] = {
  /* ac */  { "An on-site contact (person)", "<NIC-handle>" },
  /* aa */  { "A descriptive name associated with an AS.", "Uppercase letters, dashes (\"-\") and digits, no spaces.\n\tMust start with a letter." },
  /* ad */  { "Full postal address of a person.", "Free Text." },
  /* ag */  { "aggr-mtd", "INSERT aggr-mtd desc here." },
  /* ab */  { "aggr-bndry", "INSERT aggr-bndry desc here." },
  /* ah */  { "Limerick author.", "<NIC-handle>" },
  /* an */  { "The autonomous system number.  This must be a uniquely\n\tallocated autonomous system number from an AS registry\n\t(e.g.RIPE NCC, the Inter-NIC, etc).", "\"AS\"<positive integer between 1 and 65535>" },
  /* as */  { "as-set", "INSERT as-set desc here." },
  /* at */  { "The formal authority for a community. This could be\n\tan organisation, institute, committee, etc.", "Free text (alphanumeric characters, \".\", \"-\", \"\\\")." },
  /* az */  { "alias", "INSERT alias desc here." },
  /* ce */  { "certif", "INSERT certif desc here." },
  /* ch */  { "Who previously changed this object\n\tand when this change was made.", "<RFC822 e-mail address> <DATE>\n\tE-mail address of person updating the object.\n\tDATE in YYYYMMDD or YYMMDD format." },
  /* cy */  { "ATB country DESC Name of the country of the admin-c.", "ATB country FRMT 2 letter uppercase ISO 3166 country code." },
  /* cn */  { "cross-nfy", "INSERT cross-nfy desc here." },
  /* co */  { "components", "INSERT components desc here." },
  /* ct */  { "cross-mnt", "INSERT cross-mnt desc here." },
  /* da */  { "dom-name", "INSERT dom-name desc here." },
  /* de */  { "A short decription of this object.", "All characters possible." },
  /* df */  { "default", "INSERT default desc here." },
  /* dc */  { "dictionary", "INSERT dictionary desc here." },
  /* di */  { "List of IP networks in a domain.", "Dotted quad including trailing 0's." },
  /* dn */  { "IP domain name.", "Full qualified domain name without trailing \".\"." },
  /* dt */  { "The e-mail address to be notified when an object\n\tATB upd-to DESC protected by a mntner is unsuccessfully updated.", "ATB upd-to FRMT RFC-822 address" },
  /* ec */  { "export-comps", "INSERT export-comps desc here." },
  /* en */  { "encapsulation", "INSERT encapsulation desc here." },
  /* em */  { "The e-mail address of a person or role.", "RFC-822 address." },
  /* ex */  { "export", "INSERT export desc here." },
  /* fi */  { "filter", "INSERT filter desc here." },
  /* fp */  { "fingerpr", "INSERT fingerpr desc here." },
  /* fs */  { "filter-set", "INSERT filter-set desc here." },
  /* fx */  { "The fax number of a person or role", "+ <Country Code> <Area Code> <Fax Number>" },
  /* ho */  { "holes", " INSERT holes desc here." },
  /* if */  { "An interface address within an internet router.", "<Interface Address> <Interface Subnet Mask>" },
  /* ij */  { "inject", "INSERT inject desc here." },
  /* in */  { "A range of IP address space.", "x.x.x.x - x.x.x.x, where 0 =< x =< 255" },
  /* i6 */  { "Full IP version 6 address.", "<ip6num>/<prefix length>" },
  /* ip */  { "import", "INSERT import desc here." },
  /* ir */  { "Fully qualified domain name of an internet router.", "Fully qualified domain name without trailing \".\"" },
  /* is */  { "rtr-set", "INSERT rtr-set desc here." },
  /* kc */  { "key-cert", "INSERT key-cert desc here." },
  /* la */  { "The autonomous system in which a router belongs.", "AS<positive integer between 1 and 65535>." },
  /* li */  { "Title of a limerick.", "LIM-<string>, where string can include\n\talphanumeric characters, \"-\" character." },
  /* mh */  { "method", "INSERT method desc here." },
  /* mb */  { "The identifier of a registered mntner object used for\n\tauthorization and authentication.", "<mntner>" },
  /* ml */  { "The identifier of a registered mntner object used for\n\thierarchical authorization and authentication.", "<mntner>" },
  /* mo */  { "member-of", " INSERT member-of desc here." },
  /* mr */  { "mbrs-by-ref", "INSERT mbrs-by-ref desc here." },
  /* ms */  { "members", "INSERT members desc here." },
  /* mt */  { "The name of a mntner object.  Must be an unique mntner\n\tname, but can be identical to AS names, nic-handles.", "<uppercase letter><uppercase alphanumeric, \"-\">" },
  /* mn */  { "The e-mail address to be notified when an object\n\tprotected by a mntner is successfully updated.", "RFC-822 address." },
  /* na */  { "The name of a range of IP address space.", "<uppercase letter><uppercase alphanumeric, \"-\">" },
  /* nh */  { "The NIC handle of a role or person object.n\tThis can be a RIPE NIC-handle or a NIC-handle\n\tassigned by other regional registries.", "RIPE NIC-handle: <Initials><0-999>-RIPE" },
  /* ns */  { "List of nameservers for a domain object; a minimum\n\tof two is mandatory .", "<Fully qualified domain name(s) without trailing \".\">\n\tOR <IP Address(es) of the nameserver(s)>" },
  /* ny */  { "The e-mail address to which notifications of changes to\n\tan object should be sent.", "<RFC-822 address>" },
  /* or */  { "origin", "INSERT origin desc here." },
  /* ow */  { "owner", "INSERT owner desc here." },
  /* pe */  { "Details of any (interior or exterior) router peerings.", "<Peer address> <Peer AS> <Routing Protocol> [Local AS]\n\t[Local AS] is optional." },
  /* pg */  { "peering", "INSERT peering desc here." },
  /* ph */  { "Telephone number", "+ <Country Code><Area Code><Phone Number>\n\t+ <Country Code><Area Code><Phone Number> ext. <number>\n\tOptional: spaces may be used to split up the phone number\n\tinto its constituent components. \".\" characters can also\n\tbe used between to separate the digits." },
  /* pl */  { "protocol", "INSERT protocol desc here." },
  /* pn */  { "The full name of an adminstrative, technical or zone\n\tcontact person specified in another object.\n\tDo not use titles such as\"Dr.\", \"Prof.\", \"Mv.\",\n\t\"Ms.\", \"Mr.\", etc.", "<Personal Name> <Family Name> where each name is\n\tcomposed of alphabetic characters." },
  /* ps */  { "peering-set", "INSERT peering-set desc here." },
  /* rf */  { "Whois referral for domain objects", "<Type> <host> <port>\n\t<Type> is one of RIPE, Internic or SIMPLE. Specifies whois\n\tquery style.\n\t<host> specifies the host to be queried.\n\t<port> the TCP port number (optional: 43 is the default)" },
  /* rm */  { "General remarks. Can include an URL or RFC822\n\taddress (if preceeded by mailto:).", "<free text>" },
  /* ro */  { "The full name of a role entity e.g. RIPE DBM.", "Two components, each consisting of alphabetic\n\tcharacters. Note: there is no \"-\" character\n\tbetween the two components of the the name." },
  /* rp */  { "rp-attribute", "INSERT rp-attribute desc here." },
  /* rs */  { "route-set", "INSERT route-set desc here." },
  /* rt */  { "route", "INSERT route desc here." },
  /* rz */  { "Domain name server for a range of IP addresses.", "Fully qualified name without trailing \".\"" },
  /* sd */  { "List of the sub-domains of a domain", "<Relative domain name to the domain>" },
  /* so */  { "Identifier of the database containing\n\tauthoritative data for this object.\n\tUse RIPE for objects in the RIPE Database.", "Uppercase Text." },
  /* st */  { "status", "INSERT status desc here." },
  /* tb */  { "Information on who to contact when there are problems.", "<Free text>" },
  /* td */  { "typedef", "INSERT typedef desc here." },
  /* tc */  { "A technical contact.", "<NIC-handle>" },
  /* tx */  { "Must be humourous, but not malicious\n\tor insulting. :-)", "Free Text." },
  /* wd */  { "withdrawn", "INSERT withdrawn desc here." },
  /* zc */  { "NIC-handle of the person with authority over a zone.", "<NIC-handle>" },
            { NULL    , NULL }
}; /* Attributes_details */

/*+ Source database mirrors +*/
char * const  Sources[] = {
  "RIPE",
  "RIPE2",
  "ARIN",
  "APNIC",
  NULL
}; /* Sources */


/* AT_get_sources() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the sources as a list of strings.  Used when validating query options.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char * const *AT_get_sources(void) {

  return Sources;

} /* AT_get_sources() */

/* AT_get_source() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the indexed source.

  int index The index of the source in the Sources list.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
const char *AT_get_source(int index) {

  return Sources[index];

} /* AT_get_source() */

/* source_foreach() */
/*++++++++++++++++++++++++++++++++++++++
  Function to adds the source string to the created string from the Glist of sources.
  It is called via g_list_foreach().

  void *element_data The source name.

  void *result_buf_ptr The string to be populated.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
static void source_foreach(void *element_data, void *result_buf_ptr) {
  char *source = element_data;
  char *result_buf = (char *)result_buf_ptr;

  strcat(result_buf, element_data);
  strcat(result_buf, ",");

} /* source_foreach() */

/* AT_sources_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Creates a string from Sources.

  char * AT_sources_to_string Returns a string of the Sources.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char * AT_sources_to_string(void) {
  char *result=NULL;
  char result_buf[STR_XL];
  int result_len;
  int i;

  strcpy(result_buf, "{");
  for (i=0; Sources[i] != NULL; i++) {
    strcat(result_buf, Sources[i]);
    strcat(result_buf, ",");
  }
  result_len = strlen(result_buf);
  result_buf[result_len-1] = '}';
  result_buf[result_len] = '\0';

  result = (char *)calloc(1, result_len+1);
  strcpy(result, result_buf);

  return result;

} /* AT_sources_to_string() */

/* AT_sources_list_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Creates a string from the sources in the GList.

  GList *sources_list  The GList of sources.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char * AT_sources_list_to_string(GList *sources_list) {
  char *result=NULL;
  char result_buf[STR_XL];
  int result_len;

  strcpy(result_buf, "{");
  g_list_foreach(sources_list, source_foreach, &result_buf);
  result_len = strlen(result_buf);
  if (result_len == 1) {
    /* If an empty set */
    result_buf[1] = '}';
    result_buf[2] = '\0';
  }
  else {
    result_buf[result_len-1] = '}';
    result_buf[result_len] = '\0';
  }

  result = (char *)calloc(1, result_len+1);
  strcpy(result, result_buf);

  return result;

} /* AT_sources_list_to_string() */

/* AT_get_attributes() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the attributes as a list of strings.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char * const *AT_get_attributes(void) {

  return Attributes;

} /* AT_get_sources() */

/* AT_get_attribute() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the indexed attribute.  Used when validating query options.

  AT_Type attr_index The index into the Attributes[] array.

  int offset The offset (Ie short or long name).

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
const char *AT_get_attribute(AT_Type attr_index, int offset) {

  return Attributes[attr_index*2+offset];

} /* AT_get_attribute() */

/* AT_get_attribute_desc() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the attribute description.  Used for -t & -v queries.

  AT_Type attr_index The index into the Attributes[] array.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
const char *AT_get_attribute_desc(AT_Type attr_index) {

  return (char *)Attributes_details[attr_index][0];

} /* AT_get_attribute_desc() */

/* AT_get_attribute_frmt() */
/*++++++++++++++++++++++++++++++++++++++
  Returns the attribute format.  Used for -t & -v queries.

  AT_Type attr_index The index into the Attributes[] array.

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
const char *AT_get_attribute_frmt(AT_Type attr_index) {

  return (char *)Attributes_details[attr_index][1];

} /* AT_get_attribute_frmt() */

/* AT_attributes_to_string() */
/*++++++++++++++++++++++++++++++++++++++
  Returns a string of all the attributes.  Only there for debugging and tracing purposes.

  int offset The offset (Ie short or long name).

  More:
  +html+ <PRE>
  Authors:
        ottrey

  +html+ </PRE><DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL></DL>

  ++++++++++++++++++++++++++++++++++++++*/
char *AT_attributes_to_string(int offset) {
  int i;
  char *str;
  char str_buffer[4096];
  int str_len;

  strcpy(str_buffer, "{\"");
  for (i=0; Attributes[i*2+offset] != NULL; i++) {
    strcat(str_buffer, Attributes[i*2+offset]);
    strcat(str_buffer, "\", \"");
  }
  str_len = strlen(str_buffer);
  str_buffer[str_len-3] = '}';
  str_buffer[str_len-2] = '\0';
  str_len--;

  str = (char *)calloc(1, str_len);
  strcpy(str, str_buffer);

  return str;

} /* AT_attributes_to_string() */

