/*
 * pm.h,v 1.1 1994/01/28 17:21:41 franktor Exp
 *
 * pm.h  -  Protocol Machine
 *
 * Copyright (c) 1992 Nordic SR-NETT
 * Geir Pedersen, Geir.Pedersen@usit.uio.no
 *
*/

#include <sr-general.h>
#include <sr-api.h>
#include <sr-low.h>

typedef enum State { sClosed, osInitSent, sOpen, osSearchSent, osPresentSent,
		     osDeleteResultSetSent, osReleaseSent, sAborted, tsInitRcvd,
		     tsSearchRcvd, tsPresentRcvd, tsDeleteResultSetRecvd, tsReleaseRcvd, tsReject } State;

typedef enum Role { isTarget, isOrigin } Role;

typedef struct Association {
   Role			role;
   State	       	state;
   int			lowerLayerRef;
   LowerLayerKind	lowerLayerKind;
   SR_protocolVersion	protocolVersion;
} Association;

char *state2str ( State s );


extern Association 		**associations;
extern int			allocAssociations;


   
