/*
**  HEADER -- Header line parser.
**  Copyright (c) 1985 Lennart Lovstrand
**  CIS Dept, Univ of Linkoping, Sweden
**
**  Use it, abuse it, but don't sell it.
**
**  Version of 14-Apr-85.
*/

#include "sendmail.h"

#define HH_CC		"cc"
#define HH_FROM		"from"
#define HH_MESSAGE_ID	"message_id"
#define HH_RETURN_PATH	"return-path"
#define HH_TO		"to"
#define HH_VIA		"via"

#define COMMA	','

#define MAKELC(C)	(isupper(C) ? tolower(C) : C)

#ifndef lint
static char	Rcsid[] = "@(#)$Id: header.c,v 1.4 1991/07/01 17:28:32 paul Exp $";
#endif /* !lint */

#ifdef __STDC__
int iskey(const char *, const char *);
char * eat(char *, int);
char * extract_address(char *, char *);
#else /* !__STDC__ */
# define	const
int iskey();
char * eat();
char * extract_address();
#endif /* __STDC__ */

/*
 *	iskey: checks if the line is prefixed by
 *	the supplied keyword (immediately followed by
 *	a colon)
 */
iskey(key, line)
	const char *key, *line;
{
	for (; *key != NULL && *line != NULL; key++, line++)
		if (MAKELC(*key) != MAKELC(*line))
			break;

	return *key == NULL && *line == ':';
}

char *
eat(str, ch)
	char *str, ch;
{
	for(; *str == ch; str++);
	return str;
}

/*
 *	extract_address:
 *	finds and extracts the machine address part of an address field
 */

char *
extract_address(field, address)
	char *field, *address;
{
	char *address_start = address;

	while(*field && *field != COMMA && *field != '>')
		switch (*field) {
			case '<':
				return extract_address(field, address_start);
			case '(':
				while (*field && *field != ')');
					field++;
				break;
			case '"':
				do
					*address++ = *field++;
				while (*field && *field != '"');
				if (*field)
					*address++ = *field++;
				break;
			case ' ':
				*address++ = *field++;
				field = eat(field, ' ');
				break;
			case '\\':
				*address++ = *field++;
				/* fall through */
			default:
				*address++ = *field++;
		}
	*address = NULL;
	if (*field)
		return index(field, COMMA)+1;
	else
		return field;
}
