/* gcxch.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#ifndef MULTIP
#define MULTIP
#endif

static int FUNC(data, blksize, result)
     TYPE *data;
     int blksize;
     TYPE *result;
{
  int i;
  int ntotal = blksize;

  for (i=0; i<NUMNODES; i++) { /* Send my block#i to NODE#i */
    if (i != ME) {
      pvm_initsend(INITHOW_node);
      PACK(&data[MULTIP i*blksize],blksize,1);
      pvm_send(NODEID[i], MSG_CXCH);

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(4,i,MSG_CXCH,MULTIP blksize);
      }
#endif
  
    }
  }
  
  if (data != result) { /* Copy local block#ME also if not the same array */
    TYPE *pdata   = &data[MULTIP ME*blksize];
    TYPE *presult = &result[MULTIP ME*blksize];
    for (i=0; i<MULTIP blksize; i++) {
      presult[i] = pdata[i]; 
    }
  }
  
  for (i=1; i<NUMNODES; i++) { /* Recv column#i from NODE#1 */
    int node;
    int bufid = pvm_recv(ANYBODY, MSG_CXCH); /* Recv in any order */

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(7,MSG_CXCH);
    }
#endif
  
    recvinfo(bufid,&node,NULL,NULL);
    UNPACK(&result[MULTIP node*blksize],blksize,1);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,node,MSG_CXCH,MULTIP blksize);
    }
#endif
  
    ntotal += blksize;
  }
  
  return ntotal;
}


#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */





