/*
 * Header file: easydefs.h
 *
 * Used only by the EASYPVM-library. Not for a user.
 *
 */

#ifndef _EASYDEFS_H_
#define _EASYDEFS_H_

#ifndef _ATTACHPROC_
extern MPP_Info AllMPP_Info[];
extern MPP_Info *LocalMPP_Info;
extern int cluster_id[];
extern int active_cluster_id;
extern int not_attached;
extern int easy_cio;
#endif

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int bypassrecv;
extern int waitall_verbose;
extern int getarchcode __ProtoGlarp__((char *arch));  
extern int getdatasize __ProtoGlarp__((void));
extern int nrecv __ProtoGlarp__((int source, int msgtag, void *data, int ndata));
extern int unpackdata __ProtoGlarp__((char *routine, void *data, int ndata));
extern int packdata __ProtoGlarp__((char *routine, void *data, int ndata));
extern void check_printfmsg_arrival __ProtoGlarp__((void));
extern void get_printfmsg __ProtoGlarp__((void));


#ifdef __cplusplus
}
#endif


#define MSG_HOSTDEL   19930001 /* Msg when host is deleted */
#define MSG_HOSTADD   19930002 /* Msg when host is added */

#define MSG_STARTUP   19932000 /* Msgtag when host sends init-info to nodes */
#define MSG_SHUTDOWN  19933000 /* Msgtag when a node exits */
#define MSG_PANICSTOP 19933001 /* Msgtag when a node exits via (specific) signal */

#define MSG_SYNC      19934000 /* gsync() msgtag */
#define MSG_SUM       19934100 /* gsum() msgtag */
#define MSG_PROD      19934200 /* gprod() msgtag */
#define MSG_MIN       19934300 /* gmin() msgtag */
#define MSG_MAX       19934400 /* gmax() msgtag */
#define MSG_COL       19934500 /* gcol() msgtag */
#define MSG_COLX      19934600 /* gcolx() msgtag */
#define MSG_CXCH      19934700 /* gcxch() msgtag */

#define MSG_PRINTF    19936000 /* xprintf()/xfprintf() msgtag */

#define   CLUSTERID LocalMPP_Info->myclusterid

#define   PID       LocalMPP_Info->mypid

#define   HOSTID    LocalMPP_Info->hostid
#define   NUMNODES  LocalMPP_Info->nnodes
#define   NODEID    LocalMPP_Info->nodeid
#define   BCASTNODEID  LocalMPP_Info->bcast_nodeid
#define   ME        LocalMPP_Info->me

#define   INITHOW_host   LocalMPP_Info->inithow_host
#define   INITHOW_node   LocalMPP_Info->inithow_node

#define   X         LocalMPP_Info->mesh.my_x
#define   Y         LocalMPP_Info->mesh.my_y
#define   Z         LocalMPP_Info->mesh.my_z

#define   SOUTH  LocalMPP_Info->mesh.South
#define   WEST   LocalMPP_Info->mesh.West
#define   NORTH  LocalMPP_Info->mesh.North
#define   EAST   LocalMPP_Info->mesh.East
#define   UP     LocalMPP_Info->mesh.Up
#define   DOWN   LocalMPP_Info->mesh.Down

#define   NX   LocalMPP_Info->mesh.nx
#define   NY   LocalMPP_Info->mesh.ny
#define   NZ   LocalMPP_Info->mesh.nz

#define   DATATYPE  LocalMPP_Info->datatype
#define   STRIDE    LocalMPP_Info->stride

#define   PICLTRACE LocalMPP_Info->picltrace
#define   HOST_TIMESTAMP LocalMPP_Info->host_timestamp

#define   MESH3D    LocalMPP_Info->mesh

#ifdef PICL
#include "picl.h"
#endif /* PICL */

#endif /* _EASYDEFS_H_ */
