
      SUBROUTINE FVEC (V, FV, DV)  
C     ---------------------------

      INTEGER VSIZE
      COMMON /VECLEN/ VSIZE

      DOUBLE PRECISION   V(VSIZE), FV(VSIZE), DV(VSIZE)

C     ----------------------------------------------------------
C     |  Performs the [matrix] * {fermion.vector} product :    |
C     |                                                        |
C     |              {Fv} = [F] {v}                            |
C     |                   = ( -[D][D] + m.sq ) {v}             |
C     |                                                        |
C     |  where {v} and {Fv} are defined on EVEN sites.         |
C     ----------------------------------------------------------

      INTEGER     TDIR,  XDIR,  YDIR,  ZDIR,  EVEN,  ODD,
     *            PSENSE,  NSENSE,  PLUS,  MINUS,  RE,  IM
      PARAMETER ( TDIR = 1,    XDIR = 2,    YDIR = 3,    ZDIR = 4,
     *            EVEN = 0,     ODD = 1, PSENSE= 0, NSENSE= 1,
     *            PLUS = 0,   MINUS = 1,      RE = 1,      IM = 2 )
      INTEGER  NSWEEP
      DOUBLE PRECISION     H,  HALFH,  MQUARK,  MSQ 
      COMMON / PARAMS / H,  HALFH,  MQUARK,  MSQ,  NSWEEP


      CALL DVEC   ( PLUS, EVEN, V,  DV )
      CALL DVEC   ( MINUS, ODD, DV, FV )
      CALL ADDSCV ( FV,  FV, MSQ, V )
      END
