C     *****************
      SUBROUTINE PRFILE(
C     *****************
     >                   NV,NW1,ISU3R,
     >                   ITEMAX,METHIT)
C
C
      COMMON / PERF / RTIME(15),IPRO
C
      DOUBLE PRECISION     RTIME,
     >                     ZERO,
     >                     PFM,MFLOP,
     >                     FGP,FGP1,FGP2,
     >                     TIME
C
C
      PARAMETER( IVARM = 7       )
      PARAMETER( FGP1  = 9.936D3 )
      PARAMETER( FGP2  = 1.772D3 )
      PARAMETER( MFLOP = 1.D-6   )
      PARAMETER( ZERO  = 0.D0    )
C
C
C     -----------------------------------------------------------
C
C
C     TIME OF THE PURE LINK UPDATE (EXCLUDING MEASUREMENT ROUTINES)
C
C
      TIME  = RTIME(1) - RTIME(7)
C
C
      IF( IPRO .GE. 1 ) THEN
C
          RTIME( 8) = ( RTIME( 8) / RTIME(3) ) * 1.D2
          RTIME( 9) = ( RTIME( 9) / RTIME(4) ) * 1.D2
          RTIME(10) = ( RTIME(10) / RTIME(4) ) * 1.D2
          RTIME(11) = ( RTIME(11) / RTIME(4) ) * 1.D2
          RTIME(12) = ( RTIME(12) / RTIME(4) ) * 1.D2
          RTIME(13) = ( RTIME(13) / RTIME(4) ) * 1.D2
          RTIME(14) = ( RTIME(14) / RTIME(4) ) * 1.D2
          RTIME(15) = ( RTIME(15) / RTIME(4) ) * 1.D2
C
          DO 60 I = 2,IVARM
          RTIME(I) = ( RTIME(I) / RTIME(1) ) * 1.D2
   60     CONTINUE
C
C
C         PRINT RESULTS
C
C
C         LEVEL 1:
C
C
                                   WRITE(NW1,1000)
          IF( RTIME(1) .NE. 0.D0 ) WRITE(NW1,1010) RTIME( 1)
          IF( RTIME(2) .NE. 0.D0 ) WRITE(NW1,1020) RTIME( 2)
          IF( RTIME(3) .NE. 0.D0 ) WRITE(NW1,1030) RTIME( 3)
          IF( RTIME(4) .NE. 0.D0 ) WRITE(NW1,1040) RTIME( 4)
          IF( RTIME(5) .NE. 0.D0 ) WRITE(NW1,1050) RTIME( 5)
          IF( RTIME(6) .NE. 0.D0 ) WRITE(NW1,1060) RTIME( 6)
          IF( RTIME(7) .NE. 0.D0 ) WRITE(NW1,1070) RTIME( 7)
C
C
C         LEVEL 2:
          IF(IPRO .GE. 2) THEN
C
C
          IF( RTIME( 8) .NE. 0.D0 ) WRITE(NW1,1080) RTIME( 8)
          IF( RTIME( 9) .NE. 0.D0 ) WRITE(NW1,1090) RTIME( 9)
          IF( RTIME(10) .NE. 0.D0 ) WRITE(NW1,1100) RTIME(10)
          IF( RTIME(11) .NE. 0.D0 ) WRITE(NW1,1110) RTIME(11)
          IF( RTIME(12) .NE. 0.D0 ) WRITE(NW1,1120) RTIME(12)
          IF( RTIME(13) .NE. 0.D0 ) WRITE(NW1,1130) RTIME(13)
          IF( RTIME(14) .NE. 0.D0 ) WRITE(NW1,1140) RTIME(14)
          IF( RTIME(15) .NE. 0.D0 ) WRITE(NW1,1150) RTIME(15)
C
          ENDIF
C
      ENDIF
C
C
      WRITE( NW1,2000 ) ISU3R
C
C
C     PERFORMANCE:
C
      WRITE( NW1,2500) TIME
C
      FGP    =  FGP1  + DBLE( METHIT ) * FGP2
      PFM    =  MFLOP * FGP * DBLE( ITEMAX ) * DBLE( NV ) / TIME
      WRITE( NW1,3000) PFM
C
C
 1000 FORMAT(2(/),15X,'PROFILING INFORMATION:'/
     >        15X,'--------------------- '/)
 1010 FORMAT( 15X,'EXECUTION TIME OF THE ITERATION LOOP: '
     >        ,F12.3,' sec' /)
 1020 FORMAT( 15X,'MKTBL             :',F6.2,' %' )
 1030 FORMAT( 15X,'STAPLE            :',F6.2,' %' )
 1040 FORMAT( 15X,'METRO             :',F6.2,' %' )
 1050 FORMAT( 15X,'SU3 RENORM.       :',F6.2,' %' )
 1060 FORMAT( 15X,'SUREXC            :',F6.2,' %' )
 1070 FORMAT( 15X,'WLINE             :',F6.2,' %' )
C
 1080 FORMAT(/15X,'WITHIN STAPLE     :'/
     >        15X,'       PRO        :',F6.2,' %' )
 1090 FORMAT(/15X,'WITHIN METRO      :'/
     >        15X,'       PRO        :',F6.2,' %' )
 1100 FORMAT( 15X,'       ADD        :',F6.2,' %' )
 1110 FORMAT( 15X,'       EXP        :',F6.2,' %' )
 1120 FORMAT( 15X,'       DRAND      :',F6.2,' %' )
 1130 FORMAT( 15X,'       GATHER     :',F6.2,' %' )
 1140 FORMAT( 15X,'       TRACE      :',F6.2,' %' )
 1150 FORMAT( 15X,'       ACCEPT     :',F6.2,' %' )
C
C
 2000 FORMAT(2(/),15X,'MODUL FOR RENORMALIZING LINKS FINALLY WAS ',I4 )
C
 2500 FORMAT(2(/),15X,'EXECUTION TIME                :',F12.3,' sec'/
     >            15X,'-------------- ')
C
 3000 FORMAT(2(/),15X,'PERFORMANCE (PURE LINK UPDATE):',F8.2,' Mflop/s'/
     >            15X,'----------- ')
C
C
      END
