C     ****************
      SUBROUTINE METRO(
C     ****************
     >                 NVH,NVL,NV,
     >                 METHIT,IACPT,BETA,
     >                 TBL,
     >                 WK1,WK2,WK3,WK4,WK5,
     >                 IRAND)
C
C
      DOUBLE PRECISION WK1(NVH,18),WK2(NVH,18),WK3(NVH,18),
     >                 WK4(NVH,18),WK5(NVH,18),
     >                 TBL(NV ,18),
     >                 BETA,INV3
C
      INTEGER          IRAND(NVH)
C
      PARAMETER( INV3 = 1.D0 / 3.D0 )
C
C
      DOUBLE PRECISION RTIME,TSTART,TEND
      COMMON / PERF / RTIME(15),IPRO
C
C
C     LOOP OVER NUMBER OF METROPOLIS HITS
C
C
      DO 10 ITH = 1,METHIT
C
C
C     SELECTING NVH RANDOM SU3 MATRICES FROM A TABLE
C
C
C     RANDOM GATHER OPERATION ON TBL
C
C
      CALL TIMER(TSTART)
C     ***********
      CALL RGTBL(NVH,NVL,WK2,NV,TBL,IRAND)
C     ***********
      CALL TIMER(TEND)
      RTIME(13) = RTIME(13) + TEND - TSTART
C
C
C     CALCULATE NEW LINK VARIABLES
C
C
      CALL TIMER(TSTART)
C     ********
      CALL PRO(NVH,NVL,1,WK3,WK2,WK1)
C     ********
      CALL TIMER(TEND)
      RTIME(9) = RTIME(9) + TEND - TSTART
C
C
C     CALCULATE LINK DIFFERENCES U(NEW) - U(OLD)
C
C
      CALL TIMER(TSTART)
C     ********
      CALL ADD(NVH,NVL,2,WK2,WK3,WK1)
C     ********
      CALL TIMER(TEND)
      RTIME(10) = RTIME(10) + TEND - TSTART
C
C
C     CALCULATE PLAQUETTE DIFFERENCES [ U(NEW) - U(OLD) ] * UUU
C
C
      CALL TIMER(TSTART)
C     ********
      CALL PRO(NVH,NVL,1,WK5,WK2,WK4)
C     ********
      CALL TIMER(TEND)
      RTIME(9) = RTIME(9) + TEND - TSTART
C
C
C     CALCULATE - DS = 1/3 * BETA * RETR { [ U(NEW) - U(OLD) ] * UUU }
C
C
      CALL TIMER(TSTART)
      DO 20 IVL = 1,NVL
      WK5(IVL,1) = (  WK5(IVL,1) + WK5(IVL,5) + WK5(IVL,9) )
     >             * ( BETA * INV3 )
   20 CONTINUE
      CALL TIMER(TEND)
      RTIME(14) = RTIME(14) + TEND - TSTART
C
C
C     CALCULATE EXP(-DS)
C
C
      CALL TIMER(TSTART)
      DO 30 IVL = 1,NVL
      WK5(IVL,1) = EXP( WK5(IVL,1) )
   30 CONTINUE
      CALL TIMER(TEND)
      RTIME(11) = RTIME(11) + TEND - TSTART
C
C
C     METROPOLIS TEST
C
C
      CALL TIMER(TSTART)
C     ***********
      CALL VDRAND(NVL,WK2)
C     ***********
      CALL TIMER(TEND)
      RTIME(12) = RTIME(12) + TEND - TSTART
C
C
      CALL TIMER(TSTART)
C     ***********
      CALL ACCEPT(NVH,NVL,IACPT,WK5,WK3,WK2,WK1)
C     ***********
      CALL TIMER(TEND)
      RTIME(15) = RTIME(15) + TEND - TSTART
C
C
   10 CONTINUE
C
C
      END
