#include <stdio.h>
#include <gl.h>
#include <device.h>

int ZBF_NX, ZBF_NY;
char *ZBF_R,*ZBF_G,*ZBF_B;

#define MAX(x,y) ((x)>(y)?(x):(y))
#define MIN(x,y) ((x)>(y)?(y):(x))

float dit[4][8][8] =
{
   { 
      { 0.5 }
   },

   {
      { 1/8.0, 5/8.0 },
      { 7/8.0, 3/8.0 }
   },

   {
      {  1/32.0, 17/32.0,  5/32.0, 21/32.0 },
      { 25/32.0,  9/32.0, 29/32.0, 13/32.0 },
      {  7/32.0, 23/32.0,  3/32.0, 19/32.0 },
      { 31/32.0, 15/32.0, 27/32.0, 11/32.0 }
   },

   {
      {   1/128.0,  65/128.0,  17/128.0, 81/128.0, 
          5/128.0,  69/128.0,  21/128.0, 85/128.0 },
      {  97/128.0,  33/128.0, 113/128.0, 49/128.0, 
        101/128.0,  37/128.0, 117/128.0, 53/128.0 },
      {  25/128.0,  89/128.0,   9/128.0, 73/128.0, 
         29/128.0,  93/128.0,  13/128.0, 77/128.0 },
      { 121/128.0,  57/128.0, 105/128.0, 41/128.0, 
        125/128.0,  61/128.0, 109/128.0, 45/128.0 },
      {   7/128.0,  71/128.0,  23/128.0, 87/128.0, 
          3/128.0,  67/128.0,  19/128.0, 83/128.0 },
      { 103/128.0,  39/128.0, 119/128.0, 55/128.0, 
         99/128.0,  35/128.0, 115/128.0, 51/128.0 },
      {  31/128.0,  95/128.0,  15/128.0, 79/128.0, 
         27/128.0,  91/128.0,  11/128.0, 75/128.0 },
      { 127/128.0,  63/128.0, 111/128.0, 47/128.0, 
        123/128.0,  59/128.0, 107/128.0, 43/128.0 }
   }
};

main( int argc, char **argv )
{
    static unsigned long *Image;
    static int first_time = 1;
    int i,j,k;

    char str[100];

    int dev;
    short val;

    FILE *fp = fopen( argv[1], "r" ); 

    fgets( str, 100, fp );
    sscanf( str, "%d %d", &ZBF_NX, &ZBF_NY );
    ZBF_R = (char *)malloc(ZBF_NX*ZBF_NY);
    ZBF_G = (char *)malloc(ZBF_NX*ZBF_NY);
    ZBF_B = (char *)malloc(ZBF_NX*ZBF_NY);

    fread( ZBF_R, ZBF_NX, ZBF_NY, fp );
    fread( ZBF_G, ZBF_NX, ZBF_NY, fp );
    fread( ZBF_B, ZBF_NX, ZBF_NY, fp );

    Image = (unsigned long *)malloc(ZBF_NX*ZBF_NY*sizeof(int));

    foreground( );
    prefsize( ZBF_NX, ZBF_NY );

    winopen( "zbf" );

    qdevice( REDRAW );

    RGBmode( );
    gconfig( );

    RGBcolor( 0, 0, 0 );
    clear( );

    k = 0;
    for( i = 0; i < ZBF_NY; i++ )
    for( j = 0; j < ZBF_NX; j++,k++ )
    {
        Image[k]  = 255 << 24;
        Image[k] |= ((int)(MIN(ZBF_B[k]+0.5+dit[1][i%2][j%2],255))) << 16;
        Image[k] |= ((int)(MIN(ZBF_G[k]+0.5+dit[1][i%2][j%2],255))) <<  8;
        Image[k] |= ((int)(MIN(ZBF_R[k]+0.5+dit[1][i%2][j%2],255)));
    }

    lrectwrite( 0, 0, ZBF_NX - 1, ZBF_NY - 1, Image );

    for( ;; ) {
        dev = qread( &val );
        if ( dev == REDRAW ) {
            reshapeviewport( );
            lrectwrite( 0, 0, ZBF_NX - 1, ZBF_NY - 1, Image );
            } 
        }
}
