/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: data.c,v 1.4 1993/05/05 15:55:25 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Intrinsic.h>

#include "list.h"
#include "view.h"

List    objectList;

InitCdata()
/* return True if ok */
{
        if (!(objectList = ListCreate())) {
		ErrMesg("Can't allocate memory\n");
		return(0);
		}

	return(1);
}

Cdata *RasDataSearchByName(s)
char *s;
{
Cdata *d;
	
	d = (Cdata *) ListHead(objectList);
	while(d) {
		if ((strcmp(d->name,s) == 0)&&(d->V->type == V_RASTER))
			return(d);
		d = (Cdata *) ListNext(objectList);
		}
	return(0);
}

Cdata *CdataSearchByName(s)
char *s;
{
Cdata *d;
	
	d = (Cdata *) ListHead(objectList);
	while(d) {
		if (!strcmp(d->name,s))
			return(d);
		d = (Cdata *) ListNext(objectList);
		}
	return(0);
}

void
CdataAddEntry(d)
     Cdata *d;
{
	ListAddEntry(objectList, d);
}

Cdata *
CdataNew()
{
	Cdata *d;

	if ((d = (Cdata *)calloc(1,sizeof(Cdata))) == NULL)
		fprintf(stderr, "Out of Memory\n");
	else
	  {
		d->name = d->buff = (char *)NULL;
		d->fbuff = (float *)NULL;
		d->image = d->doodleImage = (XImage *)NULL;
		d->pal = (Palette *)NULL;
		d->V = (View *)NULL;
		d->xmag = d->ymag = 1;
	  }

	return d;
}

Cdata *
CopyCdata(data, new)
	Cdata *data;
	int *new;
{
	Cdata *d;
	char *name;

	if (strcmp(&(data->name[strlen(data->name) - 5]), " COPY") == 0)
	{
		fprintf(stderr, "CANNOT COPY A COPY!!\n");
		return(NULL);
	}
	if (!(name = (char *)MALLOC(strlen(data->name) + 6)))
	{
		fprintf(stderr, "Out of Memory\n");
		return(NULL);
	}
	strcpy(name, data->name);
	strcat(name, " COPY");
	if ((d = CdataSearchByName(name)) == NULL)
	{
		*new = 1;
		if (!(d = (Cdata *)MALLOC(sizeof(Cdata))))
		{
			fprintf(stderr, "Out of Memory\n");
			return(NULL);
		}
	}
	else
	{
		*new = 0;
	}

	d->name = name;
	d->type = data->type;
	d->xdim = data->xdim;
	d->ydim = data->ydim;
	d->xmag = data->xmag;
	d->ymag = data->ymag;
	d->max =  data->max;
	d->min =  data->min;
	if (d->type == D_CHAR)
	{
		if (!(d->buff = (char *)MALLOC(d->xdim * d->ydim)))
		{
			fprintf(stderr, "Out of Memory\n");
			return(NULL);
		}
		bcopy(data->buff, d->buff, (d->xdim * d->ydim));
		d->fbuff = NULL;
	}
	else if (d->type == D_INT)
	{
		if (!(d->fbuff = (float *)
			MALLOC((d->xdim/d->xmag) * (d->ydim/d->ymag) * sizeof(int))))
		{
			fprintf(stderr, "Out of Memory\n");
			return(NULL);
		}
		bcopy(data->fbuff, d->fbuff,
			((d->xdim/d->xmag) * (d->ydim/d->ymag) * sizeof(int)));
		d->buff = NULL;
	}
	else if (d->type == D_FLOAT)
	{
		if (!(d->fbuff = (float *)
			MALLOC((d->xdim/d->xmag) * (d->ydim/d->ymag) * sizeof(float))))
		{
			fprintf(stderr, "Out of Memory\n");
			return(NULL);
		}
		bcopy(data->fbuff, d->fbuff,
			((d->xdim/d->xmag) * (d->ydim/d->ymag) * sizeof(float)));
		d->buff = NULL;
	}
	d->image = (XImage *)0;
	d->doodleImage = (XImage *)0;
	d->hasPalette = data->hasPalette;
	d->pal = data->pal;
	return(d);
}

