%******************************************************************************
%  FILE = matrix.red 				Sun May 17 20:07:37 EDT 1987
% 
%  Procedures in this file:
%  
%  DET* DETERM* COFACTOR* INVERT* COFACTOR1 DETERM1 TRACE*
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

PUT ('MDET, 'SIMPFN, 'SIMPDET);  % move matrix determinant function to mdet
PUT ('DET, 'SIMPFN, 'DET!*);

% det* computes the determinant of the rank-2 object given. it uses
% a cofactor method. the scalar value is added to the objects property
% list under the ket 'det.

SYMBOLIC PROCEDURE DET!* (U);
BEGIN SCALAR TNSR, LEX;
  TNSR := GETNME (REVAL (MYCAR (U)), 'DET);
  IF NOT MYCAR (GET (TNSR, 'INDICES)) = 2 THEN
    MERROR (LIST ("object must have two indices:", TNSR), 'T, 'DET)
  ELSE IF (LEX := RESIMPSCALAR (MYCADR (U), TNSR, 'DET))
    THEN RETURN (LEX); % already done
  LEX := DETERM1 (TNSR, IGEN ('(a!# b!#), GET (TNSR, 'CONCOV),
                        'NIL));
  IF NOT MYCAR (LEX) THEN
    MERROR (LIST ("singular matrix:", TNSR), 'NIL, 'DET);
  PUT (TNSR, 'DET, LEX);
  CLEANER ('DET);
  RETURN (LEX);
END;

PUT ('DETERM, 'SIMPFN, 'DETERM!*);

% determ* computes the determinant of the given rank-2 object from the
% cofactor matrix supplied as the second argument (see cofactor).

SYMBOLIC PROCEDURE DETERM!* (U);
BEGIN SCALAR LEX, SUMM, LEX2, TNSR, TNSR1, TRANSFLG;
  TNSR := GETNME (REVAL (MYCAR (U)), 'DETERM);	% object name
  TNSR1 := GETNME (REVAL (MYCADR (U)), 'DETERM);	% cofactor matrix name
  TRANSFLG := MYCADDR (U);		% transpose flag
  IF NOT MYCAR (GET (TNSR, 'INDICES)) = 2 THEN
    MERROR (LIST ("object must have two indices:", TNSR), 'T, 'DETERM)
  ELSE IF (LEX := GET (TNSR, 'DET)) THEN RETURN (LEX); % already done
  LEX := MYCAR (GETINDICES (MYCAR (GET (TNSR, 'CONCOV))));
       % generate indices for top row of object.
  LEX := IGEN (LIST (LEX, 'a!#), GET (TNSR, 'CONCOV), 'NIL);
  SUMM := 'NIL . 1;
  LOOP:	% run over top row of cofactor matrix
    IF TRANSFLG THEN LEX2 := LIST (MYCADAR (LEX), MYCAAR (LEX))	% transpose too.
    ELSE LEX2 := MYCAR (LEX);
    IF NOT LEX THEN GO TO AFTERLOOP;
       % note: the alternating sign is incorporated in the cofactor matrix.
    SUMM := ADDSQ (SUMM, MULTSQ (READTNSR (TNSR1, LEX2), 
                                 READTNSR (TNSR, MYCAR (LEX))));
    LEX := MYCDR (LEX);
  GO TO LOOP;
  AFTERLOOP:
  IF NOT MYCAR (SUMM) THEN
    MERROR (LIST ("singular matrix:", TNSR), 'NIL, 'DETERM);
  PUT (TNSR, 'DET, SUMM);
  CLEANER ('DETERM);
  RETURN (SUMM);
END;

PUT ('COFACTOR, 'SIMPFN, 'COFACTOR!*);

% cofactor* generates a cofactor matrix of its first argument, and places
% the result in its second. 

SYMBOLIC PROCEDURE COFACTOR!* (U);
BEGIN SCALAR LEX, LEX1, LEX2, TNSR, TNSR1, TRANSFLG, SGN;
  TNSR := GETNME (REVAL (MYCAR (U)), 'COFACTOR);	% input object
  TNSR1 := GETNME (REVAL (MYCADR (U)), 'COFACTOR);	% output name
  TRANSFLG := MYCADDR (U);		% transpose flag
  IF NOT MYCAR (GET (TNSR, 'INDICES)) = 2 THEN
    MERROR (LIST ("object must have two indices:", TNSR), 'T, 'COFACTOR);
  LEX := IGEN ('(a!# b!#), GET (TNSR, 'CONCOV),  % generate object indices
                GET (TNSR, 'SYMMETRY));
  LEX1 := IGEN ('(a!# b!#), GET (TNSR, 'CONCOV), 'NIL);
  MKTNSR!* (TNSR1, LIST (-MYCAR (GET (TNSR, 'CONCOV)),
            -MYCADR (GET (TNSR, 'CONCOV))), GET (TNSR, 'SYMMETRY),
            'NIL, 'COFACTOR);
  IF LENGTH (LEX1) = 4 THEN <<	% faster for 2x2 matrices
    WRITETNSR (TNSR1, MYCAR (LEX1), READTNSR (TNSR, MYCADDDR (LEX1)), 'NIL);
    WRITETNSR (TNSR1, MYCADDDR (LEX1), READTNSR (TNSR, MYCAR (LEX1)), 'NIL);
    WRITETNSR (TNSR1, MYCADR (LEX1), NEGSQ (READTNSR (TNSR, MYCADR (LEX1))), 'NIL);
    WRITETNSR (TNSR1, MYCADDR (LEX1), NEGSQ(READTNSR (TNSR, MYCADDR (LEX1))), 'NIL);
    RETURN (TNSR1 . 1)
  >>;
  WHILE LEX DO <<	% computes determinants of minors
    IF TRANSFLG THEN LEX2 := LIST (MYCADAR (LEX), MYCAAR (LEX))
    ELSE LEX2 := MYCAR (LEX);
     % NOTE: the alternating sign is included in the cofactor matrix.
    IF REMAINDER (MYCAAR (LEX) + MYCADAR (LEX), 2) = 0 THEN 
      WRITETNSR (TNSR1, LEX2, COFACTOR1 (TNSR, MYCAR (LEX), LEX1), 'NIL)
    ELSE 
      WRITETNSR (TNSR1, LEX2, NEGSQ (COFACTOR1 (TNSR, MYCAR (LEX), LEX1)), 'NIL);

    LEX := MYCDR (LEX)
  >>;
  CLEANER ('COFACTOR);
  RETURN (TNSR1 . 1);
END;

PUT ('INVERT, 'SIMPFN, 'INVERT!*);

% invert* computes the matrix inverse of the object given as input, the
% inverse goes into an object with a name of the form <name>#INV. if
% the matrix is singular, a zero divide error will occur.
% the algorithm involves the usual minor cofactor expansion.
% the inverse object has the indices raised or lowered as required, and
% is placed on the parents '*at* list, along with the proper delta fnc.

SYMBOLIC PROCEDURE INVERT!* (U);
BEGIN SCALAR TNSR, TNSR1, LEX, LEX1, FLG;
  TNSR := GETNME (REVAL (MYCAR (U)), 'INVERT);
  IF NOT INDEXED (TNSR) THEN RETURN (SIMP (LIST ('QUOTIENT, 1, TNSR)));
  TNSR1 := MAKENAME (APPEND (EXPLODE (TNSR), '(!# I N V))); % inverse name
  IF (LEX := GET (TNSR, 'SYMMETRY)) = '(((0) 1 2)) THEN <<
     % if its diagonal, the inverse is too and elements are reciprocals.
    MKTNSR!* (TNSR1, LIST (-MYCAR (GET (TNSR, 'CONCOV)),
            -MYCADR (GET (TNSR, 'CONCOV))), LEX, 'NIL, 'NIL);
    PUT (TNSR1, 'PNAME, GET (TNSR, 'PNAME));
    LEX := IGEN ('(a!# b!#), GET (TNSR, 'CONCOV), LEX);
    FOR EACH X IN LEX DO WRITETNSR (TNSR1, X, 
                    INVSQ (READTNSR (TNSR, X)), 'NIL);
  >> ELSE <<	% have to do it the long way.
    % if one index is up and the other down, transpose so a valid sum
    % can be formed that leads to a delta. if we dont do this, then the
    % contraction indices are either both up or both down.
    LEX1 := GET (TNSR, 'CONCOV);
    IF MYCAR (LEX1) * MYCADR (LEX1) > 0 THEN FLG := 'T;
    COFACTOR!* (LIST (TNSR, TNSR1, FLG));
    PUT (TNSR1, 'PNAME, GET (TNSR, 'PNAME));
    PUT (TNSR1, 'MULTIPLIER, INVSQ (DETERM!* (LIST (TNSR, TNSR1, FLG))))
  >>;
  PUT (TNSR1, 'TYPE, GET (TNSR, 'TYPE));
  IF INDEXED (TNSR) EQ 'MIXED THEN LEX := 'NIL
  ELSE <<    % find the appropriate delta function for a half shift.
    LEX := MAKENAME (LIST ('d, ABS (MYCAR (GET (TNSR, 'CONCOV))) + 48));
    IF NOT FLG THEN LEX := LIST (MAKENAME (APPEND (EXPLODE (LEX), '(!# b))),
                                 MAKENAME (APPEND (EXPLODE (LEX), '(!# c))));
    ELSE LEX := LIST (LEX)
  >>;
  PUT (TNSR, '!*AT!*, APPEND (LIST ('NIL, TNSR, TNSR1), LEX));
  CLEANER ('INVERT);
  RETURN (TNSR1 . 1);
END;

% cofactor1 produces the indices for the current minor, and calls
% determ1 to compute the determinant of this minor. of course, determ1
% in turn calls cofactor1 to find the lower minors.
% elmnts is a list of indices describing the current minor, loc is a single
% index describing the current location, and the while loop strikes out
% all elements having a common row or column to produce a list describing
% the minor.

SYMBOLIC PROCEDURE COFACTOR1 (TNSR, LOC, ELMNTS);
BEGIN SCALAR LIS;
  WHILE ELMNTS DO <<	% indices in minor
    IF NOT (MYCAAR (ELMNTS) = MYCAR (LOC) OR MYCADAR (ELMNTS) = MYCADR (LOC)) THEN
         LIS := MYCAR (ELMNTS) . LIS;
    ELMNTS := MYCDR (ELMNTS)
  >>;
  RETURN (DETERM1 (TNSR, REVERSE (LIS)));	% determinant of minor
END;

% determ1 computes the determinat of the minor described by the list
% of indices elmnts. when this list gets down to 4 elements, we stop the
% recursion and use the standard method for determinants.

SYMBOLIC PROCEDURE DETERM1 (TNSR, ELMNTS);
BEGIN SCALAR LEX, N, LEX1, SGN, SUMM;
  IF LENGTH (ELMNTS) = 4 THEN    % minor is 2x2
     RETURN (ADDSQ (MULTSQ (READTNSR (TNSR, MYCAR (ELMNTS)),
        READTNSR (TNSR, MYCADDDR (ELMNTS))), NEGSQ (MULTSQ (
        READTNSR (TNSR, MYCADR (ELMNTS)), READTNSR (TNSR, MYCADDR (ELMNTS))))));
     
  SGN := 1;
  N := MYCAAR (ELMNTS);
  LEX := ELMNTS;
  SUMM := 'NIL . 1;
  WHILE N = MYCAAR (LEX) DO <<	% multiply value by cofactor element of minor.
    LEX1 := READTNSR (TNSR, MYCAR (LEX));
    IF MYCAR (LEX1) THEN
      SUMM := ADDSQ (SUMM, MULTSQ (MULTSQ ((SGN . 1), LEX1),
		COFACTOR1 (TNSR, MYCAR (LEX), ELMNTS)));
    LEX := MYCDR (LEX);
    SGN := -SGN		% alternating sign for minor expansion.
  >>;
  RETURN (SUMM);
END;

PUT ('MTRACE, 'SIMPFN, 'SIMPTRACE);     % move matrix trace function.
PUT ('TRACE, 'SIMPFN, 'TRACE!*);

% trace* computes the trace of the rank-2 object given. 

SYMBOLIC PROCEDURE TRACE!* (U);
BEGIN SCALAR TNSR, LEX, LEX1;
  TNSR := GETNME (REVAL (MYCAR (U)), 'TRACE);
  IF NOT MYCAR (GET (TNSR, 'INDICES)) = 2 THEN
    MERROR (LIST ("object must have two indices:", TNSR), 'T, 'TRACE);
  LEX := IGEN ('(a!# b!#), GET (TNSR, 'CONCOV), '(((0) 1 2)));
  LEX := 'PLUS . FOR EACH X IN LEX COLLECT MK!*SQ (READTNSR (TNSR, X));
  RETURN (SIMP (LEX));
END;

;END;
