.so include.n
.po
.he ``REDTEN Reference Manual``
.bp
.ls 2
.sp 2
.nh        \" no hyphenation
.br
.pp
This reference manual provides a brief introduction to the REDTEN algebra
system. It is presumed that the user has an understanding of both the
REDUCE computer algebra package and also of tensor algebra in general.
While not exhaustive, this manual provides the basic information required
to use REDTEN. Values of variables are enclosed in angle brackets (<>),
optional parameters are enclosed in braces ({}) and default values are
enclosed in square brackets ([]). Note that REDTEN is usually case
insensitive.
.pp
Variables in REDUCE can have either lisp values, REDUCE values (i.e.
algebraic values), or both.
Accessing the Lisp value is accomplished by adding the word `lisp' to
the beginning of the command line; for example, `lisp a' returns the
lisp value of `a' and `lisp a :\(eq 3' sets the lisp value of `a' to 3. A number
of REDTEN control variables have
lisp values, these are indicated in this manual by prepending `\*BLisp:\fP'
to the variable name, `\*BLisp:\fP' is not part of the system name.
.bp
.sp 1
.sp 1
.ne 5
.sp 3
.sh 1
\*BIndexed Objects\fP
.pp
The basic entity of REDTEN is the indexed object. Such an object consists
of a set of values associated with various indices, and a set of properties
which describe the object. An element of the object may accessed by enclosing
the index of the element in square brackets ([]) following the objects' name:
.ce
r[1,2,1,2]; j[0,1]; g[2,3];
.br
Note that these operations are simply a retrieval of a value, no
substitution or other evaluation takes place; to force this, wrap a
sub around the reference, eg. sub (r[1,2,1,2]).
Assigning a specific element is done in a similar fashion, the element
reference is followed by the indexed object assignment operator `\(eq\(eq' and
the desired value:
.ce
r[1,2,1,2] \(eq\(eq a + b;
.br
This use of the assignment operation is a special case of a more general
operation described below.
.pp
Before an indexed object can be used it must be created with a call to
\*Bmktnsr\fP. This has the form:
.ce
mktnsr (name, {concov}, {symmetry}, {implicit}, {type});
.pp
<name> is the name which the object will have in the system. Any previous
value assigned to <name> will be lost; if <name> was an indexed object
it is deleted if that is possible. If <name> has a value, then it must
be quoted when passed to \*Bmktnsr\fP.
.pp
<concov> describes the index structure of the object. It is a list of
integers; the length of the list determines the rank of the object. Each
integer may be one of 1, 2, 3, 4, or 5 according as whether the corresponding
index is a tensor, frame, spinor, dotted-spinor, or matrix index. If the
integer is positive, the index is contravariant; if negative the index is
covariant.
.pp
<symmetry> describes the intrinsic symmetries of the object. This is
a list of independent symmetry lists of the form: 
.sp 1
.ne 5 
.ce
(({c,} l, p\*D\s-21\s0\*U, p\*D\s-22\s0\*U, p\*D\s-23\s0\*U, ...), ... {(h, p\*D\s-21\s0\*U, p\*D\s-22\s0\*U, ...)})
.sp 1
.ne 5 
.pp
In each independent symmetry list <l> is the size of the
blocks involved in the symmetry, if <l> is negative then an anti-symmetry
is implied. If <l> is 0, then a trace symmetry is implied but the block
size is 1. The locations of each block in the index are given by the
pointers p\*D\s-2i\s0\*U. If the letter `c' is prepended to the list, it indicates that
a complex conjugate is to be taken when permuting the index. The form
beginning with the letter `h' specifies a Hermitian symmetry. In this case,
the pointers p\*D\s-2i\s0\*U must point to spinor dotted-spinor blocks within the
<concov> list of <name>. If no pointers are given with the `h' form, the
system constructs a Hermitian symmetry for the object.
.pp
An example of a symmetry list describing
the Riemann symmetry is '((-1 1 2) (-1 3 4) (2 1 3)). This may be read as
"anti-symmetric in the first two indices, anti-symmetric in the third
and fourth indices, and symmetric in pairs of indices beginning at the first
and third index". Note that the internal form of the symmetry list
is somewhat different than that described above.
.pp
When an object with a formal index is encountered by the system, the
index is permuted into a canonical form as indicated by the intrinsic
symmetries. This ensures, for example, that object references will
cancel out if the indices are permuted and an anti-symmetry is involved.
For example, if q is anti-symmetric (see examples below) then
.in 3
.nf
1: q[a,b];
\ q\*Da b\*U
2: q[b,a];
\ -q\*Da b\*U
3: q[a,b] + q[b,a];
\ 0
.fi
.in 0
.br
.pp
There are two types of values associated with an indexed object,
those which are explicit and those which are implicit. An explicit value
is one that is assigned with the use of the `\(eq\(eq' operator (or \*Bias\fP).
An implicit value
is created when <implicit> is either <name> or an integer. Any reference
to an element which is not explicitly defined and which is not identically
zero by virtue of the intrinsic symmetries of the object is returned as
an implicit value. This can be used to create objects whose form is known
but whose actual elements are unknown. An implicit object has a `+' placed
after the number of elements field in a directory listing. When <implicit>
is <name>, <name> is made to depend on the current coordinates.
.pp
The <type> parameter is provided for the user's convenience to identify
an object.
.pp
When an object is created it is given two characteristics that are
determined by the values of global system variables. Each object is
defined in a particular set of coordinates, as given by the \*BLisp:coords\fP
variable.
Additionally, the runs of various types of indices are given by the
variables \*BLisp:indiceten\fP, \*BLisp:indicesp\fP and \*BLisp:indicemat\fP.
.pp
Following are examples of the creation of indexed objects.
.nf
.sp 1
.in 3
.(b M
.ls 2
% q is an anti-symmetric, covariant tensor %
1: mktnsr ('q, '(-1 -1), '((-1 1 2)));   
\ q\*Da b\*U
2: q[1,1] \(eq\(eq a + b; % cannot write something to the diagonal %
\ 0
3: q[1,2] \(eq\(eq c;
\ c
4: q[2,1];	% sign change with permutation %
\ -c
  % u is an implicit, covariant tensor %
.)b
.(b M
.ls 2
5: mktnsr ('u, '(-1 -1), '(), 'u);
\ u\*Da b\*U
  % there is no explicit value, returns an implicit value %
6: u[1,2];
\ u\*D1 2\*U
7: U[1,2] \(eq\(eq d;  % write an explicit value %
\ d;
8: u[1,2];
\ d
.)b
.in 0
.ls 2
.fi
.pp
There are two ways to examine the contents of an indexed object. To
see only the explicit elements an empty index may be used in an object
reference (eg. q[]); or a formal index may be used, with a `?' appended
as an extra index (eg. q[a,b,?]). This form displays all elements of the
object, including implicit values or those elements whose values are 0.
Each of these display forms also shows some of the properties of the
object.
To get an overview of the numbers and types of indexed objects currently
in the system, the function \*Bdir\fP is provided.
.sp 1
.ne 5
.sp 3
.sh 1
\*BIndexed Algebra\fP
.pp
REDTEN is designed to handle the short-hand notations of tensor algebra.
In particular, algebraic operations are partially indicated by the formal
indices of the objects involved in an expression. Repeated indices in
covariant and contravariant positions within a single index or among the
terms in a product denote an Einstein summation. The number and names of
free indices on each side of the assignment operator must agree, unless
the right hand side is a scalar, in which case the entire object is assigned
with that value.
For example, to copy the object u to the object q, the command is:
.ce
q[a,b] \(eq\(eq u[a,b];
whereas to copy the transpose of u:
.ce
q[a,b] \(eq\(eq u[b,a];
.br
As each element is copied, its index is printed. 
.pp
When the object to the left of the `\(eq\(eq' has been previously created by the
user, the index structure of the left and right hand sides must agree.
If the user
has not created the object, it will be given the index structure of the
right hand side. In cases where portions of the index structure cannot
be determined, those portions become covariant tensor indices. For
example, the command
.ce
f[a,b]\ \(eq\(eq\ a;
.br
creates f as a rank 2 covariant tensor, and, additionally 
assigns every element of F the value a. Note that there is no conflict
between the value `a' and the index `a'. In REDTEN it is necessary to
declare f by calling \*Bmktnsr\fP before f is used with an index, as in
mktnsr('f).
.pp
If the left hand side is a simple scalar object, the right hand side
must of course contract to a scalar or be a scalar. In a special case
mentioned above, the left hand side can be a reference to a specific element
of an indexed object.
.pp
When the symmetries of the left hand object are known, they may be given
to the object without fully creating it by calling \*Bmktnsr\fP with
a nil concov parameter. This will significantly reduce the evaluation
time of the assignment, since only the independent elements of the
output object will be considered. It is imperative that the symmetries correctly
represent the right hand expression.
.pp
When evaluating a summation involving objects with trace symmetries, the
system takes advantage of the symmetry and converts the sum to a single
product. This conversion is hidden from the user and affects only the
internal parsed form of the expression being evaluated. There is a
considerable performance gain when this is done. Any object known
to be diagonal should be given a diagonal symmetry to take advantage of
this.
.sp 1
.ne 5
.sp 3
.sh 1
\*BIndex Operators\fP
.pp
There are three operations which are indicated by placing the appropriate
symbols in the index of an object: symmetrization, raising and lowering
indices, and derivatives. 
.sp 3
.sh 2
\*BSymmetrization\fP
.pp
A symmetrization operation is indicated by enclosing the desired indices
within square brackets ([]), an anti-symmetrization is indicated with
braces ({}). The evaluation of the operation occurs as soon as it is
encountered by the parser, unless another operation is pending.
For example,
.nf
.in 3
.(b M
.ls 2
1: q[[a,b]];
\ (q\*Da b\*U\ +\ q\*Db a\*U)/2
2: q[{a,b}];
\ (q\*Da b\*U\ \-\ q\*Db a\*U)/2
.)b
.fi
.in 0
.br
.pp
At most four indices can be symmetrized in one operation. Bach brackets
are indicated by placing `#' symbols in the index. Indices between these 
symbols or between one and the end of the index are not affected by an
enclosing symmetrization operation. If the `#' symbols are outside a
symmetrization operation, they then act as ordinary indices.
For example,
.nf
.in 3
.(b M
.ls 2
3: y[[a,#,b,#,c]]
\ (y\*D a b c\*U\ +\ y\*D c b a\*U)/2
4: y[{a,#,b,#,c}]
\ (y\*Da b c\*U\ -\ y\*Dc b a\*U)/2
.)b
.fi
.in 0
.br
.sp 3
.sh 2
\*BShifting Indices\fP
.pp
Raising and lowering indices is accomplished with the use of the
shift operator `@'. There must also be a metric defined for the type
of the index being shifted (i.e if a tensor index is being raised, there
must exist a tensor metric); metrics are discussed below. The shift operator
is placed directly before any index the user wishes to raise or lower.
If the index is currently covariant it will become contravariant and
vice versa. 
.pp
The shift operation causes a new indexed object to be created in the system,
with a name based on the parent objects' name and a suffix which describes
the way in which the parent object was shifted to produce the offspring.
The suffix consists of a `#' symbol and another letter. The print name
of the new object will be the same as the parents. These objects form
a family for which the system keeps track of the relations between the
members. The shift operation can be done at any time by calling the
function \*Bshift\fP on the object with the appropriately shifted
formal index. For example,
.nf
.in 3
.(b M
.ls 2
1: shift (q[@a, @b]);
computing q#d
\ q\*Da b\*U
.)b
.in 0
.fi
.sp 3
.sh 2
\*BDifferentiation\fP
.pp
Differentiation is indicated by placing a `|' for ordinary differentiation
or a `||' for covariant differentiation after the objects' formal index
and followed by one or more derivative indices. As with shift operations,
evaluation of derivative operations is delayed until the object takes
part in an assignment operation. Unlike shift operations, however, one
cannot read out a specific element of the derivative of an object.
.pp
Ordinary derivative operations may or may not create temporary objects,
depending on whether such will be faster or not, no permanent object is
created. The differentiation is done with respect to the coordinate names
in the order in which they appear in the \*BLisp:coords\fP list. Although properly
not tensor indices, derivative indices are treated as such by the system.
To perform a differentiation with respect to a variable which is not one of the
coordinates, the `|' notation cannot be used; rather, use the function
\*Bidf\fP which is similar to the REDUCE df function.
An indexed object may be given dependencies just as any other REDUCE variable
by using depend with the object name.
.pp
Covariant differentiation always creates a permanent object with a name
of the form <name>#cd. This operation requires the existence of Christoffel
symbols for each type of index in the concov list of the object, if they do
not exist, they will be created. A covariant
derivative can be computed at any time by calling the function \*Bcov\fP
with the name of the object.
.sp 1
.ne 5
.sp 3
.sh 1
\*BGeneral Relativity\fP
.br
.pp
There are a number of functions provided in REDTEN to compute the
objects of interest in General Relativity calculations. Beginning with
a line-element, one can compute the metric, Christoffel symbols, Riemann
curvature tensor, Ricci tensor and scalar, Weyl conformal curvature tensor,
and Einstein tensor. Other functions compute things such as Killing equations
and Lie derivatives.
.pp
To use the General Relativity package one must first create a line-element.
This is a REDUCE expression of the form:
.ti +3
name: g\*D\s-20\ 0\s0\*U\ \*Bd\fP(x\*D\s-20\s0\*U)^2
\ +\ g\*D\s-20\ 1\s0\*U\ \*Bd\fP(x\*D\s-20\s0\*U)\ \*Bd\fP(x\*D\s-21\s0\*U) + ...
.br
where the g\*D\s-2i\ j\s0\*U are the components of the metric tensor. The arguments
to the function \*Bd\fP are usually coordinate names, if they are not,
\*Bd\fP computes the total derivative of the argument.
.pp
The line-element above is converted into a metric tensor by calling
\*Bmetric\fP. This function sets up all the properties required
for a metric, and determines the proper symmetry (either simply symmetric or
diagonal). The object created has <\*BLisp:metric\fP> as its name; \*Bmetric\fP
also computes the metric inverse, which has the name <\*BLisp:metric\fP>#inv. Before
computing the objects listed below it is wise to examine the reciprocal of the
determinant of
the metric, which is stored on the \*Bmultiplier\fP property of the
inverse (unless the metric is diagonal). It is best if it is not a sum,
substituting another symbol (using \*Bmultiplier\fP) for it
is often helpful. When this is done the determinant should be combined with
the inverse using \*Bmapfi\fP.
.pp
Most 
of the GR functions place the name of the object they create on the property
list of the metric, so that they can retrieve the name object without having
to recompute it. Any function which requires another object that does
not exist will cause the system to compute it, except for the metric,
which must be computed from the line-element by the user. Each function
creates its object with the proper symmetries and \*Btype\fP parameter; the
name of the object will be the value of the function name, or the argument
to the function.
.pp
Christoffel symbols are computed by calling the functions \*Bchristoffel1\fP
and \*Bchristoffel2\fP. The Riemann curvature tensor is computed by the
function \*Briemann\fP; the Ricci tensor is computed by \*Bricci\fP and
the Ricci scalar is computed by \*Briccisc\fP. This last object is a scalar
whose name is [\*Bricsc\fP], another copy is placed on the property
list of the Ricci tensor. This is the copy the system will use in the future,
it can be accessed via \*Briccisc\fP with a nil first argument. If the
second argument is non-nil and not t, that value replaces the Ricci
scalar; if the second argument is t, the Ricci scalar is re-simplified.
\*Briccisc\fP with no arguments returns the Ricci scalar if it exits, and
computes it if it does not.
.pp
The Weyl tensor is computed with the function \*Bweyl\fP and the Einstein
tensor is computed with \*Beinstein\fP. Other functions of interest are
\*Bdiv\fP, which computes the divergence of a vector and \*Bgeodesic\fP
which computes the geodesic equations. This function requires a name for
its first argument which is the `matrix' where the equations will be placed.
The second argument, if present, specifies the affine parameter [s]. 
.pp
\*Bkilling\fP will compute the conformal Killing equations if the second
argument is non-nil or the ordinary Killing equations if it is. The first
argument is the name of the object where the equations will be placed, it has
two matrix indices.
Lie derivatives are computed with the function \*Blie\fP, which requires
the name of the object whose derivative is being computed and the name of
a vector defining the direction of the derivative. The output is in the
object <name><vector>#lie.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BFrames and Spinors\fP
.pp
In REDTEN there is a distinction between tensor, frame and spinor indices.
A basic frame package is under development in REDTEN. Currently it is
somewhat rudimentary in certain areas. An even more rudimentary spinor
package is also available; it has very few capabilities and is not yet very
sophisticated. Note that all the functions described below store the
names of their outputs on the tensor metric, therefore a tensor metric
must exist, even if it is not otherwise used.
.pp
\*Bfrmetric\fP constructs a frame metric for an orthonormal basis.
\*Bnulltetrad\fP attempts to compute a set of null-tetrad vectors given
the spin matrices (see below). The user can construct the tetrad frame
vectors by hand (see example 4b) and make the connection known to the system
by calling \*Bsetcon\fP, these connections are of type 1. Given a frame
metric and the connection, \*Bmetric\fP called without any argument (or
a nil first argument) will compute the tensor metric from these.
.pp
The remaining functions in the frame package compute standard quantities,
and do not require user input of the sort required above. \*Bgamma\fP
computes the Ricci rotation coefficients, the frame Riemann curvature tensor
is computed with \*Bfrriemann\fP, and the frame Ricci tensor is computed
with \*Bfrricci\fP. The Ricci scalar in the frame is computed with
\*Bfrriccisc\fP, the value is stored on the property list of the
frame Ricci tensor and can be accessed in a similar manner to the Ricci
scalar in natural basis (see \*Briccisc\fP). Note that these two Ricci
scalars should agree in
value. \*Bfrweyl\fP computes the Weyl tensor in the frame, and
\*Bfreinstein\fP computes the Einstein tensor in the frame.
.pp
Spinors in REDTEN can have more structure than ordinary tensors. A spinor
can be Hermitian, have a conjugate symmetry, or an ordinary symmetry. Since
most spinors involve complex quantities, a package of complex algebra routines
has been added to REDTEN (see Complex Functions below).
Furthermore, when a spinor object is created, a conjugate object is also
created with the name <name>#cnj. This object has the index structure inverted,
each spinor index has become a dotted spinor index, and each dotted spinor
index has become a spinor index. The elements of this object are the conjugates
of those in the original, although no elements are stored for this object.
Applying \*Bconj\fP to either object results in a reference to the other.
.pp
\*BSpmetric\fP creates the standard spinor metrics, which are anti-symmetric.
With a current tensor metric (which must be diagonal), \*Bspinmat\fP will
construct the generalized Pauli spin matrices; other forms of the spin matrices
may be constructed by hand. The spin matrices are the type 2 connections,
and can be made known to the system with \*Bsetcon\fP. For these spin
matrices the spinor Christoffel symbols can be computed with
\*Bspchristoffel\fP.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BMatrices\fP
.pp
A `matrix' in REDTEN can be one of two things: an object with matrix
indices (not necessarily of rank-2), or any rank-2 object, regardless of
the type of its indices. We will be concerned with the second definition
here; the matrix routines in REDTEN operate on any rank-2 object. 
.pp
\*Bdet\fP computes the determinant of its argument using the cofactor
method. The result is stored on the property list of the object and
can be altered by calling \*Bdet\fP with a non-nil second argument.
\*Bcofactor\fP computes the cofactor matrix of its first argument, placing
the result in its second argument. \*Bdeterm\fP will compute the determinant
of its first argument, given the cofactor matrix as its second argument.
.pp
\*Binvert\fP computes the matrix inverse of its argument, the result
is placed in the object <name>#inv. The determinant of the object is
stored on the \*Bmultiplier\fP property of the inverse. It can be
accessed using \*Bmultiplier\fP and should be combined with the object
using \*Bmapfi\fP as soon as possible. The inverse object has its
indices shifted relative to the given object.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BUtilities and Other Functions\fP
.br
.pp
There are a number of utilities provided in REDTEN to help the user
manage the system. A brief description of these functions is given below,
for more complete information about each, see the function directory
in appendix B.
.in 1i
.ti 0
\*Bcleartmp\fP - delete temporary objects and reset system variables.
.br
.ti 0
\*Bcopy\fP - copy an object.
.br
.ti 0
\*Bdir\fP - directory of all objects in the system, and vital statistics on each.
.br
.ti 0
\*Bhelp\fP - online help function. 
.br
.ti 0
\*Bias\fP - assign elements to an entire object.
.br
.ti 0
\*Bmapfi\fP - map a function onto an object.
.br
.ti 0
\*Bmclear\fP - clear the parser if an error occurs during input.
.br
.ti 0
\*Bmkscalar\fP - declare a `scalar' object which may have an index, it
must indicate a derivative operation. The value of the object is used for
the differentiation.
.br
.ti 0
\*Bmultiplier\fP - access or replace an objects' multiplier value.
.br
.ti 0
\*Bnodir\fP - hide objects from the directory listing.
.br
.ti 0
\*Brem\fP - delete indexed objects from the system.
.br
.ti 0
\*Bresimp\fP - force resimplification of the given expression.
.br
.ti 0
\*Bsavec\fP - save the components of objects on disk.
.br
.ti 0
\*Bsavei\fP - save indexed objects on disk.
.br
.in 0
.sp 1
.ne 5
.sp 3
.sh 1
\*BComplex Functions\fP
.pp
In REDUCE sqrt(-1) has the name i. The function \*Bconj\fP, applied
to an expression containing i, will return the complex conjugate of the
expression. In addition, a variable may stand for itself and be declared
complex with the function \*Bcomplex\fP; the declaration may be removed
with \*Bnocomplex\fP. Conjugation of these quantities causes them to
be printed with a bar over the name. The functions \*Bre\fP, \*Bim\fP,
\*Bcmod\fP and \*Brat\fP compute the real part, imaginary part,
modulus and rationalization of the expression, respectively.
