%***************************************************************************
%  FILE = gr.red 				Tue Nov  8 12:43:50 EST 1988
% 
%  Procedures in this file:
%  
%  METRIC* SIMPD* ELMMET FNDCRD CHRISTOFFEL1* CHRISTOFFEL2* 
%  RIEMANN* RICCI* RICCISC** RICCISC* EINSTEIN* WEYL* 
%  KILLING* GEODESIC* DIV** DIV* SIMPDALAM GETMET GETCON SETMET 
%  SETCON NEWNME
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

GLOBAL '(CURRENTMETRIC CURRENTCONNECTION INDICETEN INAMES);
FLUID '(COORDS);    
GLOBAL '(METRIC CHRISTOFFEL1 CHRISTOFFEL2 RIEMANN RICCI RICCISC EINSTEIN
         WEYL GEODESIC KILLING);

METRIC := 'g;
PUT ('METRIC, 'SIMPFN, 'METRIC!*);

% metric* constructs a metric tensor from the line element provided.
% metrics are assumed to be at least symmetric, and will be given a 
% diagonal symmetry if appropriate.
% if no line-element is given, the metric is made by contracting together
% the frame metric and the tensor-frame connection.
% if an indexed object name is given, that object is made into a metric.

SYMBOLIC PROCEDURE METRIC!* (U);
BEGIN SCALAR LEX, LEX1, DIAG, TNSR2, LNEL, TNSR, DENOM, ELMN;
  LNEL := MYCAR (U);
  IF INDEXED (LNEL) THEN <<
    TNSR := LNEL;
    IF NOT (GET (TNSR, 'CONCOV) = '(-1 -1)) THEN
      MERROR (LIST (TNSR, "does not have metric structure."), 'T, 'METRIC);
    LEX1 := GET (TNSR, 'TVALUE);	% determine if its diagonal
    WHILE (LEX1 AND MYCAAAR (LEX1) = MYCADAAR (LEX1)) DO LEX1 := MYCDR (LEX1);
    IF NOT LEX1 THEN DIAG := 'T		% metric is diagonal
    ELSE DIAG := 'NIL;			% metric is not diagonal
    PUT (TNSR, 'TYPE, 'METRIC)
  >> ELSE IF LNEL THEN <<
    TNSR := NEWNME (MYCADR (U), METRIC);
    LNEL := MK!*SQ SIMP (LNEL);
    MKTNSR!* (TNSR, '(-1 -1), '(((1) 1 2)), 'NIL, 'METRIC);
    LEX := IGEN ('(a!# b!#), '(-1 -1), '(((0) 1 2)));
    WHILE LEX AND NOT (LNEL = 0) DO <<    % first run down the diagonal
      LEX1 := ELMMET (LNEL, MYCAR (LEX));
      LNEL := MK!*SQ ADDSQ (MYCADR (LNEL), NEGSQ (MULTSQ (MYCAR (LEX1),
                   SIMP!* ('TIMES . MYCDR (LEX1)))));   % update line-element
      WRITETNSR (TNSR, MYCAR (LEX), MYCAR (LEX1), 'T);
      LEX := MYCDR (LEX)
    >>;
    IF LNEL = 0 THEN DIAG := 'T     % if nothing left, then metric is diagonal
    ELSE <<
      DIAG := 'NIL;                 % otherwise, look at off-diag elements
      LEX := IGEN ('(a!# b!#), '(-1 -1), '(((-1) 1 2)));
      WHILE LEX AND NOT (LNEL = 0) DO <<
        LEX1 := ELMMET (LNEL, MYCAR (LEX));
        LNEL := MK!*SQ ADDSQ (MYCADR (LNEL), NEGSQ (MULTSQ (MYCAR (LEX1),
                     SIMP!* ('TIMES . MYCDR (LEX1)))));
        WRITETNSR (TNSR, MYCAR (LEX), QUOTSQ (MYCAR (LEX1), 2 . 1), 'T);
        LEX := MYCDR (LEX)
      >>
    >>;
    IF NOT (LNEL = 0) THEN MERROR ('("invalid line element"), 'T, 'METRIC)
  >> ELSE <<		% build metric from frame metric and connection
    TNSR := NEWNME (MYCADR (U), METRIC);
    LEX1 := LIST ('TIMES,
            LIST ('RDR, GETMET (-2), '(c!# d!#)),
            LIST ('RDR, GETCON (1), '(c!# a!#)),
            LIST ('RDR, GETCON (1), '(d!# b!#)));
    MKTNSR!* (TNSR, '(-1 -1), '(((1) 1 2)), 'NIL, 'METRIC);
    EVALTNSR1 (TNSR, '(a!# b!#), LEX1, 'NIL);
    LEX1 := GET (TNSR, 'TVALUE);	% determine if its diagonal
    WHILE (LEX1 AND MYCAAAR (LEX1) = MYCADAAR (LEX1)) DO LEX1 := MYCDR (LEX1);
    IF NOT LEX1 THEN DIAG := 'T		% metric is diagonal
    ELSE DIAG := 'NIL			% metric is not diagonal
  >>;
  IF DIAG THEN PUT (TNSR, 'SYMMETRY, '(((0) 1 2)));	% is diagonal
  TNSR2 := MYCAR (INVERT!* (LIST (TNSR)));	% construct the inverse metric
  PUT (TNSR, '!*AT!*, LIST ('T, TNSR, TNSR2, 'd1));
  PROTECT!* (TNSR, 'W);				% protect
  PROTECT!* (TNSR2, 'W);
  PUT (TNSR, '!#DBR, 0);			% 0 covariant derivative
  IF NOT INDEXED (MYCAR (CURRENTMETRIC)) THEN SETMET (TNSR);
  CLEANER ('METRIC);
  RETURN (TNSR . 1);
END;

PUT ('d, 'SIMPFN, 'SIMPD!*);

% simpd* simplifies coordinate differentials used in building a line element.
% if the u in d(u) is a coordinate name, the unevaled form is returned, 
% otherwise the total derivative is computed.

SYMBOLIC PROCEDURE SIMPD!* (U);
BEGIN SCALAR VAL, LEX, LIS;
  VAL := REVAL (MYCAR (U));
  IF NUMBERP (VAL) THEN RETURN ('NIL . 1)
  ELSE IF MEMQ (VAL, COORDS) OR (NOT ATOM (VAL) AND INDEXED (MYCADR (VAL))) THEN 
                 RETURN (MKSQ (LIST ('d, VAL), 1))    % coord differential
  ELSE <<		% find total derivative of argument to d
    LEX := COORDS;
    WHILE LEX DO <<
      LIS := LIST ('TIMES, 
        LIST ('DF, VAL, MYCAR (LEX)),	% partial derivative wrt a coordinate
        LIST ('d, MYCAR (LEX))) . LIS;	% corresponding differential.
      LEX := MYCDR (LEX)
    >>;
    LIS := REVAL ('PLUS . LIS);
    IF LIS = 0 THEN 		
      MERROR (LIST ("missing differential:", 'd . U), 'NIL, 'd);
    RETURN (SIMP (LIS))
  >>;
END;

% elmmet finds and returns the element of the metric corresponding to index.
% it substitutes 0's and 1's for the d() forms and evals the line-element
% to se whats left. this makes it possible to run this thing on non-expanded
% line-elements (which was not possible before).

SYMBOLIC PROCEDURE ELMMET (LNEL, INDEX);
BEGIN SCALAR LEX, LEX1;
  LEX := FOR EACH X IN COORDS COLLECT LIST ('EQUAL, LIST ('d, X), 
         ISELM (X, INDEX));
  LEX1 := FOR EACH X IN INDEX COLLECT 
              LIST ('d, NTH (COORDS, X - MYCAR (INDICETEN) + 1));
  RETURN (SIMPSUB (APPEND (LEX, LIST (LNEL))) . LEX1);
END;

% iselm returns the 1's and 0's required in elmmet. ie. if crd's tensor index
% is in the index, we get 1 else 0.

SYMBOLIC PROCEDURE ISELM (CRD, INDEX);
  IF MEMQ (LOOK (COORDS, CRD, MYCAR (INDICETEN)), INDEX) THEN 1
  ELSE 0;

CHRISTOFFEL1 := 'C1;
PUT ('CHRISTOFFEL1, 'SIMPFN, 'CHRISTOFFEL1!*);

% christoffel1* computes the Christoffel symbols of the first kind, which
% are symmetric in their first 2 indices.

SYMBOLIC PROCEDURE CHRISTOFFEL1!* (U);
BEGIN SCALAR TNSR, LEX, LEX1;
  TNSR := MYCAR (U);
  LEX1 := GET (GETMET (1), 'CHRISTOFFEL1);	% see if its already been made
  IF NOT TNSR AND INDEXED (LEX1) THEN RETURN (LEX1 . 1);
  TNSR := NEWNME (TNSR, CHRISTOFFEL1);		% get a name for it
  MKTNSR!* (TNSR, '(-1 -1 -1), '(((1) 1 2)), '(), 'CHRISTOFFEL1);
  LEX := LIST ('PLUS,				% defining expression
        LIST ('RDR, GETMET (1), '(a!# c!# !#BR b!#)),
        LIST ('RDR, GETMET (1), '(b!# c!# !#BR a!#)),
                LIST ('MINUS,
        LIST ('RDR, GETMET (1), '(a!# b!# !#BR c!#))
                ));
  EVALTNSR1 (TNSR, '(a!# b!# c!#), LIST ('QUOTIENT, LEX, 2), 'NIL);
  PUT (TNSR, '!*AT!*, '(T));			% no shifts allowed
  PROTECT!* (TNSR, 'W);
  PUT (GETMET (1), 'CHRISTOFFEL1, TNSR);	% store name on metric
  CLEANER ('CHRISTOFFEL1);
  RETURN (TNSR . 1);
END;

CHRISTOFFEL2 := 'C2;
PUT ('CHRISTOFFEL2, 'SIMPFN, 'CHRISTOFFEL2!*);

% christoffel2* computes the Christoffel symbols of the second kind. the
% first index is up and it is symmetric in its second and third indices.

SYMBOLIC PROCEDURE CHRISTOFFEL2!* (U);
BEGIN SCALAR TNSR, LEX1;
  TNSR := MYCAR (U);
  LEX1 := GET (GETMET (1), 'CHRISTOFFEL2);	% see if its been made 
  IF NOT TNSR AND INDEXED (LEX1) THEN RETURN (LEX1 . 1);
  TNSR := NEWNME (TNSR, CHRISTOFFEL2);
  MKTNSR!* (TNSR, '(1 -1 -1), '(((1) 2 3)), '(), 'CHRISTOFFEL2);
  EVALTNSR1 (TNSR, '(a!# b!# c!#), LIST ('TIMES, % defining expression
        LIST ('RDR, GETMET (-1), '(a!# d!#)),
        LIST ('RDR, MYCAR (CHRISTOFFEL1!* ('NIL)), '(b!# c!# d!#))
        ), 'NIL);
  PUT (TNSR, '!*AT!*, '(T));			% no shifts allowed
  PROTECT!* (TNSR, 'W);
  PUT (GETMET (1), 'CHRISTOFFEL2, TNSR);	% store name on metric
  CLEANER ('CHRISTOFFEL2);
  RETURN (TNSR . 1);
END;

RIEMANN := 'RI;
PUT ('RIEMANN, 'SIMPFN, 'RIEMANN!*);

% riemann* computes the fully covariant Riemann curvature tensor.

SYMBOLIC PROCEDURE RIEMANN!* (U);
BEGIN SCALAR TNSR, LEX;
  TNSR := MYCAR (U);
  LEX := GET (GETMET (1), 'RIEMANN);	% see if it exits
  IF NOT TNSR AND INDEXED (LEX) THEN RETURN (LEX . 1);
  TNSR := NEWNME (TNSR, RIEMANN);	% get a name for it
  MKTNSR!* (TNSR, '(-1 -1 -1 -1), '(((-1) 1 2)((-1) 3 4)((2) 1 3)), '(),
                             'RIEMANN);
  LEX := LIST ('PLUS,
        LIST ('RDR, MYCAR (CHRISTOFFEL1!* ('NIL)), '(b!# d!# a!# !#BR c!#)),
           LIST ('MINUS,
        LIST ('RDR, MYCAR (CHRISTOFFEL1!* ('NIL)), '(b!# c!# a!# !#BR d!#))),
           LIST ('TIMES,
        LIST ('RDR, MYCAR (CHRISTOFFEL2!* ('NIL)), '(e!# b!# c!#)),
        LIST ('RDR, MYCAR (CHRISTOFFEL1!* ('NIL)), '(a!# d!# e!#))),
           LIST ('MINUS,
           LIST ('TIMES,
        LIST ('RDR, MYCAR (CHRISTOFFEL2!* ('NIL)), '(e!# b!# d!#)),
        LIST ('RDR, MYCAR (CHRISTOFFEL1!* ('NIL)), '(a!# c!# e!#)))));
  EVALTNSR1 (TNSR, '(a!# b!# c!# d!#), LEX, 'NIL);
  PROTECT!* (TNSR, 'W);
  PUT (GETMET (1), 'RIEMANN, TNSR);	% store name on metric
  IF NOT GET (TNSR, 'TVALUE) THEN <<
    PRIN2 ("** this space is flat");
    TERPRI ()
    >>;
  CLEANER ('RIEMANN);
  RETURN (TNSR . 1);
END;

RICCI := 'RIC;
PUT ('RICCI, 'SIMPFN, 'RICCI!*);

% ricci* computes the fully covariant Ricci tensor.

SYMBOLIC PROCEDURE RICCI!* (U);
BEGIN SCALAR TNSR, LEX;
  TNSR := MYCAR (U);
  LEX := GET (GETMET (1), 'RICCI);	% see if it exists
  IF NOT TNSR AND INDEXED (LEX) THEN RETURN (LEX . 1);
  TNSR := NEWNME (TNSR, RICCI);		% get a name for it
  MKTNSR!* (TNSR, '(-1 -1), '(((1) 1 2)), '(), 'RICCI);
  EVALTNSR1 (TNSR, '(a!# b!#), LIST ('TIMES,
        LIST ('RDR, GETMET (-1), '(c!# d!#)),
        LIST ('RDR, MYCAR (RIEMANN!* ('NIL)), '(c!# a!# b!# d!#))), 'NIL);
  PROTECT!* (TNSR, 'W);
  IF NOT GET (TNSR, 'TVALUE) THEN <<
    PRIN2 ("** this metric is a vacuum solution.");
    TERPRI ()
    >>;
  PUT (GETMET (1), 'RICCI, TNSR);	% store name on metric
  CLEANER ('RICCI);
  RETURN (TNSR . 1);
END;

RICCISC := 'RICSC;
PUT ('RICCISC, 'SIMPFN, 'RICCISC!*!*);

% riccisc** sets up the call to riccisc*. 

SYMBOLIC PROCEDURE RICCISC!*!* (U);
  RICCISC!* (MYCAR (U), MYCADR (U));

% riccisc* computes the Ricci scalar.

SYMBOLIC PROCEDURE RICCISC!* (U, V);
BEGIN SCALAR EX1, LEX;
  IF (LEX := RESIMPSCALAR (V, MYCAR (RICCI!* ('NIL)), 'RICCISC))
    THEN RETURN (LEX);
  EX1 := NEWNME (MYCAR (U), RICCISC);		% get a name to put it in
%  PUT (EX1, 'SIMPFN, 'MKRDR);
%  FLAG (LIST (EX1), 'FULL);
%  PUT (EX1, 'INDEXED, 'SCALAR);	% make it scalar
%  PUT (EX1, 'INDICES, '(0));
%  INAMES := EX1 . INAMES;
  LEX := EVALTNSR1 (EX1, 'NIL, LIST ('TIMES,
        LIST ('RDR, GETMET (-1), '(a!# b!#)),
        LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(a!# b!#))), 'NIL);
  CLEANER ('RICCISC);
  PUT (MYCAR (RICCI!* ('NIL)), 'RICCISC, LEX);	% store value on ricci tensor
  RETURN (MYCADR (SETK (EX1, LIST ('!*SQ, LEX, 'T)))); % mk!*sq DOES NOT WORK here (i.e 0 is messed up)
END;

EINSTEIN := 'EI;
PUT ('EINSTEIN, 'SIMPFN, 'EINSTEIN!*);

% einstein* computes the fully covariant Einstein tensor.

SYMBOLIC PROCEDURE EINSTEIN!* (U);
BEGIN SCALAR TNSR, LEX;
  TNSR := MYCAR (U);
  LEX := GET (GETMET (1), 'EINSTEIN);		% see if it exits
  IF NOT TNSR AND INDEXED (LEX) THEN RETURN (LEX . 1);
  TNSR := NEWNME (TNSR, EINSTEIN);		% get a name for it
  MKTNSR!* (TNSR, '(-1 -1), '(((1) 1 2)), '(), 'EINSTEIN);
  EVALTNSR1 (TNSR, '(a!# b!#), LIST ('PLUS,
        LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(a!# b!#)),
        LIST ('MINUS, LIST ('TIMES, MK!*SQ (QUOTSQ (RICCISC!* ('NIL, 'NIL),
				 2 . 1)),
        LIST ('RDR, GETMET (1), '(a!# b!#))))), 'NIL);
  PROTECT!* (TNSR, 'W);
  PUT (GETMET (1), 'EINSTEIN, TNSR);		% store name on metric
  CLEANER ('EINSTEIN);
  RETURN (TNSR . 1);
END;

WEYL := 'C;
PUT ('WEYL, 'SIMPFN, 'WEYL!*);

% weyl* computes the fully covariant Weyl conformal curvature tensor.

SYMBOLIC PROCEDURE WEYL!* (U);
BEGIN SCALAR TNSR, LEX, LEX1, LEX2;
  LEX := GET (GETMET (1), 'WEYL);	% see if it exists
  IF NOT TNSR AND INDEXED (LEX) THEN RETURN (LEX . 1);
  LEX := MYCADR (INDICETEN) - MYCAR (INDICETEN) + 1;
  LEX2 := LEX - 2;
  LEX1 := (LEX - 1) * LEX2;
  TNSR := MYCAR (U);
  TNSR := NEWNME (TNSR, WEYL);		% get a name for it
  LEX1 := MK!*SQ (QUOTSQ (RICCISC!* ('NIL, 'NIL), LEX1 . 1));
  LEX := LIST ('PLUS,
        LIST ('RDR, MYCAR (RIEMANN!* ('NIL)), '(a!# b!# c!# d!#)),
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (1), '(a!# c!#)),
     LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(b!# d!#))), LEX2),
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (1), '(b!# d!#)),
     LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(a!# c!#))), LEX2),
      LIST ('MINUS,
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (1), '(b!# c!#)),
     LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(a!# d!#))), LEX2)),
      LIST ('MINUS,
     LIST ('QUOTIENT, LIST ('TIMES, LIST ('RDR, GETMET (1), '(a!# d!#)),
     LIST ('RDR, MYCAR (RICCI!* ('NIL)), '(b!# c!#))), LEX2)),
      LIST ('MINUS,
     LIST ('TIMES, LIST ('RDR, GETMET (1), '(a!# c!#)),
                   LIST ('RDR, GETMET (1), '(b!# d!#)),
        LEX1)),
     LIST ('TIMES, LIST ('RDR, GETMET (1), '(a!# d!#)),
                   LIST ('RDR, GETMET (1), '(b!# c!#)),
        LEX1));
  MKTNSR!* (TNSR, '(-1 -1 -1 -1), '(((-1) 1 2)((-1) 3 4)((2) 1 3)), '(),
                   'WEYL);
  EVALTNSR1 (TNSR, '(a!# b!# c!# d!#), LEX, 'NIL);
  PROTECT!* (TNSR, 'W);
  PUT (GETMET (1), 'WEYL, TNSR);	% put name on metric
  IF NOT GET (TNSR, 'TVALUE) THEN <<
    PRIN2 ("** this space is conformally flat");
    TERPRI ()
  >>;
  CLEANER ('WEYL);
  RETURN (TNSR . 1);
END;

KILLING := 'k;		% default name for killing vector
PUT ('KILLING, 'SIMPFN, 'KILLING!*);

% killing* computes either the Killing equations or the conformal Killing
% equations depending on whether the second argument is 'nil or 't.
% the first argument is the name of the matrix that will be created to
% hold the equations.

SYMBOLIC PROCEDURE KILLING!* (U);
BEGIN SCALAR TNSR, CONF, LEX;
  TNSR := MYCAR (U);		% matrix name
  CONF := MYCADR (U);		% conformal flag
  TNSR := GETNME (TNSR, 'KILLING);
  IF NOT (INDEXED (KILLING) AND GET (KILLING, 'TYPE) EQ 
         'KILLINGVEC) THEN	% make the killing vector (its implicit)
    MKTNSR!* (KILLING, '(-1), '(), KILLING, 'KILLINGVEC);
  PUT (TNSR, 'SYMMETRY, '(((1) 1 2)));
  IF NOT CONF THEN CONF := 0
  ELSE CONF := MK!*SQ (DIV!* (KILLING, 'NIL));	% determine conformal factor

  EVALTNSR1 (TNSR, '(a!# b!#), LIST ('PLUS,
        LIST ('RDR, KILLING, '(a!# !#BR b!#)),
        LIST ('RDR, KILLING, '(b!# !#BR a!#)),
        LIST ('TIMES, -2,
                LIST ('RDR, MYCAR (CHRISTOFFEL2!* ('NIL)), '(z!# a!# b!#)),
                LIST ('RDR, KILLING, '(z!#))),
        LIST ('TIMES, -2, CONF, LIST ('RDR, GETMET (1), 
                             '(a!# b!#)))), 'NIL);
  PUT (TNSR, 'TYPE, IF NOT (CONF = 0) THEN 'CKILLING ELSE 'KILLING);
  PUT (TNSR, 'INDEXED, 'MATRIX);
  CLEANER ('KILLING);
  RETURN (TNSR . 1);
END;

GEODESIC := 's;		% default name for affine parameter
PUT ('GEODESIC, 'SIMPFN, 'GEODESIC!*);

% geodesic* computes the geodesic equations. first arg is a name for
% a matrix to put them in, optional second arg is a name for the
% affine parameter.

SYMBOLIC PROCEDURE GEODESIC!* (U);
BEGIN SCALAR TNSR, PARAM, LEX, LEX1;
  TNSR := MYCAR (U);
  PARAM := MYCADR (U) OR GEODESIC;	% affine parameter
  TNSR := GETNME (TNSR, 'GEODESIC);
  FOR EACH X IN COORDS DO DEPEND1 (X, PARAM, 'T);
  LEX := MKCOORDS (TMPNAMES (), 'NIL);
  LEX1 := LIST ('PLUS,
        LIST ('DF, LIST ('RDR, LEX, '(a!#)), PARAM, PARAM),
        LIST ('TIMES,
        LIST ('RDR, MYCAR (CHRISTOFFEL2!* ('NIL)), '(a!# b!# c!#)),
        LIST ('DF, LIST ('RDR, LEX, '(b!#)), PARAM),
        LIST ('DF, LIST ('RDR, LEX, '(c!#)), PARAM)));
  EVALTNSR1 (TNSR, '(a!#), LEX1, 'NIL);
  PUT (TNSR, 'TYPE, 'GEODESIC);
  PUT (TNSR, 'INDEXED, 'MATRIX);
  CLEANER ('GEODESIC);
  RETURN (TNSR . 1);
END;

PUT ('DIV, 'SIMPFN, 'DIV!*!*);

% div** sets up the call to div*

SYMBOLIC PROCEDURE DIV!*!* (U);
  DIV!* (MYCAR (U), MYCADR (U));

% div* computes the divergence of the given vector. the scalar value is
% returned. the value is also placed on the vectors' property list for
% easy recall.

SYMBOLIC PROCEDURE DIV!* (TNSR, V);
BEGIN SCALAR LEX, LEX1, LEX2;
  TNSR := GETNME (REVAL (TNSR), 'DIV);
  IF NOT MYCAR (GET (TNSR, 'INDICES)) = 1 THEN <<
    MERROR ('("DIV requires vector"), 'NIL, 'DIV);
    RETURN ('NIL . 1)
  >> ELSE IF MYCAR (GET (TNSR, 'CONCOV)) < 0 THEN	% shift index up
    TNSR := MYCADR (SHIFT!* (LIST ('RDR, TNSR, '((!*AT!* a!#))), 'NIL));
  IF (LEX := RESIMPSCALAR (V, TNSR, 'DIV)) THEN RETURN (LEX);
  LEX := REVAL (MK!*SQ (DET!* (LIST (GETMET (1)))));	% determinant of metric
  IF MYCAR (LEX) EQ 'MINUS THEN LEX := MYCADR (LEX);	% make it positive
  LEX := REVAL (LIST ('SQRT, LEX));
  LEX := LIST ('QUOTIENT, LIST ('PDF, LIST ('TIMES, LEX,
                LIST ('RDR, TNSR, '(a!#))), '(FINDEX NIL a!#)), LEX);
  LEX := EVALTNSR1 ('LEX2, 'NIL, LEX, 'NIL);
  PUT (TNSR, 'DIV, LEX);	% store value on vector
  CLEANER ('DIV);
  RETURN (LEX);
END;

PUT ('DALAMBERT, 'SIMPFN, 'SIMPDALAM);

SYMBOLIC PROCEDURE SIMPDALAM (U);
BEGIN SCALAR LEX;
  U := REVAL (MYCAR (U));
  LEX := LIST ('QUOTIENT, LIST ('MINUS, LIST ('PDF, LIST ('TIMES,
        LIST ('SQRT, LIST ('MINUS, LIST ('DET, GETMET (1)))),
        LIST ('RDR, GETMET (-1), '(a!# b!#)), LIST ('PDF, U,
        '(INDEX (SYMLST) a!#))), '(INDEX (SYMLST) b!#))),
         LIST ('SQRT, LIST ('MINUS, LIST ('DET, GETMET (1)))));
  LEX := EVALTNSR1 ('LEX, 'NIL, LEX, 'NIL);
  CLEANER ('DALAMBERT);
  RETURN (LEX);
END;

FLAG ('(GETMET), 'OPFN);		% user and lisp callable

% getmet looks for the metric of type n in currentmetric, or its inverse
% if n < 0.

SYMBOLIC PROCEDURE GETMET (N);
BEGIN SCALAR LEX;
  IF N < 0 THEN <<
    IF NOT INDEXED (LEX := MAKENAME (APPEND (EXPLODE (GETMET (ABS (N))),
      '(!# I N V)))) THEN
    MERROR (LIST ("missing inverse:", LEX), 'T, 'GETMET);
    RETURN (LEX)
  >>
  ELSE IF NOT INDEXED (LEX := NTH (CURRENTMETRIC, N)) THEN
    MERROR (LIST ("metric does not exist:", N), 'T, 'GETMET)
  ELSE RETURN (LEX);
END;

FLAG ('(GETCON), 'OPFN);

% getcon returns the connection of type n from currentconnection.

SYMBOLIC PROCEDURE GETCON (N);
BEGIN SCALAR LEX;
  IF NOT INDEXED (LEX := NTH (CURRENTCONNECTION, N)) THEN
    MERROR (LIST ("connection does not exist:", N), 'T, 'GETCON)
  ELSE RETURN (LEX);
END;

FLAG ('(SETMET), 'OPFN);

% setmet causes the named metric to be placed in the proper location
% in currentmetric. the object must have 2 covariant indices and be
% type metric.

SYMBOLIC PROCEDURE SETMET (TNSR);
BEGIN SCALAR LEX;
  TNSR := GETNME (TNSR, 'SETMET);
  IF NOT GET (TNSR, 'TYPE) EQ 'METRIC OR
     (LEX := MYCAR (GET (TNSR, 'CONCOV))) > 0 THEN
    MERROR (LIST ("bad metric:", TNSR), 'T, 'SETMET);
  CURRENTMETRIC := INSERT (CURRENTMETRIC, TNSR, -LEX, 'T);
  RETURN (TNSR);
END;

FLAG ('(SETCON), 'OPFN);

% setcon places the named connection in the currentconnection list at
% location n. the object must be of type connection. the locations are
% as follows:
% 1 -- tensor - frame connection
% 2 -- tensor - spinor connection
% 3 -- frame - spinor connection.

SYMBOLIC PROCEDURE SETCON (CONN, N);
BEGIN;
  CONN := GETNME (CONN, 'SETCON);
  IF NOT GET (CONN, 'TYPE) EQ 'CONNECTION OR
     MYCAR (GET (CONN, 'CONCOV)) > 0 THEN
    MERROR (LIST ("bad connection:", CONN), 'T, 'SETCON);
  CURRENTCONNECTION := INSERT (CURRENTCONNECTION, CONN, N, 'T);
  RETURN (CONN);
END;

% newnme generates the default name if none was given and prints
% the "computing <name>" message.

SYMBOLIC PROCEDURE NEWNME (TNSR, EX);
BEGIN;
  IF TNSR THEN RETURN (TNSR);	% name was given (dont get a message)
  TNSR := EX;
  WRITE ("computing ", TNSR);	% so user knows what the name will be
  TERPRI();
  IF INDEXED (TNSR) THEN	% trying to overwrite, user must rem it.
    MERROR (LIST (TNSR, "is already defined."), 'T, 'NEWNME);
  RETURN (TNSR);
END;

;END;
