.so include.n
.po
.he ``muTENSOR Reference Manual``
.bp
.ls 2
.sp 2
.nh        \" no hyphenation
.br
.pp
This reference manual provides a brief introduction to the muTENSOR algebra
system. It is presumed that the user has an understanding of both the
muMATH computer algebra package and of tensor algebra in general.
While not exhaustive, this manual provides the basic information required
to use muTENSOR. Throughout this manual values of variables are enclosed 
in angle brackets (<>),
optional parameters are enclosed in braces ({}), and default values are
enclosed in square brackets ([]).
.sp 1
.sp 1
.ne 5
.sh 1 
\*BIndexed Objects\fP
.sp 3
.pp
The basic entity of muTENSOR is the indexed object. Such an object consists
of a set of values associated with various indices, and a set of properties
which describe the object. An element of the object may accessed by enclosing
the index of the element in square brackets ([]) following the objects' name:
.ce
R[1,2,1,2]; G[0,1]; g[2,3];
.br
Note that these operations are simply a retrieval of a value, no
substitution or other evaluation takes place; to force this, wrap an
EVAL around the reference, eg. EVAL (R[1,2,1,2]).
Assigning a specific element is done in a similar fashion, the element
reference is followed by the indexed object assignment operator `::' or `==' and
the desired value:
.ce
R[1,2,1,2] :: a + b;
.br
This use of the assignment operation is a special case of a more general
operation described below.
.pp
Before an indexed object can be used it must be created with a call to
\*BMKTNSR\fP. This has the form:
.ce
MKTNSR (name, {concov}, {symmetry}, {implicit}, {type});
.pp
where <name> is the name which the object will have in the system.
If <name> is an indexed object
it is deleted if that is possible. If <name> has a value, then <name> must
be quoted when passed to 
\*BMKTNSR\fP. Note that the system will automatically set the value of
<name> to <name>, removing any previous value.
.pp
<concov> describes the index structure of the object. It is a list of
integers; the length of the list determines the rank of the object. Each
integer may be one of 1, 2, 3, 4, or 5 according as whether the corresponding
index is a tensor, frame, spinor, dotted-spinor, or matrix index. If the
integer is positive, the index is contravariant; if negative the index is
covariant.
.pp
<symmetry> describes the intrinsic symmetries of the object. This is
a list of independent symmetry lists of the form: 
.sp 1
.ne 5 
.ce
(({C,} l, p\*D\s-21\s0\*U, p\*D\s-22\s0\*U, p\*D\s-23\s0\*U, ...), ... {(H, p\*D\s-21\s0\*U, p\*D\s-22\s0\*U, ...)})
.sp 1
.ne 5 
.pp
In each independent symmetry list <l> is the size of the
blocks involved in the symmetry, if <l> is negative then an anti-symmetry
is implied. If <l> is 0, then a trace symmetry is implied but the block
size is 1. The locations of each block in the index are given by the
pointers p\*D\s-2i\s0\*U. If the letter `C' is prepended to the list, it indicates that
a complex conjugate is to be taken when permuting the index. The form
beginning with the letter `H' specifies a Hermitian symmetry. In this case,
the pointers p\*D\s-2i\s0\*U must point to spinor dotted-spinor blocks within the
<concov> list of <name>. If no pointers are given with the H form, the
system constructs a Hermitian symmetry for the object.
.pp
An example of a symmetry list describing
the Riemann symmetry is '((\-1,1,2),(\-1,3,4),(2,1,3)). This may be read as
"anti-symmetric in the first two indices, anti-symmetric in the third
and fourth indices, and symmetric in pairs of indices beginning at the first
and third index". Note that the internal form of the symmetry list
is somewhat different than that described above.
.pp
A related function is \*BMKSCALAR\*fp, which creates an indexed scalar
object from its input. This object is formally like any other indexed
object, but must always be used with an empty index, or one which
indicates a derivative. The previous value of the object in this case
is not lost, but is moved from the usual muSIMP value cell to the
\*BTVALUE\fp of the object, and restored when \*BREM\fp deletes the object.
.pp
When an object with a formal index is encountered by the system, the
index is permuted into a canonical form as indicated by the intrinsic
symmetries. This ensures, for example, that object references will
cancel out if the indices are permuted and an anti-symmetry is involved.
For example, if T is anti-symmetric (see examples below) then
.in 3
.nf
? T[a,b];
@: T\*Da b\*U
? T[b,a];
@: \-T\*Da b\*U
? T[a,b] + T[b,a];
@: 0
.fi
.in 0
.br
.pp
There are two types of values associated with an indexed object,
those which are explicit and those which are implicit. An explicit value
is one that is assigned with the use of the `::' operator (or 
\*BIAS\fP).
An implicit value
is created when <implicit> is either <name> or an integer. Any reference
to an element which is not explicitly defined and which is not identically
zero by virtue of the intrinsic symmetries of the object is returned as
an implicit value. This can be used to create objects whose form is known
but whose actual elements are unknown. An implicit object has a `+' placed
after the number of elements field in a directory listing. When <implicit>
is <name>, <name> is made to depend on the current coordinates.
.pp
The <type> parameter is provided for the user's convenience to identify
an object.
.pp
When an object is created it is given two characteristics that are
determined by the values of global system variables. Each object is
defined in a particular set of coordinates, as given by the 
\*BCOORDS\fP variable.
Additionally, the runs of various types of indices are given by the
variables 
\*BINDICETEN\fP, 
\*BINDICESP\fP, and 
\*BINDICEMAT\fP.
.pp
Following are examples of the creation of indexed objects.
.nf
.sp 1
.in 3
.(b M
.ls 2
% T is an anti-symmetric, covariant tensor %
? MKTNSR ('T, '(\-1 \-1), '((\-1 1 2)));   
@: T\*Da b\*U
? T[1,1] :: a + b; 
@: 0        % cannot write something to the diagonal %
? T[1,2] :: c;
@: c
? T[2,1];	% sign change with permutation %
@: \-c
.)b
.(b M
.ls 2
% U is an implicit, covariant tensor %
? MKTNSR ('U, '(\-1 \-1), '(), 'U);
@: U\*Da b\*U
% there is no explicit value, returns an implicit value %
? U[1,2];
@: U\*D1 2\*U
? U[1,2] :: d;  % write an explicit value %
@: d;
? U[1,2];
@: d
.)b
.in 0
.fi
.pp
There are two ways to examine the contents of an indexed object. To
see only the explicit elements an empty index may be used in an object
reference (eg. T[]); or a formal index may be used, with a `?' appended
as an extra index (eg. T[a,b,?]). This form displays all elements of the
object, including implicit values or those elements whose values are 0.
Each of these display forms also shows some of the properties of the
object.
To get an overview of the numbers and types of indexed objects currently
in the system, the function 
\*BDIR\fP is provided.
.sp 1
.ne 5
.sp 3
.sh 1
\*BIndexed Algebra\fP
.pp
muTENSOR is designed to handle the short-hand notations of tensor algebra.
In particular, algebraic operations are partially indicated by the formal
indices of the objects involved in an expression. Repeated indices in
covariant and contravariant positions within a single index or among the
terms in a product denote an Einstein summation. The number and names of
free indices on each side of the assignment operator must agree, unless
the right hand side is a scalar, in which case the entire object is assigned
with that value.
For example, to copy the object U to the object T, the command is:
.ce
T[a,b] :: U[a,b];
whereas to copy the transpose of U:
.ce
T[a,b] :: U[b,a];
.br
As each element is copied, its index is printed. 
.pp
When the object to the left of the `::' has been previously created by the
user, the index structure of the left and right hand sides must agree.
If the user
has not created the object, it will be given the index structure of the
right hand side. In cases where portions of the index structure cannot
be determined, those portions are given covariant tensor indices. For
example, the command
.ce
F[a,b]\ ::\ a;
.br
creates F as a rank 2 covariant tensor, and, additionally 
assigns every element of F the value a. Note that there is no conflict
between the value `a' and the index `a'.
.pp
If the left hand side is a simple scalar value, the right hand side
must of course contract to a scalar or be a scalar. In a special case
mentioned above, the left hand side can be a reference to a specific element
of an indexed object.
.pp
When the symmetries of the left hand object are known, they may be given
to the object without fully creating it by calling 
\*BMKTNSR\fP with
a FALSE concov parameter. This will significantly reduce the evaluation
time of the assignment, since only the independent elements of the
output object will be considered. It is imperative that the symmetries correctly
represent the right hand expression.
.pp
When evaluating a summation involving objects with trace symmetries, the
system takes advantage of the symmetry and converts the sum to a single
product. This conversion is hidden from the user and affects only the
internal parsed form of the expression being evaluated. There is a
considerable performance gain when this is done. Any object known
to be diagonal should be given a diagonal symmetry to take advantage of
this.
.sp 1
.ne 5
.sp 3
.sh 1
\*BIndex Operators\fP
.pp
There are three operations which are indicated by placing the appropriate
symbols in the index of an object: symmetrization, raising and lowering
indices, and derivatives. 
.sp 3
.sh 2
\*BSymmetrization\fP
.pp
A symmetrization operation is indicated by enclosing the desired indices
within square brackets ([]), an anti-symmetrization is indicated with
braces ({}). The evaluation of the operation occurs as soon as it is
encountered by the parser, unless another operation is pending.
For example,
.nf
.in 3
.(b M
.ls 2
? T[[a,b]];
@: (T\*Da b\*U + T\*Db a\*U) / 2
? T[{a,b}];
@: (T\*Da b\*U \- T\*Db a\*U) / 2
.)b
.fi
.in 0
.br
.pp
At most four indices can be symmetrized in one operation. Bach brackets
are indicated by placing `#' symbols in the index. Indices between these 
symbols or between one and the end of the index are not affected by an
enclosing symmetrization operation. If the `#' symbols are outside a
symmetrization operation, they then act as ordinary indices.
For example,
.nf
.in 3
.(b M
.ls 2
? Y[[a,#,b,#,c]]
@: (Y\*Da b c\*U + Y\*Dc b a\*U) / 2
? Y[{a,#,b,#,c}]
@: (Y\*Da b c\*U \- Y\*Dc b a\*U) / 2
.)b
.fi
.in 0
.br
.sp 3
.sh 2
\*BShifting Indices\fP
.pp
Raising and lowering indices is accomplished with the use of the
shift operator `^'. There must also be a metric defined for the type
of the index being shifted (i.e if a tensor index is being raised, there
must exist a tensor metric); metrics are discussed below. The shift operator
is placed directly before any index the user wishes to raise or lower.
If the index is currently covariant it will become contravariant and
vice versa. 
.pp
The shift operation causes a new indexed object to be created in the system,
with a name based on the parent objects' name and a suffix which describes
the way in which the parent object was shifted to produce the offspring.
The suffix consists of a `#' symbol and another letter. The print name
of the new object will be the same as the parents. These objects form
a family for which the system keeps track of the relations between the
members. The shift operation can be done at any time by calling the
function \*BSHIFT\fP on the object with the appropriately shifted
formal index. For example,
.nf
.in 3
.(b M
.ls 2
? SHIFT (T[^a, ^b]);
computing T#D
@: T\*Ua b\*D
.)b
.in 0
.fi
.sp 3
.sh 2
\*BDifferentiation\fP
.pp
Differentiation is indicated by placing a `|' for ordinary differentiation
or a `||' for covariant differentiation after the objects' formal index
and followed by one or more derivative indices. As with shift operations,
evaluation of derivative operations is delayed until the object takes
part in an assignment operation. Unlike shift operations, however, one
cannot read out a specific element of the derivative of an object
using these operators.
.pp
Ordinary derivative operations may or may not create temporary objects,
depending on whether such will be faster or not, no permanent object is
created. The differentiation is done with respect to the coordinate names
in the order in which they appear in the 
\*BCOORDS\fP list. Although properly
not tensor indices, derivative indices are treated as such by the system.
To perform a differentiation with respect to a variable which is not one of the
coordinates, the `|' notation cannot be used; rather, use the muMATH DIF
function. 
.pp
Covariant differentiation always creates a permanent object with a name
of the form <name>#CD. This operation requires the existence of Christoffel
symbols for each type of index in the concov list of the object, if they do
not exist, they will be created. A covariant
derivative can be computed at any time by calling the function 
\*BCOV\fP with the name of the object.
.sp 1
.ne 5
.sp 3
.sh 1
\*BGeneral Relativity\fP
.br
.pp
There are a number of functions provided in muTENSOR to compute the
objects of interest in General Relativity calculations. Beginning with
a line-element, one can compute the metric, Christoffel symbols, Riemann
curvature tensor, Ricci tensor and scalar, Weyl conformal curvature tensor,
and Einstein tensor. Other functions compute things such as Killing equations
and Lie derivatives.
.pp
To use the General Relativity package one must first create a line-element.
This is a muMATH expression of the form:
.ti 0.5i
name: g\*D\s-20\ 0\s0\*U\ \"hard space at the end
\*Bd\fP
(x\*D\s-20\s0\*U)^2\ +\ g\*D\s-20\ 1\s0\*U\ 
\*Bd\fP
(x\*D\s-20\s0\*U)\ 
\*Bd\fP
(x\*D\s-21\s0\*U) + ...
.br
where the g\*D\s-2i\ j\s0\*U are the components of the metric tensor. The arguments
to the function 
\*Bd\fP
are usually coordinate names, if they are not,
\*Bd\fP
computes the total derivative of the argument.
.pp
The line-element above is converted into a metric tensor by calling
\*BMETRIC\fP. This function sets up all the properties required
for a metric, and determines the proper symmetry (either simply symmetric or
diagonal). The object created has <\*BMETRIC\fP> as its name; 
\*BMETRIC\fP
also computes the metric inverse, which has the name <
\*BMETRIC\fP>#INV. Before
computing the objects listed below it is wise to examine the reciprocal of the
determinant of
the metric, which is stored on the 
\*BMULTIPLIER\fP
property of the
inverse (unless the metric is diagonal). It is best if it is not a sum,
substituting another symbol (using 
\*BMULTIPLIER\fP) for it
is often helpful. When this is done the determinant should be combined with
the inverse using \*BMAPFI\fP.
.pp
Most 
of the GR functions place the name of the object they create on the property
list of the metric, so that they can retrieve the name object without having
to recompute it. Any function which requires another object that does
not exist will cause the system to compute it, except for the metric,
which must be computed from the line-element by the user. Each function
creates its object with the proper symmetries and 
\*BTYPE\fP parameter; the
name of the object will be the value of the function name, or the argument
to the function.
.pp
Christoffel symbols are computed by calling the functions 
\*BCHRISTOFFEL1\fP and 
\*BCHRISTOFFEL2\fP. The Riemann curvature tensor is computed by the
function 
\*BRIEMANN\fP; the Ricci tensor is computed by 
\*BRICCI\fP and the Ricci scalar is computed by 
\*BRICCISC\fP. This last object is a scalar
whose name is [\*BRICSC\fP], another copy is placed on the property
list of the Ricci tensor. This is the copy the system will use in the future,
it can be accessed via 
\*BRICCISC\fP with a FALSE first argument. If the
second argument is non-FALSE and not TRUE, that value replaces the Ricci
scalar; if the second argument is TRUE, the Ricci scalar is re-EVAL'ed.
\*BRICCISC\fP
with no arguments returns the Ricci scalar if it exits, and
computes it if it does not.
.pp
The Weyl tensor is computed with the function 
\*BWEYL\fP and the Einstein tensor is computed with 
\*BEINSTEIN\fP. Other functions of interest are
\*BDIV\fP, which computes the divergence of a vector and 
\*BGEODESIC\fP
which computes the geodesic equations. This function requires a name for
its first argument which is the `matrix' where the equations will be placed.
The second argument, if present, specifies the affine parameter [s]. 
.pp
\*BKILLING\fP
will compute the conformal Killing equations if the second
argument is non-FALSE or the ordinary Killing equations if it is. The first
argument is the name of the object where the equations will be placed, it has
two matrix indices.
Lie derivatives are computed with the function 
\*BLIE\fP, which requires
the name of the object whose derivative is being computed and the name of
a vector defining the direction of the derivative. The output is in the
object <name><vector>#LIE.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BFrames and Spinors\fP
.pp
In muTENSOR there is a distinction between tensor, frame and spinor indices.
Objects with frame indices are very similar to tensors; a frame package is
available in REDTEN, but has not yet been written for muTENSOR.
.pp
Spinors in muTENSOR can have more structure than ordinary tensors. A spinor
can be Hermitian, have a conjugate symmetry, or an ordinary symmetry. Since
most spinors involve complex quantities, a package of complex algebra routines
has been added to muTENSOR (see Additional Algebra Routines below).
Furthermore, when a spinor object is created, a conjugate object is also
created with the name <name>#CNJ. This object has the index structure inverted,
each spinor index has become a dotted spinor index, and each dotted spinor
index has become a spinor index. The elements of this object are the conjugates
of those in the original, although no elements are stored for this object.
Applying 
\*BCONJ\fP
to either object results in a reference to the other.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BMatrices\fP
.pp
A `matrix' in muTENSOR can be one of two things: an object with matrix
indices (not necessarily of rank-2), or any rank-2 object, regardless of
the type of its indices. We will be concerned with the second definition
here; the matrix routines in muTENSOR operate on any rank-2 object. 
.pp
\*BDET\fP
computes the determinant of its argument using the cofactor
method. The result is stored on the property list of the object and
can be altered by calling 
\*BDET\fP
with a non-FALSE second argument.
\*BCOFACTOR\fP computes the cofactor matrix of its first argument, placing
the result in its second argument. 
\*BDETERM\fP will compute the determinant
of its first argument, given the cofactor matrix as its second argument.
.pp
\*BINVERT\fP computes the matrix inverse of its argument, the result
is placed in the object <name>#INV. The determinant of the object is
stored on the 
\*BMULTIPLIER\fP property of the inverse. It can be
accessed using 
\*BMULTIPLIER\fP and should be combined with the object
using 
\*BMAPFI\fP as soon as possible. The inverse object has its
indices shifted relative to the given object.
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BVirtual Memory\fP
.br
.pp
Usually, there is sufficient memory available to handle all the calculations
a user may wish to do. Occasionally, when the intermediate results are very
large, muSIMP cannot continue the calculation because it has no free work
space left. To get around this difficulty, a virtual memory system is
available in muTENSOR. The system makes use of a disk file to store
the elements of indexed objects; when an element is needed, the system
jumps into the file and reads out the value.
.pp
The default file used for the virtual memory system is the string value of the
variable  \*BOFFLOADFILE\fP
[\*BOFFLOAD.MEM\fP]. If the user sets the flag 
\*BUSEDISK\fP
(using
\*BON\fP), then any newly created object will have its explicit elements stored
in the default file. All future writes to the object will go to this file
regardless of the current setting of 
\*BUSEDISK\fP. Metrics and coordinate
vectors are never moved onto disk, they always reside in muTENSOR.
Objects out on the disk are indicated by a `\(**' after the number of elements
in a directory listing.
.pp
Objects may be moved on and off the disk with the functions
\*BOFFLOAD\fP and  \*BONLOAD\fP, independent of the setting of
\*BUSEDISK\fP.  They may be offloaded into other files than the
default by giving a file name to 
\*BOFFLOAD\fP.  Objects may be
transferred from one file to another via the function 
\*BTRANSFER\fP.
If the system crashes with objects out on disk, they can be recovered by
calling 
\*BRECOVER\fP.  Unless sufficient 
\*BUPDATE\fP's have been
done, not all of the properties existing on the objects at the time of
the crash will be recovered.  This is not a recommended way of saving
objects between muTENSOR sessions, use 
\*BSAVEI\fP and
\*BTRANSFER\fP the offloaded elements to another file if they are
currently in the default file. 
.pp
Note that the virtual memory system does not create a new offload file
each time the system runs, rather it appends to an already existing one if
it exists, otherwise it creates a new one.
Unless deleted periodically, this file will continue to fill with
left-over results.  To clean up virtual memory files, 
\*BGARB\fP will
compactify the file and return the reclaimed portions to the operating
system. 
.br
.sp 1
.ne 5
.sp 3
.sh 1
\*BUtilities and Other Functions\fP
.br
.pp
There are a number of utilities provided in muTENSOR to help the user
manage the system. A brief description of these functions is given below,
for more complete information about each, see the function directory
in appendix B.
.in 1i
.ti 0
\*BBACKUP\fP
- retrieve the n'th previous expression, for n \(<\(eq 5.
.br
.ti 0
\*BCLEARTMP\fP
- delete temporary objects and reset system variables.
.br
.ti 0
\*BCOPY\fP
- copy an object.
.br
.ti 0
\*BDATE\fP
- get time and date.
.br
.ti 0
\*BDIR\fP
- directory of all objects in the system, and vital statistics on each.
.br
.ti 0
\*BHELP\fP
- online help function. 
.br
.ti 0
\*BIAS\fP
- assign elements to an entire object.
.br
.ti 0
\*BMAPFI\fP
- map a function onto an object.
.br
.ti 0
\*BMKSCALAR\fP
- declare a `scalar' object which may have an index; the index
must indicate a derivative operation. The value of the object is
accessed with an empty index in a manner similar to other indexed objects.
.br
.ti 0
\*BMULTIPLIER\fP
- access or replace an objects' multiplier value.
.br
.ti 0
\*BNODIR\fP
- hide objects from the directory listing.
.br
.ti 0
\*BOFF\fP
- turn a muTENSOR switch off.
.br
.ti 0
\*BON\fP
- turn a muTENSOR switch on.
.br
.ti 0
\*BREM\fP
- delete indexed objects from the system.
.br
.ti 0
\*BSAVEC\fP
- save the components of objects on disk.
.br
.ti 0
\*BSAVEI\fP
- save indexed objects on disk.
.br
.in 0i
.sp 1
.ne 5
.sp 3
.sh 1
\*BAdvanced Algebra Routines\fP
.pp
muTENSOR includes a number of new algebra routines which extend those
already present in muMATH. These include complex operators, extended
differentiation routines and 
\*BLET\fP rules.
.sp 3
.sh 2
\*BComplex Functions\fP
.pp
In muMATH sqrt(\-1) has the name #I. The function 
\*BCONJ\fP, applied
to an expression containing #I, will return the complex conjugate of the
expression. In addition, a variable may stand for itself and be declared
complex with the function 
\*BCOMPLEX\fP; the declaration may be removed
with 
\*BNOCOMPLEX\fP. Conjugation of these quantities causes them to
be printed with a bar over the name. The functions 
\*BRE\fP, \*BIM\fP, \*BCMOD\fP and  \*BRAT\fP compute the real part,
imaginary part,
modulus and rationalization of the expression, respectively.
.sp 3
.sh 2
\*BExtended Differentiation\fP
.pp
The normal muMATH differentiation routine has been extended to include
implicit chain derivatives. If a variable is made to depend on another
(with DEPENDS), and that variable depends on a third, then differentiation
of the first variable with respect to the third will set up the correct
chain derivatives. For example,
.in 3
.nf
.(b M
.ls 2
? DEPENDS (u(r), v(u));
@: TRUE
? DIF (v, r);
@: u\*Dr\*U v\*Du\*U
.)b
.in 0
.fi
.br
This can be done for any number of dependencies to any level.
.pp
Additionally, the functions 
\*BGRADEF\fP and 
\*BGRADV\fP can be used
to define explicit derivatives. 
\*BGRADEF\fP defines the dependencies
of its first argument, using the pairs of following arguments. Each pair
consists of a variable that the first argument is to depend on, and the
value that the derivative will have. This value may be symbolic or a
muMATH expression. 
\*BGRADV\fP
is used to give a value to its argument;
it then evaluates all the derivatives defined by 
\*BGRADEF\fP
for the
object. For example,
.in 3
.nf
.(b M
.ls 2
? GRADEF (f, r, fr);    % define a gradient for f %
@: f
? DIF (f,r);
@: fr
? GRADV (f, r^2);       % give f a value %
@: f
? fr;                   % the gradients are evaluated %
@: 2 r
? GRADV ('f, 'f);       % remove the value %
@: f
.)b
.in 0
.fi
.sp 3
.sh 2
\*BLet Rules\fP
.pp
Simple 
\*BLET\fP
rules similar to but much less powerful than those in REDUCE
have been implemented in muTENSOR. The function 
\*BLET\fP defines a rule
to replace its first argument in terms of its second. 
\*BUNLET\fP removes
such a rule. When an expression is passed to 
\*BEVSUBLET\fP or 
\*BSUBLET\fP 
all defined replacement rules are substituted (non-recursively) in the
expression. 
\*BEVSUBLET\fP then evaluates the result, 
\*BSUBLET\fP does not. 
\*BLET\fP
rules are particularly useful for substituting for various
powers of a quantity. For example,
.in 3
.nf
.(b M
.ls 2
? LET (a^2, b);
@: b
? EVSUBLET (a+a^2+a^3+a^4);
@: a + b + a b + b\*U2\*D
.)b
.pg
